/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.ext.render.RenderPoint;

public class RenderCurve
extends GraphicalPrimitive1D {
    private static final long serialVersionUID = -1941713884972334826L;
    protected String startHead;
    protected String endHead;
    protected ListOf<RenderPoint> listOfElements;

    public RenderCurve() {
        this.initDefaults();
    }

    public RenderCurve(RenderCurve obj) {
        this.startHead = obj.startHead;
        this.endHead = obj.endHead;
        if (obj.isSetListOfElements()) {
            this.setListOfElements((ListOf<RenderPoint>)obj.getListOfElements().clone());
        }
    }

    @Override
    public RenderCurve clone() {
        return new RenderCurve(this);
    }

    @Override
    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
    }

    @Override
    public int hashCode() {
        int prime = 3119;
        int result = super.hashCode();
        result = 3119 * result + (this.endHead == null ? 0 : this.endHead.hashCode());
        result = 3119 * result + (this.listOfElements == null ? 0 : this.listOfElements.hashCode());
        result = 3119 * result + (this.startHead == null ? 0 : this.startHead.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RenderCurve other = (RenderCurve)((Object)obj);
        if (this.endHead == null ? other.endHead != null : !this.endHead.equals(other.endHead)) {
            return false;
        }
        if (this.listOfElements == null ? other.listOfElements != null : !this.listOfElements.equals(other.listOfElements)) {
            return false;
        }
        return !(this.startHead == null ? other.startHead != null : !this.startHead.equals(other.startHead));
    }

    public String getStartHead() {
        if (this.isSetStartHead()) {
            return this.startHead;
        }
        throw new PropertyUndefinedError("start-head", (SBase)this);
    }

    public boolean isSetStartHead() {
        return this.startHead != null;
    }

    public void setStartHead(String startHead) {
        String oldStartHead = this.startHead;
        this.startHead = startHead;
        this.firePropertyChange("start-head", oldStartHead, this.startHead);
    }

    public boolean unsetStartHead() {
        if (this.isSetStartHead()) {
            String oldStartHead = this.startHead;
            this.startHead = null;
            this.firePropertyChange("start-head", oldStartHead, this.startHead);
            return true;
        }
        return false;
    }

    public String getEndHead() {
        if (this.isSetEndHead()) {
            return this.endHead;
        }
        throw new PropertyUndefinedError("end-head", (SBase)this);
    }

    public boolean isSetEndHead() {
        return this.endHead != null;
    }

    public void setEndHead(String endHead) {
        String oldEndHead = this.endHead;
        this.endHead = endHead;
        this.firePropertyChange("end-head", oldEndHead, this.endHead);
    }

    public boolean unsetEndHead() {
        if (this.isSetEndHead()) {
            String oldEndHead = this.endHead;
            this.endHead = null;
            this.firePropertyChange("end-head", oldEndHead, this.endHead);
            return true;
        }
        return false;
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null && !this.listOfElements.isEmpty();
    }

    public ListOf<RenderPoint> getListOfElements() {
        if (!this.isSetListOfElements()) {
            this.listOfElements = new ListOf(this.getLevel(), this.getVersion());
            this.listOfElements.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
            this.listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
        return this.listOfElements;
    }

    public void setListOfElements(ListOf<RenderPoint> listOfElements) {
        this.unsetListOfElements();
        this.listOfElements = listOfElements;
        this.registerChild((SBase)this.listOfElements);
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<RenderPoint> oldElements = this.listOfElements;
            this.listOfElements = null;
            oldElements.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addElement(RenderPoint element) {
        return this.getListOfElements().add((SBase)element);
    }

    public boolean removeElement(RenderPoint element) {
        if (this.isSetListOfElements()) {
            return this.getListOfElements().remove((Object)element);
        }
        return false;
    }

    public void removeElement(int i) {
        if (!this.isSetListOfElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfElements().remove(i);
    }

    public RenderPoint createElement() {
        return this.createElement(null);
    }

    public RenderPoint createElement(String id) {
        RenderPoint element = new RenderPoint();
        this.addElement(element);
        return element;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetStartHead()) {
            attributes.remove("start-head");
            attributes.put("render:start-head", this.getStartHead());
        }
        if (this.isSetEndHead()) {
            attributes.remove("end-head");
            attributes.put("render:end-head", this.getEndHead());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("start-head")) {
                this.setStartHead(value);
            } else if (attributeName.equals("end-head")) {
                this.setEndHead(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

