/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.FontFamily;
import org.sbml.jsbml.ext.render.FontRenderStyle;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.ext.render.Point3D;
import org.sbml.jsbml.ext.render.TextAnchor;
import org.sbml.jsbml.ext.render.VTextAnchor;
import org.sbml.jsbml.ext.render.XMLTools;

public class Text
extends GraphicalPrimitive1D
implements FontRenderStyle,
Point3D {
    private static final long serialVersionUID = -7468181076596795203L;
    private Boolean absoluteX;
    private Boolean absoluteY;
    private Boolean absoluteZ;
    private FontFamily fontFamily;
    private Short fontSize;
    private Boolean fontWeightBold;
    private Boolean fontStyleItalic;
    private TextAnchor textAnchor;
    private VTextAnchor vTextAnchor;
    private Double x;
    private Double y;
    private Double z;

    @Override
    public FontFamily getFontFamily() {
        if (this.isSetFontFamily()) {
            return this.fontFamily;
        }
        throw new PropertyUndefinedError("font-family", (SBase)this);
    }

    @Override
    public short getFontSize() {
        if (this.isSetFontSize()) {
            return this.fontSize;
        }
        throw new PropertyUndefinedError("font-size", (SBase)this);
    }

    @Override
    public TextAnchor getTextAnchor() {
        if (this.isSetTextAnchor()) {
            return this.textAnchor;
        }
        throw new PropertyUndefinedError("text-anchor", (SBase)this);
    }

    @Override
    public VTextAnchor getVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            return this.vTextAnchor;
        }
        throw new PropertyUndefinedError("vtext-anchor", (SBase)this);
    }

    @Override
    public double getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    @Override
    public double getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    @Override
    public double getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    @Override
    public boolean isAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            return this.absoluteX;
        }
        throw new PropertyUndefinedError("absolute-x", (SBase)this);
    }

    @Override
    public boolean isAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            return this.absoluteY;
        }
        throw new PropertyUndefinedError("absolute-y", (SBase)this);
    }

    @Override
    public boolean isAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            return this.absoluteZ;
        }
        throw new PropertyUndefinedError("absolute-z", (SBase)this);
    }

    @Override
    public boolean isFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            return this.fontStyleItalic;
        }
        throw new PropertyUndefinedError("font-style", (SBase)this);
    }

    @Override
    public boolean isFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            return this.fontWeightBold;
        }
        throw new PropertyUndefinedError("font-weight", (SBase)this);
    }

    @Override
    public boolean isSetAbsoluteX() {
        return this.absoluteX != null;
    }

    @Override
    public boolean isSetAbsoluteY() {
        return this.absoluteY != null;
    }

    @Override
    public boolean isSetAbsoluteZ() {
        return this.absoluteZ != null;
    }

    @Override
    public boolean isSetFontFamily() {
        return this.fontFamily != null;
    }

    @Override
    public boolean isSetFontSize() {
        return this.fontSize != null;
    }

    @Override
    public boolean isSetFontStyleItalic() {
        return this.fontStyleItalic != null;
    }

    @Override
    public boolean isSetFontWeightBold() {
        return this.fontWeightBold != null;
    }

    @Override
    public boolean isSetTextAnchor() {
        return this.textAnchor != null;
    }

    @Override
    public boolean isSetVTextAnchor() {
        return this.vTextAnchor != null;
    }

    @Override
    public boolean isSetX() {
        return this.x != null;
    }

    @Override
    public boolean isSetY() {
        return this.y != null;
    }

    @Override
    public boolean isSetZ() {
        return this.z != null;
    }

    @Override
    public void setAbsoluteX(Boolean absoluteX) {
        Boolean oldAbsoluteX = this.absoluteX;
        this.absoluteX = absoluteX;
        this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
    }

    @Override
    public void setAbsoluteY(Boolean absoluteY) {
        Boolean oldAbsoluteY = this.absoluteY;
        this.absoluteY = absoluteY;
        this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
    }

    @Override
    public void setAbsoluteZ(Boolean absoluteZ) {
        Boolean oldAbsoluteZ = this.absoluteZ;
        this.absoluteZ = absoluteZ;
        this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
    }

    @Override
    public void setFontFamily(FontFamily fontFamily) {
        FontFamily oldFontFamily = this.fontFamily;
        this.fontFamily = fontFamily;
        this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
    }

    @Override
    public void setFontSize(short fontSize) {
        Short oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange("font-size", oldFontSize, this.fontSize);
    }

    @Override
    public void setFontStyleItalic(boolean fontStyleItalic) {
        Boolean oldFontStyleItalic = this.fontStyleItalic;
        this.fontStyleItalic = fontStyleItalic;
        this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
    }

    @Override
    public void setFontWeightBold(boolean fontWeightBold) {
        Boolean oldFontWeightBold = this.fontWeightBold;
        this.fontWeightBold = fontWeightBold;
        this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
    }

    @Override
    public void setTextAnchor(TextAnchor textAnchor) {
        TextAnchor oldTextAnchor = this.textAnchor;
        this.textAnchor = textAnchor;
        this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
    }

    @Override
    public void setVTextAnchor(VTextAnchor vTextAnchor) {
        VTextAnchor oldVTextAnchor = this.vTextAnchor;
        this.vTextAnchor = vTextAnchor;
        this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
    }

    @Override
    public void setX(Double x) {
        Double oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", oldX, this.x);
    }

    @Override
    public void setY(Double y) {
        Double oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", oldY, this.y);
    }

    @Override
    public void setZ(Double z) {
        Double oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", oldZ, this.z);
    }

    @Override
    public boolean unsetAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            Boolean oldAbsoluteX = this.absoluteX;
            this.absoluteX = null;
            this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            Boolean oldAbsoluteY = this.absoluteY;
            this.absoluteY = null;
            this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            Boolean oldAbsoluteZ = this.absoluteZ;
            this.absoluteZ = null;
            this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontFamily() {
        if (this.isSetFontFamily()) {
            FontFamily oldFontFamily = this.fontFamily;
            this.fontFamily = null;
            this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontSize() {
        if (this.isSetFontSize()) {
            Short oldFontSize = this.fontSize;
            this.fontSize = null;
            this.firePropertyChange("font-size", oldFontSize, this.fontSize);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            Boolean oldFontStyleItalic = this.fontStyleItalic;
            this.fontStyleItalic = null;
            this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            Boolean oldFontWeightBold = this.fontWeightBold;
            this.fontWeightBold = null;
            this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetTextAnchor() {
        if (this.isSetTextAnchor()) {
            TextAnchor oldTextAnchor = this.textAnchor;
            this.textAnchor = null;
            this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            VTextAnchor oldVTextAnchor = this.vTextAnchor;
            this.vTextAnchor = null;
            this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetX() {
        if (this.isSetX()) {
            Double oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", oldX, this.x);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetY() {
        if (this.isSetY()) {
            Double oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", oldY, this.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetZ() {
        if (this.isSetZ()) {
            Double oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", oldZ, this.z);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetFontFamily()) {
            attributes.remove("font-family");
            attributes.put("render:font-family", this.getFontFamily().toString().toLowerCase());
        }
        if (this.isSetTextAnchor()) {
            attributes.remove("text-anchor");
            attributes.put("render:text-anchor", this.getTextAnchor().toString().toLowerCase());
        }
        if (this.isSetVTextAnchor()) {
            attributes.remove("vtext-anchor");
            attributes.put("render:vtext-anchor", this.getVTextAnchor().toString().toLowerCase());
        }
        if (this.isSetFontSize()) {
            attributes.remove("font-size");
            attributes.put("render:font-size", Short.toString(this.getFontSize()));
        }
        if (this.isSetX()) {
            attributes.remove("x");
            attributes.put("render:x", XMLTools.positioningToString(this.getX(), this.isAbsoluteX()));
        }
        if (this.isSetY()) {
            attributes.remove("y");
            attributes.put("render:y", XMLTools.positioningToString(this.getY(), this.isAbsoluteY()));
        }
        if (this.isSetZ()) {
            attributes.remove("z");
            attributes.put("render:z", XMLTools.positioningToString(this.getZ(), this.isAbsoluteZ()));
        }
        if (this.isSetFontStyleItalic()) {
            attributes.remove("font-style");
            attributes.put("font-style", XMLTools.fontStyleItalicToString(this.isFontStyleItalic()));
        }
        if (this.isSetFontWeightBold()) {
            attributes.remove("font-weight");
            attributes.put("font-weight", XMLTools.fontWeightBoldToString(this.isFontWeightBold()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("font-family")) {
                this.setFontFamily(FontFamily.valueOf(value.toUpperCase()));
            } else if (attributeName.equals("text-anchor")) {
                this.setTextAnchor(TextAnchor.valueOf(value.toUpperCase()));
            } else if (attributeName.equals("vtext-anchor")) {
                this.setVTextAnchor(VTextAnchor.valueOf(value.toUpperCase()));
            } else if (attributeName.equals("font-size")) {
                this.setFontSize(Short.valueOf(value));
            } else if (attributeName.equals("x")) {
                this.setX(XMLTools.parsePosition(value));
                this.setAbsoluteX(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y")) {
                this.setY(XMLTools.parsePosition(value));
                this.setAbsoluteY(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z")) {
                this.setZ(XMLTools.parsePosition(value));
                this.setAbsoluteZ(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("font-style")) {
                this.setFontStyleItalic(XMLTools.parseFontStyleItalic(value));
            } else if (attributeName.equals("font-weight")) {
                this.setFontWeightBold(XMLTools.parseFontWeightBold(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

