/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Arrays;
import java.util.Map;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.XMLTools;

public class Transformation
extends AbstractSBase {
    private static final long serialVersionUID = 1845276761656867150L;
    protected Double[] transform;

    public Transformation() {
        this.initDefaults();
    }

    public Transformation(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Transformation(Transformation obj) {
        super((SBase)obj);
        this.transform = obj.transform;
    }

    public Transformation clone() {
        return new Transformation(this);
    }

    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
    }

    public int hashCode() {
        int prime = 3191;
        int result = super.hashCode();
        result = 3191 * result + Arrays.hashCode((Object[])this.transform);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Transformation other = (Transformation)((Object)obj);
        return Arrays.equals((Object[])this.transform, (Object[])other.transform);
    }

    public String toString() {
        return "Transformation [transform=" + Arrays.toString((Object[])this.transform) + "]";
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetTransform()) {
            attributes.put("render:transform", XMLTools.encodeArrayDoubleToString(this.transform));
        }
        return attributes;
    }

    private boolean isSetTransform() {
        return this.transform != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("transform")) {
                this.setTransform(XMLTools.decodeStringToArrayDouble(value));
            }
        }
        return isAttributeRead;
    }

    private void setTransform(Double[] transform) {
        Double[] oldTransform = this.transform;
        this.transform = transform;
        this.firePropertyChange("transform", oldTransform, this.transform);
    }
}

