/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.ext.render.GlobalRenderInformation;
import org.sbml.jsbml.ext.render.GradientBase;
import org.sbml.jsbml.ext.render.GradientStop;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.LocalRenderInformation;
import org.sbml.jsbml.ext.render.Polygon;
import org.sbml.jsbml.ext.render.RenderConstants;
import org.sbml.jsbml.ext.render.RenderCurve;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.ext.render.RenderLayoutPlugin;
import org.sbml.jsbml.ext.render.RenderListOfLayoutsPlugin;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.ext.render.Style;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;

public class RenderParser
extends AbstractReaderWriter
implements PackageParser {
    private static final Logger logger = Logger.getLogger(RenderParser.class);

    public String getShortLabel() {
        return "render";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/render/version1";
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        logger.debug((Object)("logger called, " + prefix + ":" + elementName + " in context of: " + contextObject.toString()));
        if (contextObject instanceof LayoutModelPlugin) {
            LayoutModelPlugin layoutModel = (LayoutModelPlugin)contextObject;
            ListOf listOfLayouts = layoutModel.getListOfLayouts();
            ListOf<GlobalRenderInformation> newElement = null;
            if (elementName.equals(RenderConstants.listOfGlobalRenderInformation)) {
                RenderListOfLayoutsPlugin renderPlugin = new RenderListOfLayoutsPlugin((ListOf<Layout>)listOfLayouts);
                listOfLayouts.addExtension("http://www.sbml.org/sbml/level3/version1/render/version1", (SBasePlugin)renderPlugin);
                newElement = renderPlugin.getListOfGlobalRenderInformation();
            }
            if (newElement != null) {
                listOfLayouts.registerChild(newElement);
                return newElement;
            }
        } else if (contextObject instanceof Layout) {
            Layout layout = (Layout)contextObject;
            ListOf<LocalRenderInformation> newElement = null;
            if (elementName.equals(RenderConstants.listOfLocalRenderInformation)) {
                RenderLayoutPlugin renderPlugin = new RenderLayoutPlugin(layout);
                layout.addExtension("http://www.sbml.org/sbml/level3/version1/render/version1", (SBasePlugin)renderPlugin);
                newElement = renderPlugin.getListOfLocalRenderInformation();
            }
            if (newElement != null) {
                layout.registerChild(newElement);
                return newElement;
            }
        } else if (contextObject instanceof RenderInformationBase) {
            RenderInformationBase renderInformation = (RenderInformationBase)((Object)contextObject);
            Object newElement = null;
            if (elementName.equals("listOfGradientDefinitions")) {
                newElement = renderInformation.getListOfGradientDefintions();
            }
            if (elementName.equals("listOfColorDefinitions")) {
                newElement = renderInformation.getListOfColorDefinitions();
            }
            if (elementName.equals("listOfLineEndings")) {
                newElement = renderInformation.getListOfLineEndings();
            }
            if (renderInformation instanceof GlobalRenderInformation) {
                GlobalRenderInformation globalRenderInformation = (GlobalRenderInformation)renderInformation;
                if (elementName.equals("listOfStyles")) {
                    newElement = globalRenderInformation.getListOfStyles();
                }
            }
            if (renderInformation instanceof LocalRenderInformation) {
                LocalRenderInformation localRenderInformation = (LocalRenderInformation)renderInformation;
                if (elementName.equals("listOfLocalStyles")) {
                    newElement = localRenderInformation.getListOfLocalStyles();
                }
            }
            if (newElement != null) {
                renderInformation.registerChild((SBase)newElement);
                return newElement;
            }
        } else if (contextObject instanceof Style) {
            Style style = (Style)((Object)contextObject);
            if (elementName.equals("g")) {
                RenderGroup g = new RenderGroup();
                style.setGroup(g);
                return g;
            }
        } else if (contextObject instanceof Polygon) {
            Polygon polygon = (Polygon)((Object)contextObject);
            ListOf<RenderPoint> newElement = null;
            if (elementName.equals("list-of-elements")) {
                newElement = polygon.getListOfElements();
            }
            if (newElement != null) {
                polygon.registerChild((SBase)newElement);
                return newElement;
            }
        } else if (contextObject instanceof LineEnding) {
            LineEnding lineEnding = (LineEnding)((Object)contextObject);
            if (elementName.equals("bounding-box")) {
                BoundingBox bbox = new BoundingBox();
                lineEnding.setBoundingBox(bbox);
                return bbox;
            }
            if (elementName.equals("g")) {
                RenderGroup g = new RenderGroup();
                lineEnding.setGroup(g);
                return g;
            }
        } else if (contextObject instanceof RenderCurve) {
            RenderCurve curve = (RenderCurve)((Object)contextObject);
            ListOf<RenderPoint> newElement = null;
            if (elementName.equals("list-of-elements")) {
                newElement = curve.getListOfElements();
            }
            if (newElement != null) {
                curve.registerChild((SBase)newElement);
                return newElement;
            }
        } else if (contextObject instanceof GradientBase) {
            GradientBase gradientBase = (GradientBase)((Object)contextObject);
            ListOf<GradientStop> newElement = null;
            if (elementName.equals("listOfGradientStops")) {
                newElement = gradientBase.getListOfGradientStops();
            }
            if (newElement != null) {
                gradientBase.registerChild((SBase)newElement);
                return newElement;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            Object newElement = null;
            if (elementName.equals("renderPoint")) {
                newElement = new RenderPoint();
            } else if (elementName.equals("style")) {
                newElement = new Style();
            } else if (elementName.equals("gradientStop")) {
                newElement = new GradientStop();
            } else if (elementName.equals("colorDefinition")) {
                newElement = new ColorDefinition();
            } else if (elementName.equals("gradientBase")) {
                newElement = new GradientBase();
            } else if (elementName.equals("lineEnding")) {
                newElement = new LineEnding();
            } else if (elementName.equals("localRenderInformation")) {
                newElement = new LocalRenderInformation();
            } else if (elementName.equals("globalRenderInformation")) {
                newElement = new GlobalRenderInformation();
            }
            if (newElement != null) {
                listOf.registerChild((SBase)newElement);
                listOf.add((SBase)newElement);
            }
            return newElement;
        }
        return contextObject;
    }

    public List<String> getNamespaces() {
        return RenderConstants.namespaces_L3;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Layout) {
                return new RenderLayoutPlugin((Layout)sbase);
            }
            if (sbase instanceof ListOf && sbase.getElementName().equals("listOfLayouts")) {
                return new RenderListOfLayoutsPlugin((ListOf<Layout>)((ListOf)sbase));
            }
        }
        return null;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/render/version1";
        }
        return null;
    }

    public List<String> getPackageNamespaces() {
        return RenderConstants.namespaces_L3;
    }

    public String getPackageName() {
        return this.getShortLabel();
    }

    public boolean isRequired() {
        return false;
    }
}

