/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.ext.render.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalRenderInformation
extends RenderInformationBase {
    private static final long serialVersionUID = 855680727119080659L;
    private ListOf<Style> listOfStyles;

    public GlobalRenderInformation() {
        this.initDefaults();
    }

    public GlobalRenderInformation(GlobalRenderInformation obj) {
        super(obj);
        if (obj.isSetListOfStyles()) {
            this.setListOfStyles((ListOf<Style>)obj.getListOfStyles().clone());
        }
    }

    public GlobalRenderInformation(int level, int version) {
        this(null, null, level, version);
    }

    public GlobalRenderInformation(String id) {
        super(id);
        this.initDefaults();
    }

    public GlobalRenderInformation(String id, int level, int version) {
        this(id, null, level, version);
    }

    public GlobalRenderInformation(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    @Override
    public GlobalRenderInformation clone() {
        return new GlobalRenderInformation(this);
    }

    @Override
    public void initDefaults() {
    }

    @Override
    public int hashCode() {
        int prime = 3067;
        int result = super.hashCode();
        result = 3067 * result + (this.listOfStyles == null ? 0 : this.listOfStyles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GlobalRenderInformation other = (GlobalRenderInformation)((Object)obj);
        return !(this.listOfStyles == null ? other.listOfStyles != null : !this.listOfStyles.equals(other.listOfStyles));
    }

    public boolean isSetListOfStyles() {
        return this.listOfStyles != null && !this.listOfStyles.isEmpty();
    }

    public ListOf<Style> getListOfStyles() {
        if (!this.isSetListOfStyles()) {
            this.listOfStyles = new ListOf(this.getLevel(), this.getVersion());
            this.listOfStyles.setPackageVersion(-1);
            this.listOfStyles.setPackageName(null);
            this.listOfStyles.setPackageName("render");
            this.listOfStyles.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfStyles);
        }
        return this.listOfStyles;
    }

    public void setListOfStyles(ListOf<Style> listOfStyles) {
        this.unsetListOfStyles();
        this.listOfStyles = listOfStyles;
        if (listOfStyles != null) {
            listOfStyles.setPackageVersion(-1);
            listOfStyles.setPackageName(null);
            listOfStyles.setPackageName("render");
            listOfStyles.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfStyles);
        }
    }

    public boolean unsetListOfStyles() {
        if (this.isSetListOfStyles()) {
            ListOf<Style> oldStyles = this.listOfStyles;
            this.listOfStyles = null;
            oldStyles.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addStyle(Style style) {
        return this.getListOfStyles().add((SBase)style);
    }

    public boolean removeStyle(Style style) {
        if (this.isSetListOfStyles()) {
            return this.getListOfStyles().remove((NamedSBase)style);
        }
        return false;
    }

    public void removeStyle(int i) {
        if (!this.isSetListOfStyles()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfStyles().remove(i);
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfStyles()) {
            ++count;
        }
        return count;
    }

    @Override
    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfColorDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfColorDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfGradientDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfGradientDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfLineEndings()) {
            if (pos == childIndex) {
                return this.getListOfLineEndings();
            }
            ++pos;
        }
        if (this.isSetListOfStyles()) {
            if (pos == childIndex) {
                return this.getListOfStyles();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        return isAttributeRead;
    }
}

