/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.GraphicalPrimitive2D;
import org.sbml.jsbml.ext.render.RenderPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
extends GraphicalPrimitive2D {
    private static final long serialVersionUID = 9207043017589271103L;
    private ListOf<RenderPoint> listOfElements;

    public Polygon() {
        this.initDefaults();
    }

    public Polygon(Polygon obj) {
        super(obj);
        if (obj.isSetListOfElements()) {
            this.setListOfElements((ListOf<RenderPoint>)obj.getListOfElements().clone());
        }
    }

    public boolean addElement(RenderPoint element) {
        return this.getListOfElements().add((SBase)element);
    }

    @Override
    public Polygon clone() {
        return new Polygon(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfElements()) {
            if (pos == childIndex) {
                return this.getListOfElements();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfElements()) {
            ++count;
        }
        return count;
    }

    public ListOf<RenderPoint> getListOfElements() {
        if (!this.isSetListOfElements()) {
            this.listOfElements = new ListOf(this.getLevel(), this.getVersion());
            this.listOfElements.setPackageVersion(-1);
            this.listOfElements.setPackageName(null);
            this.listOfElements.setPackageName("render");
            this.listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
        return this.listOfElements;
    }

    @Override
    public void initDefaults() {
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null;
    }

    public void setListOfElements(ListOf<RenderPoint> listOfElements) {
        this.unsetListOfElements();
        this.listOfElements = listOfElements;
        if (listOfElements != null) {
            listOfElements.setPackageVersion(-1);
            listOfElements.setPackageName(null);
            listOfElements.setPackageName("render");
            listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<RenderPoint> oldListOfElements = this.listOfElements;
            this.listOfElements = null;
            this.firePropertyChange("list-of-elements", oldListOfElements, this.listOfElements);
            return true;
        }
        return false;
    }
}

