/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.Point3D;
import org.sbml.jsbml.ext.render.XMLTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPoint
extends AbstractSBase
implements Point3D {
    private static final long serialVersionUID = 6792387139122188270L;
    private Boolean absoluteX;
    private Boolean absoluteY;
    private Boolean absoluteZ;
    private Double x;
    private Double y;
    private Double z;

    public RenderPoint() {
        this.initDefaults();
    }

    public RenderPoint(RenderPoint obj) {
        super((SBase)obj);
        this.absoluteX = obj.absoluteX;
        this.absoluteY = obj.absoluteY;
        this.absoluteZ = obj.absoluteZ;
        this.x = obj.x;
        this.y = obj.y;
        this.z = obj.z;
    }

    public RenderPoint clone() {
        return new RenderPoint(this);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        return 0;
    }

    @Override
    public double getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    @Override
    public double getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    @Override
    public double getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.z = 0.0;
    }

    @Override
    public boolean isAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            return this.absoluteX;
        }
        throw new PropertyUndefinedError("absolute-x", (SBase)this);
    }

    @Override
    public boolean isAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            return this.absoluteY;
        }
        throw new PropertyUndefinedError("absolute-y", (SBase)this);
    }

    @Override
    public boolean isAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            return this.absoluteZ;
        }
        throw new PropertyUndefinedError("absolute-z", (SBase)this);
    }

    @Override
    public boolean isSetAbsoluteX() {
        return this.absoluteX != null;
    }

    @Override
    public boolean isSetAbsoluteY() {
        return this.absoluteY != null;
    }

    @Override
    public boolean isSetAbsoluteZ() {
        return this.absoluteZ != null;
    }

    @Override
    public boolean isSetX() {
        return this.x != null;
    }

    @Override
    public boolean isSetY() {
        return this.y != null;
    }

    @Override
    public boolean isSetZ() {
        return this.z != null;
    }

    @Override
    public void setAbsoluteX(boolean absoluteX) {
        Boolean oldAbsoluteX = this.absoluteX;
        this.absoluteX = absoluteX;
        this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
    }

    @Override
    public void setAbsoluteY(boolean absoluteY) {
        Boolean oldAbsoluteY = this.absoluteY;
        this.absoluteY = absoluteY;
        this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
    }

    @Override
    public void setAbsoluteZ(boolean absoluteZ) {
        Boolean oldAbsoluteZ = this.absoluteZ;
        this.absoluteZ = absoluteZ;
        this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
    }

    @Override
    public void setX(double x) {
        Double oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", oldX, this.x);
    }

    @Override
    public void setY(double y) {
        Double oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", oldY, this.y);
    }

    @Override
    public void setZ(double z) {
        Double oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", oldZ, this.z);
    }

    public String toString() {
        return null;
    }

    @Override
    public boolean unsetAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            Boolean oldAbsoluteX = this.absoluteX;
            this.absoluteX = null;
            this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            Boolean oldAbsoluteY = this.absoluteY;
            this.absoluteY = null;
            this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            Boolean oldAbsoluteZ = this.absoluteZ;
            this.absoluteZ = null;
            this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetX() {
        if (this.isSetX()) {
            Double oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", oldX, this.x);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetY() {
        if (this.isSetY()) {
            Double oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", oldY, this.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetZ() {
        if (this.isSetZ()) {
            Double oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", oldZ, this.z);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetX()) {
            attributes.remove("x");
            attributes.put("render:x", XMLTools.positioningToString(this.getX(), this.isAbsoluteX()));
        }
        if (this.isSetY()) {
            attributes.remove("y");
            attributes.put("render:y", XMLTools.positioningToString(this.getY(), this.isAbsoluteY()));
        }
        if (this.isSetZ()) {
            attributes.remove("z");
            attributes.put("render:z", XMLTools.positioningToString(this.getZ(), this.isAbsoluteZ()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("x")) {
                this.setX(XMLTools.parsePosition(value));
                this.setAbsoluteX(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y")) {
                this.setY(XMLTools.parsePosition(value));
                this.setAbsoluteY(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z")) {
                this.setZ(XMLTools.parsePosition(value));
                this.setAbsoluteZ(XMLTools.isAbsolutePosition(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

