/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.ext.render.XMLTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Style
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -4660813321564690910L;
    protected RenderGroup group;
    protected String[] roleList;
    protected String[] typeList;

    public Style() {
        this.initDefaults();
    }

    public Style(RenderGroup group) {
        this.setGroup(group);
        this.initDefaults();
    }

    public Style(int level, int version, RenderGroup group) {
        this(null, level, version, group);
    }

    public Style(String id, int level, int version, RenderGroup group) {
        super(id, level, version);
        this.initDefaults();
        this.setGroup(group);
    }

    public Style(Style obj) {
        super((AbstractNamedSBase)obj);
        this.roleList = obj.roleList;
        this.typeList = obj.typeList;
        if (obj.isSetGroup()) {
            this.setGroup(obj.getGroup().clone());
        }
    }

    public Style clone() {
        return new Style(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetGroup()) {
            if (pos == index) {
                return this.getGroup();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetGroup()) {
            ++count;
        }
        return count;
    }

    public RenderGroup getGroup() {
        if (this.isSetGroup()) {
            return this.group;
        }
        throw new PropertyUndefinedError("g", (SBase)this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.roleList = null;
        this.typeList = null;
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isSetGroup() {
        return this.group != null;
    }

    public void setGroup(RenderGroup group) {
        this.unsetGroup();
        this.group = group;
        this.registerChild((SBase)group);
    }

    public String toString() {
        return "Style [group=" + (Object)((Object)this.group) + ", roleList=" + Arrays.toString(this.roleList) + ", typeList=" + Arrays.toString(this.typeList) + "]";
    }

    public int hashCode() {
        int prime = 3083;
        int result = super.hashCode();
        result = 3083 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 3083 * result + Arrays.hashCode(this.roleList);
        result = 3083 * result + Arrays.hashCode(this.typeList);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)((Object)obj);
        if (this.group == null ? other.group != null : !this.group.equals((Object)other.group)) {
            return false;
        }
        if (!Arrays.equals(this.roleList, other.roleList)) {
            return false;
        }
        return Arrays.equals(this.typeList, other.typeList);
    }

    public boolean unsetGroup() {
        if (this.isSetGroup()) {
            RenderGroup oldGroup = this.group;
            this.group = null;
            oldGroup.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public String[] getRoleList() {
        if (this.isSetRoleList()) {
            return this.roleList;
        }
        throw new PropertyUndefinedError("roleList", (SBase)this);
    }

    public boolean isSetRoleList() {
        return this.roleList != null;
    }

    public void setRoleList(String[] roleList) {
        String[] oldRoleList = this.roleList;
        this.roleList = roleList;
        this.firePropertyChange("roleList", oldRoleList, this.roleList);
    }

    public String[] getTypeList() {
        if (this.isSetTypeList()) {
            return this.typeList;
        }
        throw new PropertyUndefinedError("typeList", (SBase)this);
    }

    public boolean isSetTypeList() {
        return this.typeList != null;
    }

    public void setTypeList(String[] typeList) {
        String[] oldTypeList = this.typeList;
        this.typeList = typeList;
        this.firePropertyChange("typeList", oldTypeList, this.typeList);
    }

    public boolean unsetTypeList() {
        if (this.isSetTypeList()) {
            String[] oldTypeList = this.typeList;
            this.typeList = null;
            this.firePropertyChange("typeList", oldTypeList, this.typeList);
            return true;
        }
        return false;
    }

    public boolean unsetRoleList() {
        if (this.isSetRoleList()) {
            String[] oldRoleList = this.roleList;
            this.roleList = null;
            this.firePropertyChange("roleList", oldRoleList, this.roleList);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetRoleList()) {
            attributes.remove("roleList");
            attributes.put("render:roleList", XMLTools.arrayToWhitespaceSeparatedString(this.getRoleList()));
        }
        if (this.isSetTypeList()) {
            attributes.remove("typeList");
            attributes.put("render:typeList", XMLTools.arrayToWhitespaceSeparatedString(this.getTypeList()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("roleList")) {
                this.setRoleList(value.split(" "));
            } else if (attributeName.equals("typeList")) {
                this.setTypeList(value.split(" "));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

