/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.ext.render.XMLTools;

public class RenderCubicBezier
extends RenderPoint {
    private static final long serialVersionUID = -2426257418589249467L;
    private Boolean absoluteX1;
    private Boolean absoluteY1;
    private Boolean absoluteZ1;
    private Boolean absoluteX2;
    private Boolean absoluteY2;
    private Boolean absoluteZ2;
    private Double x1;
    private Double y1;
    private Double z1;
    private Double x2;
    private Double y2;
    private Double z2;

    public RenderCubicBezier() {
        this.initDefaults();
    }

    public RenderCubicBezier(RenderCubicBezier obj) {
        super(obj);
        this.absoluteX1 = obj.absoluteX1;
        this.absoluteY1 = obj.absoluteY1;
        this.absoluteZ2 = obj.absoluteZ2;
        this.absoluteX2 = obj.absoluteX2;
        this.absoluteY2 = obj.absoluteY2;
        this.absoluteZ2 = obj.absoluteZ2;
        this.x1 = obj.x1;
        this.y1 = obj.y1;
        this.z1 = obj.z1;
        this.x2 = obj.x2;
        this.y2 = obj.y2;
        this.z2 = obj.z2;
    }

    @Override
    public RenderCubicBezier clone() {
        return new RenderCubicBezier(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    public double getX1() {
        if (this.isSetX1()) {
            return this.x1;
        }
        throw new PropertyUndefinedError("x1", (SBase)this);
    }

    public double getX2() {
        if (this.isSetX2()) {
            return this.x2;
        }
        throw new PropertyUndefinedError("x2", (SBase)this);
    }

    public double getY1() {
        if (this.isSetY1()) {
            return this.y1;
        }
        throw new PropertyUndefinedError("y1", (SBase)this);
    }

    public double getY2() {
        if (this.isSetY2()) {
            return this.y2;
        }
        throw new PropertyUndefinedError("y2", (SBase)this);
    }

    public double getZ1() {
        if (this.isSetZ1()) {
            return this.z1;
        }
        throw new PropertyUndefinedError("z1", (SBase)this);
    }

    public double getZ2() {
        if (this.isSetZ2()) {
            return this.z2;
        }
        throw new PropertyUndefinedError("z2", (SBase)this);
    }

    @Override
    public void initDefaults() {
        this.z1 = 0.0;
        this.z2 = 0.0;
    }

    public boolean isAbsoluteX1() {
        if (this.isSetAbsoluteX1()) {
            return this.absoluteX1;
        }
        throw new PropertyUndefinedError("absolute-x1", (SBase)this);
    }

    public boolean isAbsoluteX2() {
        if (this.isSetAbsoluteX2()) {
            return this.absoluteX2;
        }
        throw new PropertyUndefinedError("absolute-x2", (SBase)this);
    }

    public boolean isAbsoluteY1() {
        if (this.isSetAbsoluteY1()) {
            return this.absoluteY1;
        }
        throw new PropertyUndefinedError("absolute-y1", (SBase)this);
    }

    public boolean isAbsoluteY2() {
        if (this.isSetAbsoluteY2()) {
            return this.absoluteY2;
        }
        throw new PropertyUndefinedError("absolute-y2", (SBase)this);
    }

    public boolean isAbsoluteZ1() {
        if (this.isSetAbsoluteZ1()) {
            return this.absoluteZ1;
        }
        throw new PropertyUndefinedError("absolute-z1", (SBase)this);
    }

    public boolean isAbsoluteZ2() {
        if (this.isSetAbsoluteZ2()) {
            return this.absoluteZ2;
        }
        throw new PropertyUndefinedError("absolute-z2", (SBase)this);
    }

    public boolean isSetAbsoluteX1() {
        return this.absoluteX1 != null;
    }

    public boolean isSetAbsoluteX2() {
        return this.absoluteX2 != null;
    }

    public boolean isSetAbsoluteY1() {
        return this.absoluteY1 != null;
    }

    public boolean isSetAbsoluteY2() {
        return this.absoluteY2 != null;
    }

    public boolean isSetAbsoluteZ1() {
        return this.absoluteZ1 != null;
    }

    public boolean isSetAbsoluteZ2() {
        return this.absoluteZ2 != null;
    }

    public boolean isSetX1() {
        return this.x1 != null;
    }

    public boolean isSetX2() {
        return this.x2 != null;
    }

    public boolean isSetY1() {
        return this.y1 != null;
    }

    public boolean isSetY2() {
        return this.y2 != null;
    }

    public boolean isSetZ1() {
        return this.z1 != null;
    }

    public boolean isSetZ2() {
        return this.z2 != null;
    }

    public void setAbsoluteX1(boolean absoluteX1) {
        Boolean oldAbsoluteX1 = this.absoluteX1;
        this.absoluteX1 = absoluteX1;
        this.firePropertyChange("absolute-x1", oldAbsoluteX1, this.absoluteX1);
    }

    public void setAbsoluteX2(boolean absoluteX2) {
        Boolean oldAbsoluteX2 = this.absoluteX2;
        this.absoluteX2 = absoluteX2;
        this.firePropertyChange("absolute-x2", oldAbsoluteX2, this.absoluteX2);
    }

    public void setAbsoluteY1(boolean absoluteY1) {
        Boolean oldAbsoluteY1 = this.absoluteY1;
        this.absoluteY1 = absoluteY1;
        this.firePropertyChange("absolute-y1", oldAbsoluteY1, this.absoluteY1);
    }

    public void setAbsoluteY2(boolean absoluteY2) {
        Boolean oldAbsoluteY2 = this.absoluteY2;
        this.absoluteY2 = absoluteY2;
        this.firePropertyChange("absolute-y2", oldAbsoluteY2, this.absoluteY2);
    }

    public void setAbsoluteZ1(boolean absoluteZ1) {
        Boolean oldAbsoluteZ1 = this.absoluteZ1;
        this.absoluteZ1 = absoluteZ1;
        this.firePropertyChange("absolute-z1", oldAbsoluteZ1, this.absoluteZ1);
    }

    public void setAbsoluteZ2(boolean absoluteZ2) {
        Boolean oldAbsoluteZ2 = this.absoluteZ2;
        this.absoluteZ2 = absoluteZ2;
        this.firePropertyChange("absolute-z2", oldAbsoluteZ2, this.absoluteZ2);
    }

    public void setX1(double x1) {
        Double oldX1 = this.x1;
        this.x1 = x1;
        this.firePropertyChange("x1", oldX1, this.x1);
    }

    public void setX2(double x2) {
        Double oldX2 = this.x2;
        this.x2 = x2;
        this.firePropertyChange("x2", oldX2, this.x2);
    }

    public void setY1(double y1) {
        Double oldY1 = this.y1;
        this.y1 = y1;
        this.firePropertyChange("y1", oldY1, this.y1);
    }

    public void setY2(double y2) {
        Double oldY2 = this.y2;
        this.y2 = y2;
        this.firePropertyChange("y2", oldY2, this.y2);
    }

    public void setZ1(double z1) {
        Double oldZ1 = this.z1;
        this.z1 = z1;
        this.firePropertyChange("z1", oldZ1, this.z1);
    }

    public void setZ2(double z2) {
        Double oldZ2 = this.z2;
        this.z2 = z2;
        this.firePropertyChange("z2", oldZ2, this.z2);
    }

    public boolean unsetAbsoluteX1() {
        if (this.isSetAbsoluteX1()) {
            Boolean oldAbsoluteX1 = this.absoluteX1;
            this.absoluteX1 = null;
            this.firePropertyChange("absolute-x1", oldAbsoluteX1, this.absoluteX1);
            return true;
        }
        return false;
    }

    public boolean unsetAbsoluteX2() {
        if (this.isSetAbsoluteX2()) {
            Boolean oldAbsoluteX2 = this.absoluteX2;
            this.absoluteX2 = null;
            this.firePropertyChange("absolute-x2", oldAbsoluteX2, this.absoluteX2);
            return true;
        }
        return false;
    }

    public boolean unsetAbsoluteY1() {
        if (this.isSetAbsoluteY1()) {
            Boolean oldAbsoluteY1 = this.absoluteY1;
            this.absoluteY1 = null;
            this.firePropertyChange("absolute-y1", oldAbsoluteY1, this.absoluteY1);
            return true;
        }
        return false;
    }

    public boolean unsetAbsoluteY2() {
        if (this.isSetAbsoluteY2()) {
            Boolean oldAbsoluteY2 = this.absoluteY2;
            this.absoluteY2 = null;
            this.firePropertyChange("absolute-y2", oldAbsoluteY2, this.absoluteY2);
            return true;
        }
        return false;
    }

    public boolean unsetAbsoluteZ1() {
        if (this.isSetAbsoluteZ1()) {
            Boolean oldAbsoluteZ1 = this.absoluteZ1;
            this.absoluteZ1 = null;
            this.firePropertyChange("absolute-z1", oldAbsoluteZ1, this.absoluteZ1);
            return true;
        }
        return false;
    }

    public boolean unsetAbsoluteZ2() {
        if (this.isSetAbsoluteZ2()) {
            Boolean oldAbsoluteZ2 = this.absoluteZ2;
            this.absoluteZ2 = null;
            this.firePropertyChange("absolute-z2", oldAbsoluteZ2, this.absoluteZ2);
            return true;
        }
        return false;
    }

    public boolean unsetX1() {
        if (this.isSetX1()) {
            Double oldX1 = this.x1;
            this.x1 = null;
            this.firePropertyChange("x1", oldX1, this.x1);
            return true;
        }
        return false;
    }

    public boolean unsetX2() {
        if (this.isSetX2()) {
            Double oldX2 = this.x2;
            this.x2 = null;
            this.firePropertyChange("x2", oldX2, this.x2);
            return true;
        }
        return false;
    }

    public boolean unsetY1() {
        if (this.isSetY1()) {
            Double oldY1 = this.y1;
            this.y1 = null;
            this.firePropertyChange("y1", oldY1, this.y1);
            return true;
        }
        return false;
    }

    public boolean unsetY2() {
        if (this.isSetY2()) {
            Double oldY2 = this.y2;
            this.y2 = null;
            this.firePropertyChange("y2", oldY2, this.y2);
            return true;
        }
        return false;
    }

    public boolean unsetZ1() {
        if (this.isSetZ1()) {
            Double oldZ1 = this.z1;
            this.z1 = null;
            this.firePropertyChange("z1", oldZ1, this.z1);
            return true;
        }
        return false;
    }

    public boolean unsetZ2() {
        if (this.isSetZ2()) {
            Double oldZ2 = this.z2;
            this.z2 = null;
            this.firePropertyChange("z2", oldZ2, this.z2);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetX1()) {
            attributes.remove("x1");
            attributes.put("render:x1", XMLTools.positioningToString(this.getX1(), this.isAbsoluteX1()));
        }
        if (this.isSetX2()) {
            attributes.remove("x2");
            attributes.put("render:x2", XMLTools.positioningToString(this.getX2(), this.isAbsoluteX2()));
        }
        if (this.isSetY1()) {
            attributes.remove("y1");
            attributes.put("render:y1", XMLTools.positioningToString(this.getY1(), this.isAbsoluteY1()));
        }
        if (this.isSetY2()) {
            attributes.remove("y2");
            attributes.put("render:y2", XMLTools.positioningToString(this.getY2(), this.isAbsoluteY2()));
        }
        if (this.isSetZ1()) {
            attributes.remove("z1");
            attributes.put("render:z1", XMLTools.positioningToString(this.getZ1(), this.isAbsoluteZ1()));
        }
        if (this.isSetZ2()) {
            attributes.remove("z2");
            attributes.put("render:z2", XMLTools.positioningToString(this.getZ2(), this.isAbsoluteZ2()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("x1")) {
                this.setX1(XMLTools.parsePosition(value));
                this.setAbsoluteX1(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("x2")) {
                this.setX2(XMLTools.parsePosition(value));
                this.setAbsoluteX2(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y1")) {
                this.setY1(XMLTools.parsePosition(value));
                this.setAbsoluteY1(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y2")) {
                this.setY2(XMLTools.parsePosition(value));
                this.setAbsoluteY2(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z1")) {
                this.setZ1(XMLTools.parsePosition(value));
                this.setAbsoluteZ1(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z2")) {
                this.setZ2(XMLTools.parsePosition(value));
                this.setAbsoluteZ2(XMLTools.isAbsolutePosition(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

