/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.XMLTools;

public class GradientStop
extends AbstractSBase {
    private static final long serialVersionUID = 7400974339251884133L;
    private Double offset;
    private String stopColor;

    public GradientStop(Double offset, String stopColor) {
        this.initDefaults();
        this.offset = offset;
        this.stopColor = stopColor;
    }

    public GradientStop(Double offset, String stopColor, int level, int version) {
        super(level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
        this.offset = offset;
        this.stopColor = stopColor;
    }

    public GradientStop(GradientStop obj) {
        super((SBase)obj);
        this.offset = obj.offset;
        this.stopColor = obj.stopColor;
    }

    public GradientStop() {
        this.initDefaults();
    }

    public GradientStop clone() {
        return new GradientStop(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    public int hashCode() {
        int prime = 3191;
        int result = super.hashCode();
        result = 3191 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 3191 * result + (this.stopColor == null ? 0 : this.stopColor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GradientStop other = (GradientStop)((Object)obj);
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.stopColor == null ? other.stopColor != null : !this.stopColor.equals(other.stopColor));
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        return 0;
    }

    public String getElementName() {
        return "stop";
    }

    public double getOffset() {
        if (this.isSetOffset()) {
            return this.offset;
        }
        throw new PropertyUndefinedError("offset", (SBase)this);
    }

    public String getStopColor() {
        if (this.isSetStopColor()) {
            return this.stopColor;
        }
        throw new PropertyUndefinedError("stop-color", (SBase)this);
    }

    public boolean isSetOffset() {
        return this.offset != null;
    }

    public boolean isSetStopColor() {
        return this.stopColor != null;
    }

    public void setOffset(double offset) {
        Double oldOffset = this.offset;
        this.offset = offset;
        this.firePropertyChange("offset", oldOffset, this.offset);
    }

    public void setStopColor(String stopColor) {
        String oldStopColor = this.stopColor;
        this.stopColor = stopColor;
        this.firePropertyChange("stop-color", oldStopColor, this.stopColor);
    }

    public boolean unsetOffset() {
        if (this.isSetOffset()) {
            Double oldOffset = this.offset;
            this.offset = null;
            this.firePropertyChange("offset", oldOffset, this.offset);
            return true;
        }
        return false;
    }

    public boolean unsetStopColor() {
        if (this.isSetStopColor()) {
            String oldStopColor = this.stopColor;
            this.stopColor = null;
            this.firePropertyChange("stop-color", oldStopColor, this.stopColor);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetOffset()) {
            attributes.remove("offset");
            attributes.put("render:offset", XMLTools.positioningToString(this.getOffset(), false));
        }
        if (this.isSetStopColor()) {
            attributes.remove("stop-color");
            attributes.put("render:stop-color", this.getStopColor());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("offset")) {
                this.setOffset(XMLTools.parsePosition(value));
            } else if (attributeName.equals("stop-color")) {
                this.setStopColor(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

