/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.DefaultValues;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.util.StringTools;

public abstract class ListOfRenderInformation<T extends RenderInformationBase>
extends ListOf<T> {
    private Integer versionMajor;
    private Integer versionMinor;
    private DefaultValues defaultValues;

    public ListOfRenderInformation() {
        this.initDefaults();
    }

    public ListOfRenderInformation(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public ListOfRenderInformation(ListOfRenderInformation<?> obj) {
        super(obj);
        if (obj.isSetVersionMinor()) {
            this.setVersionMinor(obj.getVersionMinor());
        }
        if (obj.isSetVersionMajor()) {
            this.setVersionMajor(obj.getVersionMajor());
        }
    }

    public int hashCode() {
        int prime = 3041;
        int result = super.hashCode();
        result = 3041 * result + (this.versionMajor == null ? 0 : this.versionMajor.hashCode());
        result = 3041 * result + (this.versionMinor == null ? 0 : this.versionMinor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ListOfRenderInformation other = (ListOfRenderInformation)((Object)obj);
        if (this.versionMajor == null ? other.versionMajor != null : !this.versionMajor.equals(other.versionMajor)) {
            return false;
        }
        return !(this.versionMinor == null ? other.versionMinor != null : !this.versionMinor.equals(other.versionMinor));
    }

    public void initDefaults() {
        this.packageName = "render";
        this.setPackageVersion(-1);
        this.setSBaseListType(ListOf.Type.other);
    }

    public int getVersionMinor() {
        if (this.isSetVersionMinor()) {
            return this.versionMinor;
        }
        throw new PropertyUndefinedError("versionMinor", (SBase)this);
    }

    public boolean isSetVersionMinor() {
        return this.versionMinor != null;
    }

    public void setVersionMinor(int versionMinor) {
        Integer oldVersionMinor = this.versionMinor;
        this.versionMinor = versionMinor;
        this.firePropertyChange("versionMinor", oldVersionMinor, this.versionMinor);
    }

    public boolean unsetVersionMinor() {
        if (this.isSetVersionMinor()) {
            Integer oldVersionMinor = this.versionMinor;
            this.versionMinor = null;
            this.firePropertyChange("versionMinor", oldVersionMinor, this.versionMinor);
            return true;
        }
        return false;
    }

    public int getVersionMajor() {
        if (this.isSetVersionMajor()) {
            return this.versionMajor;
        }
        throw new PropertyUndefinedError("versionMajor", (SBase)this);
    }

    public boolean isSetVersionMajor() {
        return this.versionMajor != null;
    }

    public void setVersionMajor(int versionMajor) {
        Integer oldVersionMajor = this.versionMajor;
        this.versionMajor = versionMajor;
        this.firePropertyChange("versionMajor", oldVersionMajor, this.versionMajor);
    }

    public boolean unsetVersionMajor() {
        if (this.isSetVersionMajor()) {
            Integer oldVersionMajor = this.versionMajor;
            this.versionMajor = null;
            this.firePropertyChange("versionMajor", oldVersionMajor, this.versionMajor);
            return true;
        }
        return false;
    }

    public DefaultValues getDefaultValues() {
        if (this.isSetDefaultValues()) {
            return this.defaultValues;
        }
        throw new PropertyUndefinedError("defaultValues", (SBase)this);
    }

    public boolean isSetDefaultValues() {
        return this.defaultValues != null;
    }

    public void setDefaultValues(DefaultValues defaultValues) {
        DefaultValues oldDefaultValues = this.defaultValues;
        this.defaultValues = defaultValues;
        this.firePropertyChange("defaultValues", (Object)oldDefaultValues, (Object)this.defaultValues);
    }

    public boolean unsetDefaultValues() {
        if (this.isSetDefaultValues()) {
            DefaultValues oldDefaultValues = this.defaultValues;
            this.defaultValues = null;
            this.firePropertyChange("defaultValues", (Object)oldDefaultValues, (Object)this.defaultValues);
            return true;
        }
        return false;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetDefaultValues()) {
            ++count;
        }
        return count;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetDefaultValues()) {
            if (pos == index) {
                return this.getDefaultValues();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetVersionMajor()) {
            attributes.put("render:versionMajor", this.versionMajor.toString());
        }
        if (this.isSetVersionMinor()) {
            attributes.put("render:versionMinor", this.versionMinor.toString());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("versionMajor")) {
                this.setVersionMajor(StringTools.parseSBMLInt((String)value));
            } else if (attributeName.equals("versionMinor")) {
                this.setVersionMinor(StringTools.parseSBMLInt((String)value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

