/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.Point3D;

public abstract class RenderCurveSegment
extends AbstractSBase
implements Point3D {
    private static final long serialVersionUID = -5085246314333062152L;
    private static final transient Logger logger = Logger.getLogger(RenderCurveSegment.class);
    private Type type;

    public RenderCurveSegment() {
        this.initDefaults();
    }

    public RenderCurveSegment(RenderCurveSegment curveSegment) {
        super((SBase)curveSegment);
        if (curveSegment.isSetType()) {
            this.setType(curveSegment.getType());
        }
    }

    public RenderCurveSegment(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public boolean equals(Object object) {
        RenderCurveSegment curveSegment;
        boolean equals = super.equals(object);
        if (equals && (equals &= (curveSegment = (RenderCurveSegment)object).isSetType() == this.isSetType()) && this.isSetType()) {
            equals &= curveSegment.getType().equals((Object)this.getType());
        }
        return equals;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 3049;
        int hashCode = super.hashCode();
        if (this.isSetType()) {
            hashCode += 3049 * this.getType().hashCode();
        }
        return hashCode;
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    public boolean isRenderCubicBezier() {
        return this.type != null && this.type.equals((Object)Type.RENDER_CUBIC_BEZIER);
    }

    public boolean isRenderPoint() {
        return this.type != null && this.type.equals((Object)Type.RENDER_POINT);
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("reading RenderCurveSegment attribute " + prefix + ":" + attributeName));
        }
        if (!isAttributeRead && attributeName.equals("type")) {
            try {
                this.setType(Type.fromString(value));
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "type" + " on a 'RenderPoint' or 'RenderCubicBezier' element.");
            }
            return true;
        }
        return isAttributeRead;
    }

    void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.firePropertyChange("type", (Object)oldType, (Object)this.type);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"write XML attributes of RenderCurveSegment");
            logger.debug((Object)("isSetType: " + this.isSetType()));
            logger.debug((Object)("Type = " + (Object)((Object)this.type)));
        }
        if (this.isSetType()) {
            attributes.put("xsi:type", this.getType().toString());
        }
        return attributes;
    }

    public static enum Type {
        RENDER_CUBIC_BEZIER("RenderCubicBezier"),
        RENDER_POINT("RenderPoint");

        private final String xmlString;

        public static Type fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Enumeration values cannot be NULL.");
            }
            for (Type v : Type.values()) {
                if (!value.equalsIgnoreCase(v.getXmlString())) continue;
                return v;
            }
            return Type.valueOf(value);
        }

        private Type(String xmlString) {
            this.xmlString = xmlString;
        }

        public String getXmlString() {
            return this.xmlString;
        }

        public String toString() {
            return this.xmlString;
        }
    }
}

