/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.ext.render.GradientBase;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.XMLTools;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class RenderInformationBase
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -9096154126197866584L;
    protected String programName;
    protected String programVersion;
    protected String referenceRenderInformation;
    protected Color backgroundColor;
    protected ListOf<ColorDefinition> listOfColorDefinitions;
    protected ListOf<GradientBase> listOfGradientDefinitions;
    protected ListOf<LineEnding> listOfLineEndings;

    public RenderInformationBase() {
        this.initDefaults();
    }

    public RenderInformationBase(String id) {
        super(id);
        this.initDefaults();
    }

    public RenderInformationBase(int level, int version) {
        this(null, null, level, version);
    }

    public RenderInformationBase(String id, int level, int version) {
        this(id, null, level, version);
    }

    public RenderInformationBase(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public RenderInformationBase(RenderInformationBase obj) {
        super((AbstractNamedSBase)obj);
        this.programName = obj.programName;
        this.programVersion = obj.programVersion;
        this.referenceRenderInformation = obj.referenceRenderInformation;
        this.backgroundColor = obj.backgroundColor;
        if (obj.isSetListOfColorDefinitions()) {
            this.setListOfColorDefinitions((ListOf<ColorDefinition>)obj.getListOfColorDefinitions().clone());
        }
        if (obj.isSetListOfGradientDefinitions()) {
            this.setListOfGradientDefinitions((ListOf<GradientBase>)obj.getListOfGradientDefinitions().clone());
        }
        if (obj.isSetListOfLineEndings()) {
            this.setListOfLineEndings((ListOf<LineEnding>)obj.getListOfLineEndings().clone());
        }
    }

    public RenderInformationBase clone() {
        return new RenderInformationBase(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.backgroundColor = new Color(0, 0, 0);
        this.programName = null;
        this.programVersion = null;
        this.referenceRenderInformation = null;
        this.listOfColorDefinitions = null;
        this.listOfGradientDefinitions = null;
        this.listOfLineEndings = null;
    }

    public int hashCode() {
        int prime = 3041;
        int result = super.hashCode();
        result = 3041 * result + (this.backgroundColor == null ? 0 : this.backgroundColor.hashCode());
        result = 3041 * result + (this.listOfColorDefinitions == null ? 0 : this.listOfColorDefinitions.hashCode());
        result = 3041 * result + (this.listOfGradientDefinitions == null ? 0 : this.listOfGradientDefinitions.hashCode());
        result = 3041 * result + (this.listOfLineEndings == null ? 0 : this.listOfLineEndings.hashCode());
        result = 3041 * result + (this.programName == null ? 0 : this.programName.hashCode());
        result = 3041 * result + (this.programVersion == null ? 0 : this.programVersion.hashCode());
        result = 3041 * result + (this.referenceRenderInformation == null ? 0 : this.referenceRenderInformation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RenderInformationBase other = (RenderInformationBase)((Object)obj);
        if (this.backgroundColor == null ? other.backgroundColor != null : !this.backgroundColor.equals(other.backgroundColor)) {
            return false;
        }
        if (this.listOfColorDefinitions == null ? other.listOfColorDefinitions != null : !this.listOfColorDefinitions.equals(other.listOfColorDefinitions)) {
            return false;
        }
        if (this.listOfGradientDefinitions == null ? other.listOfGradientDefinitions != null : !this.listOfGradientDefinitions.equals(other.listOfGradientDefinitions)) {
            return false;
        }
        if (this.listOfLineEndings == null ? other.listOfLineEndings != null : !this.listOfLineEndings.equals(other.listOfLineEndings)) {
            return false;
        }
        if (this.programName == null ? other.programName != null : !this.programName.equals(other.programName)) {
            return false;
        }
        if (this.programVersion == null ? other.programVersion != null : !this.programVersion.equals(other.programVersion)) {
            return false;
        }
        return !(this.referenceRenderInformation == null ? other.referenceRenderInformation != null : !this.referenceRenderInformation.equals(other.referenceRenderInformation));
    }

    public String getProgramName() {
        if (this.isSetProgramName()) {
            return this.programName;
        }
        throw new PropertyUndefinedError("programName", (SBase)this);
    }

    public boolean isSetProgramName() {
        return this.programName != null;
    }

    public void setProgramName(String programName) {
        String oldProgramName = this.programName;
        this.programName = programName;
        this.firePropertyChange("programName", oldProgramName, this.programName);
    }

    public boolean unsetProgramName() {
        if (this.isSetProgramName()) {
            String oldProgramName = this.programName;
            this.programName = null;
            this.firePropertyChange("programName", oldProgramName, this.programName);
            return true;
        }
        return false;
    }

    public String getProgramVersion() {
        if (this.isSetProgramVersion()) {
            return this.programVersion;
        }
        throw new PropertyUndefinedError("programVersion", (SBase)this);
    }

    public boolean isSetProgramVersion() {
        return this.programVersion != null;
    }

    public void setProgramVersion(String programVersion) {
        String oldProgramVersion = this.programVersion;
        this.programVersion = programVersion;
        this.firePropertyChange("programVersion", oldProgramVersion, this.programVersion);
    }

    public boolean unsetProgramVersion() {
        if (this.isSetProgramVersion()) {
            String oldProgramVersion = this.programVersion;
            this.programVersion = null;
            this.firePropertyChange("programVersion", oldProgramVersion, this.programVersion);
            return true;
        }
        return false;
    }

    public String getReferenceRenderInformation() {
        if (this.isSetReferenceRenderInformation()) {
            return this.referenceRenderInformation;
        }
        throw new PropertyUndefinedError("referenceRenderInformation", (SBase)this);
    }

    public boolean isSetReferenceRenderInformation() {
        return this.referenceRenderInformation != null;
    }

    public void setReferenceRenderInformation(String referenceRenderInformation) {
        String oldReferenceRenderInformation = this.referenceRenderInformation;
        this.referenceRenderInformation = referenceRenderInformation;
        this.firePropertyChange("referenceRenderInformation", oldReferenceRenderInformation, this.referenceRenderInformation);
    }

    public boolean unsetReferenceRenderInformation() {
        if (this.isSetReferenceRenderInformation()) {
            String oldReferenceRenderInformation = this.referenceRenderInformation;
            this.referenceRenderInformation = null;
            this.firePropertyChange("referenceRenderInformation", oldReferenceRenderInformation, this.referenceRenderInformation);
            return true;
        }
        return false;
    }

    public Color getBackgroundColor() {
        if (this.isSetBackgroundColor()) {
            return this.backgroundColor;
        }
        throw new PropertyUndefinedError("backgroundColor", (SBase)this);
    }

    public boolean isSetBackgroundColor() {
        return this.backgroundColor != null;
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color oldBackgroundColor = this.backgroundColor;
        this.backgroundColor = backgroundColor;
        this.firePropertyChange("backgroundColor", oldBackgroundColor, this.backgroundColor);
    }

    public boolean unsetBackgroundColor() {
        if (this.isSetBackgroundColor()) {
            Color oldBackgroundColor = this.backgroundColor;
            this.backgroundColor = null;
            this.firePropertyChange("backgroundColor", oldBackgroundColor, this.backgroundColor);
            return true;
        }
        return false;
    }

    public boolean isSetListOfColorDefinitions() {
        return this.listOfColorDefinitions != null && !this.listOfColorDefinitions.isEmpty();
    }

    public ListOf<ColorDefinition> getListOfColorDefinitions() {
        if (!this.isSetListOfColorDefinitions()) {
            this.listOfColorDefinitions = new ListOf(this.getLevel(), this.getVersion());
            this.listOfColorDefinitions.setPackageVersion(-1);
            this.listOfColorDefinitions.setPackageName(null);
            this.listOfColorDefinitions.setPackageName("render");
            this.listOfColorDefinitions.setSBaseListType(ListOf.Type.other);
            this.listOfColorDefinitions.setOtherListName("listOfColorDefinitions");
            this.registerChild((SBase)this.listOfColorDefinitions);
        }
        return this.listOfColorDefinitions;
    }

    public void setListOfColorDefinitions(ListOf<ColorDefinition> listOfColorDefinitions) {
        this.unsetListOfColorDefinitions();
        this.listOfColorDefinitions = listOfColorDefinitions;
        if (listOfColorDefinitions != null) {
            listOfColorDefinitions.setPackageVersion(-1);
            listOfColorDefinitions.setPackageName(null);
            listOfColorDefinitions.setPackageName("render");
            listOfColorDefinitions.setSBaseListType(ListOf.Type.other);
            listOfColorDefinitions.setOtherListName("listOfColorDefinitions");
            this.registerChild((SBase)this.listOfColorDefinitions);
        }
    }

    public boolean unsetListOfColorDefinitions() {
        if (this.isSetListOfColorDefinitions()) {
            ListOf<ColorDefinition> oldColorDefinitions = this.listOfColorDefinitions;
            this.listOfColorDefinitions = null;
            oldColorDefinitions.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addColorDefinition(ColorDefinition field) {
        return this.getListOfColorDefinitions().add((SBase)field);
    }

    public boolean removeColorDefinition(ColorDefinition field) {
        if (this.isSetListOfColorDefinitions()) {
            return this.getListOfColorDefinitions().remove((NamedSBase)field);
        }
        return false;
    }

    public void removeColorDefinition(int i) {
        if (!this.isSetListOfColorDefinitions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfColorDefinitions().remove(i);
    }

    public void removeColorDefinition(String id) {
        this.getListOfColorDefinitions().removeFirst((Filter)new NameFilter(id));
    }

    public boolean isSetListOfGradientDefinitions() {
        return this.listOfGradientDefinitions != null && !this.listOfGradientDefinitions.isEmpty();
    }

    public ListOf<GradientBase> getListOfGradientDefinitions() {
        if (!this.isSetListOfGradientDefinitions()) {
            this.listOfGradientDefinitions = new ListOf(this.getLevel(), this.getVersion());
            this.listOfGradientDefinitions.setPackageVersion(-1);
            this.listOfGradientDefinitions.setPackageName(null);
            this.listOfGradientDefinitions.setPackageName("render");
            this.listOfGradientDefinitions.setSBaseListType(ListOf.Type.other);
            this.listOfGradientDefinitions.setOtherListName("listOfGradientDefinitions");
            this.registerChild((SBase)this.listOfGradientDefinitions);
        }
        return this.listOfGradientDefinitions;
    }

    public void setListOfGradientDefinitions(ListOf<GradientBase> listOfGradientDefintions) {
        this.unsetListOfGradientDefinitions();
        this.listOfGradientDefinitions = listOfGradientDefintions;
        if (listOfGradientDefintions != null) {
            listOfGradientDefintions.setPackageVersion(-1);
            listOfGradientDefintions.setPackageName(null);
            listOfGradientDefintions.setPackageName("render");
            listOfGradientDefintions.setSBaseListType(ListOf.Type.other);
            this.listOfGradientDefinitions.setOtherListName("listOfGradientDefinitions");
            this.registerChild((SBase)this.listOfGradientDefinitions);
        }
    }

    public boolean unsetListOfGradientDefinitions() {
        if (this.isSetListOfGradientDefinitions()) {
            ListOf<GradientBase> oldGradientBases = this.listOfGradientDefinitions;
            this.listOfGradientDefinitions = null;
            oldGradientBases.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addGradientBase(GradientBase field) {
        return this.getListOfGradientDefinitions().add((SBase)field);
    }

    public boolean removeGradientBase(GradientBase field) {
        if (this.isSetListOfGradientDefinitions()) {
            return this.getListOfGradientDefinitions().remove((NamedSBase)field);
        }
        return false;
    }

    public void removeGradientBase(int i) {
        if (!this.isSetListOfGradientDefinitions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfGradientDefinitions().remove(i);
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfColorDefinitions()) {
            ++count;
        }
        if (this.isSetListOfGradientDefinitions()) {
            ++count;
        }
        if (this.isSetListOfLineEndings()) {
            ++count;
        }
        return count;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfColorDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfColorDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfGradientDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfGradientDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfLineEndings()) {
            if (pos == childIndex) {
                return this.getListOfLineEndings();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public boolean isSetListOfLineEndings() {
        return this.listOfLineEndings != null && !this.listOfLineEndings.isEmpty();
    }

    public ListOf<LineEnding> getListOfLineEndings() {
        if (!this.isSetListOfLineEndings()) {
            this.listOfLineEndings = new ListOf(this.getLevel(), this.getVersion());
            this.listOfLineEndings.setPackageVersion(-1);
            this.listOfLineEndings.setPackageName(null);
            this.listOfLineEndings.setPackageName("render");
            this.listOfLineEndings.setSBaseListType(ListOf.Type.other);
            this.listOfLineEndings.setOtherListName("listOfLineEndings");
            this.registerChild((SBase)this.listOfLineEndings);
        }
        return this.listOfLineEndings;
    }

    public void setListOfLineEndings(ListOf<LineEnding> listOfLineEndings) {
        this.unsetListOfLineEndings();
        this.listOfLineEndings = listOfLineEndings;
        if (listOfLineEndings != null) {
            listOfLineEndings.setPackageVersion(-1);
            listOfLineEndings.setPackageName(null);
            listOfLineEndings.setPackageName("render");
            listOfLineEndings.setSBaseListType(ListOf.Type.other);
            listOfLineEndings.setOtherListName("listOfLineEndings");
            this.registerChild((SBase)this.listOfLineEndings);
        }
    }

    public boolean unsetListOfLineEndings() {
        if (this.isSetListOfLineEndings()) {
            ListOf<LineEnding> oldLineEndings = this.listOfLineEndings;
            this.listOfLineEndings = null;
            oldLineEndings.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addLineEnding(LineEnding lineEnding) {
        return this.getListOfLineEndings().add((SBase)lineEnding);
    }

    public boolean removeLineEnding(LineEnding lineEnding) {
        if (this.isSetListOfLineEndings()) {
            return this.getListOfLineEndings().remove((Object)lineEnding);
        }
        return false;
    }

    public void removeLineEnding(int i) {
        if (!this.isSetListOfLineEndings()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfLineEndings().remove(i);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("render:id", this.getId());
        }
        if (this.isSetProgramName()) {
            attributes.put("render:programName", this.getProgramName());
        }
        if (this.isSetProgramVersion()) {
            attributes.put("render:programVersion", this.getProgramVersion());
        }
        if (this.isSetReferenceRenderInformation()) {
            attributes.put("render:referenceRenderInformation", this.getReferenceRenderInformation());
        }
        if (this.isSetBackgroundColor()) {
            attributes.put("render:backgroundColor", XMLTools.encodeColorToString(this.getBackgroundColor()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("programName")) {
                this.setProgramName(value);
            } else if (attributeName.equals("programVersion")) {
                this.setProgramVersion(value);
            } else if (attributeName.equals("referenceRenderInformation")) {
                this.setReferenceRenderInformation(value);
            } else if (attributeName.equals("backgroundColor")) {
                this.setBackgroundColor(XMLTools.decodeStringToColor(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

