/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.FontFamily;
import org.sbml.jsbml.ext.render.FontRenderStyle;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.ext.render.HTextAnchor;
import org.sbml.jsbml.ext.render.Point3D;
import org.sbml.jsbml.ext.render.VTextAnchor;
import org.sbml.jsbml.ext.render.XMLTools;

public class Text
extends GraphicalPrimitive1D
implements FontRenderStyle,
Point3D {
    private static final long serialVersionUID = -7468181076596795203L;
    private Boolean absoluteX;
    private Boolean absoluteY;
    private Boolean absoluteZ;
    private FontFamily fontFamily;
    private Short fontSize;
    private Boolean fontWeightBold;
    private Boolean fontStyleItalic;
    private HTextAnchor textAnchor;
    private VTextAnchor vTextAnchor;
    private Double x;
    private Double y;
    private Double z;

    public Text() {
        this.initDefaults();
    }

    public Text(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Text(Text obj) {
        super(obj);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    @Override
    public FontFamily getFontFamily() {
        if (this.isSetFontFamily()) {
            return this.fontFamily;
        }
        throw new PropertyUndefinedError("font-family", (SBase)this);
    }

    @Override
    public short getFontSize() {
        if (this.isSetFontSize()) {
            return this.fontSize;
        }
        throw new PropertyUndefinedError("font-size", (SBase)this);
    }

    @Override
    public HTextAnchor getTextAnchor() {
        if (this.isSetTextAnchor()) {
            return this.textAnchor;
        }
        throw new PropertyUndefinedError("text-anchor", (SBase)this);
    }

    @Override
    public VTextAnchor getVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            return this.vTextAnchor;
        }
        throw new PropertyUndefinedError("vtext-anchor", (SBase)this);
    }

    @Override
    public double getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    @Override
    public double getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    @Override
    public double getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    @Override
    public boolean isAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            return this.absoluteX;
        }
        throw new PropertyUndefinedError("absolute-x", (SBase)this);
    }

    @Override
    public boolean isAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            return this.absoluteY;
        }
        throw new PropertyUndefinedError("absolute-y", (SBase)this);
    }

    @Override
    public boolean isAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            return this.absoluteZ;
        }
        throw new PropertyUndefinedError("absolute-z", (SBase)this);
    }

    @Override
    public boolean isFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            return this.fontStyleItalic;
        }
        throw new PropertyUndefinedError("font-style", (SBase)this);
    }

    @Override
    public boolean isFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            return this.fontWeightBold;
        }
        throw new PropertyUndefinedError("font-weight", (SBase)this);
    }

    @Override
    public boolean isSetAbsoluteX() {
        return this.absoluteX != null;
    }

    @Override
    public boolean isSetAbsoluteY() {
        return this.absoluteY != null;
    }

    @Override
    public boolean isSetAbsoluteZ() {
        return this.absoluteZ != null;
    }

    @Override
    public boolean isSetFontFamily() {
        return this.fontFamily != null;
    }

    @Override
    public boolean isSetFontSize() {
        return this.fontSize != null;
    }

    @Override
    public boolean isSetFontStyleItalic() {
        return this.fontStyleItalic != null;
    }

    @Override
    public boolean isSetFontWeightBold() {
        return this.fontWeightBold != null;
    }

    @Override
    public boolean isSetTextAnchor() {
        return this.textAnchor != null;
    }

    @Override
    public boolean isSetVTextAnchor() {
        return this.vTextAnchor != null;
    }

    @Override
    public boolean isSetX() {
        return this.x != null;
    }

    @Override
    public boolean isSetY() {
        return this.y != null;
    }

    @Override
    public boolean isSetZ() {
        return this.z != null;
    }

    @Override
    public void setAbsoluteX(boolean absoluteX) {
        Boolean oldAbsoluteX = this.absoluteX;
        this.absoluteX = absoluteX;
        this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
    }

    @Override
    public void setAbsoluteY(boolean absoluteY) {
        Boolean oldAbsoluteY = this.absoluteY;
        this.absoluteY = absoluteY;
        this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
    }

    @Override
    public void setAbsoluteZ(boolean absoluteZ) {
        Boolean oldAbsoluteZ = this.absoluteZ;
        this.absoluteZ = absoluteZ;
        this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
    }

    @Override
    public void setFontFamily(FontFamily fontFamily) {
        FontFamily oldFontFamily = this.fontFamily;
        this.fontFamily = fontFamily;
        this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
    }

    @Override
    public void setFontSize(short fontSize) {
        Short oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange("font-size", oldFontSize, this.fontSize);
    }

    @Override
    public void setFontStyleItalic(boolean fontStyleItalic) {
        Boolean oldFontStyleItalic = this.fontStyleItalic;
        this.fontStyleItalic = fontStyleItalic;
        this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
    }

    @Override
    public void setFontWeightBold(boolean fontWeightBold) {
        Boolean oldFontWeightBold = this.fontWeightBold;
        this.fontWeightBold = fontWeightBold;
        this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
    }

    @Override
    public void setTextAnchor(HTextAnchor textAnchor) {
        HTextAnchor oldTextAnchor = this.textAnchor;
        this.textAnchor = textAnchor;
        this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
    }

    @Override
    public void setVTextAnchor(VTextAnchor vTextAnchor) {
        VTextAnchor oldVTextAnchor = this.vTextAnchor;
        this.vTextAnchor = vTextAnchor;
        this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
    }

    @Override
    public void setX(double x) {
        Double oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", oldX, this.x);
    }

    @Override
    public void setY(double y) {
        Double oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", oldY, this.y);
    }

    @Override
    public void setZ(double z) {
        Double oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", oldZ, this.z);
    }

    @Override
    public boolean unsetAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            Boolean oldAbsoluteX = this.absoluteX;
            this.absoluteX = null;
            this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            Boolean oldAbsoluteY = this.absoluteY;
            this.absoluteY = null;
            this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            Boolean oldAbsoluteZ = this.absoluteZ;
            this.absoluteZ = null;
            this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontFamily() {
        if (this.isSetFontFamily()) {
            FontFamily oldFontFamily = this.fontFamily;
            this.fontFamily = null;
            this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontSize() {
        if (this.isSetFontSize()) {
            Short oldFontSize = this.fontSize;
            this.fontSize = null;
            this.firePropertyChange("font-size", oldFontSize, this.fontSize);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            Boolean oldFontStyleItalic = this.fontStyleItalic;
            this.fontStyleItalic = null;
            this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            Boolean oldFontWeightBold = this.fontWeightBold;
            this.fontWeightBold = null;
            this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetTextAnchor() {
        if (this.isSetTextAnchor()) {
            HTextAnchor oldTextAnchor = this.textAnchor;
            this.textAnchor = null;
            this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            VTextAnchor oldVTextAnchor = this.vTextAnchor;
            this.vTextAnchor = null;
            this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetX() {
        if (this.isSetX()) {
            Double oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", oldX, this.x);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetY() {
        if (this.isSetY()) {
            Double oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", oldY, this.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetZ() {
        if (this.isSetZ()) {
            Double oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", oldZ, this.z);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetFontFamily()) {
            String fontFamily = this.getFontFamily().toString().toLowerCase();
            if (fontFamily.equals("sans_serif")) {
                fontFamily = "sans-serif";
            }
            attributes.put("render:font-family", fontFamily);
        }
        if (this.isSetTextAnchor()) {
            attributes.put("render:text-anchor", this.getTextAnchor().toString().toLowerCase());
        }
        if (this.isSetVTextAnchor()) {
            attributes.put("render:vtext-anchor", this.getVTextAnchor().toString().toLowerCase());
        }
        if (this.isSetFontSize()) {
            attributes.put("render:font-size", Short.toString(this.getFontSize()));
        }
        if (this.isSetX()) {
            attributes.put("render:x", XMLTools.positioningToString(this.getX(), this.isAbsoluteX()));
        }
        if (this.isSetY()) {
            attributes.put("render:y", XMLTools.positioningToString(this.getY(), this.isAbsoluteY()));
        }
        if (this.isSetZ()) {
            attributes.put("render:z", XMLTools.positioningToString(this.getZ(), this.isAbsoluteZ()));
        }
        if (this.isSetFontStyleItalic()) {
            attributes.put("font-style", XMLTools.fontStyleItalicToString(this.isFontStyleItalic()));
        }
        if (this.isSetFontWeightBold()) {
            attributes.put("font-weight", XMLTools.fontWeightBoldToString(this.isFontWeightBold()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("font-family")) {
                if (value.equals("sans-serif")) {
                    value = "SANS_SERIF";
                }
                try {
                    this.setFontFamily(FontFamily.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "font-family" + " on the 'text' element.");
                }
            } else if (attributeName.equals("text-anchor")) {
                try {
                    this.setTextAnchor(HTextAnchor.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "text-anchor" + " on the 'text' element.");
                }
            } else if (attributeName.equals("vtext-anchor")) {
                try {
                    this.setVTextAnchor(VTextAnchor.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "vtext-anchor" + " on the 'text' element.");
                }
            } else if (attributeName.equals("font-size")) {
                this.setFontSize(Short.valueOf(value));
            } else if (attributeName.equals("x")) {
                this.setX(XMLTools.parsePosition(value));
                this.setAbsoluteX(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y")) {
                this.setY(XMLTools.parsePosition(value));
                this.setAbsoluteY(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z")) {
                this.setZ(XMLTools.parsePosition(value));
                this.setAbsoluteZ(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("font-style")) {
                this.setFontStyleItalic(XMLTools.parseFontStyleItalic(value));
            } else if (attributeName.equals("font-weight")) {
                this.setFontWeightBold(XMLTools.parseFontWeightBold(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    @Override
    public int hashCode() {
        int prime = 3163;
        int result = super.hashCode();
        result = 3163 * result + (this.absoluteX == null ? 0 : this.absoluteX.hashCode());
        result = 3163 * result + (this.absoluteY == null ? 0 : this.absoluteY.hashCode());
        result = 3163 * result + (this.absoluteZ == null ? 0 : this.absoluteZ.hashCode());
        result = 3163 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result = 3163 * result + (this.fontSize == null ? 0 : this.fontSize.hashCode());
        result = 3163 * result + (this.fontStyleItalic == null ? 0 : this.fontStyleItalic.hashCode());
        result = 3163 * result + (this.fontWeightBold == null ? 0 : this.fontWeightBold.hashCode());
        result = 3163 * result + (this.textAnchor == null ? 0 : this.textAnchor.hashCode());
        result = 3163 * result + (this.vTextAnchor == null ? 0 : this.vTextAnchor.hashCode());
        result = 3163 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 3163 * result + (this.y == null ? 0 : this.y.hashCode());
        result = 3163 * result + (this.z == null ? 0 : this.z.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Text other = (Text)obj;
        if (this.absoluteX == null ? other.absoluteX != null : !this.absoluteX.equals(other.absoluteX)) {
            return false;
        }
        if (this.absoluteY == null ? other.absoluteY != null : !this.absoluteY.equals(other.absoluteY)) {
            return false;
        }
        if (this.absoluteZ == null ? other.absoluteZ != null : !this.absoluteZ.equals(other.absoluteZ)) {
            return false;
        }
        if (this.fontFamily != other.fontFamily) {
            return false;
        }
        if (this.fontSize == null ? other.fontSize != null : !this.fontSize.equals(other.fontSize)) {
            return false;
        }
        if (this.fontStyleItalic == null ? other.fontStyleItalic != null : !this.fontStyleItalic.equals(other.fontStyleItalic)) {
            return false;
        }
        if (this.fontWeightBold == null ? other.fontWeightBold != null : !this.fontWeightBold.equals(other.fontWeightBold)) {
            return false;
        }
        if (this.textAnchor != other.textAnchor) {
            return false;
        }
        if (this.vTextAnchor != other.vTextAnchor) {
            return false;
        }
        if (this.x == null ? other.x != null : !this.x.equals(other.x)) {
            return false;
        }
        if (this.y == null ? other.y != null : !this.y.equals(other.y)) {
            return false;
        }
        return !(this.z == null ? other.z != null : !this.z.equals(other.z));
    }
}

