/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.ext.render.GlobalRenderInformation;
import org.sbml.jsbml.ext.render.GradientBase;
import org.sbml.jsbml.ext.render.GradientStop;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.LinearGradient;
import org.sbml.jsbml.ext.render.ListOfGlobalRenderInformation;
import org.sbml.jsbml.ext.render.ListOfLocalRenderInformation;
import org.sbml.jsbml.ext.render.LocalRenderInformation;
import org.sbml.jsbml.ext.render.LocalStyle;
import org.sbml.jsbml.ext.render.Polygon;
import org.sbml.jsbml.ext.render.RadialGradient;
import org.sbml.jsbml.ext.render.RenderConstants;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.ext.render.RenderCurve;
import org.sbml.jsbml.ext.render.RenderCurveSegment;
import org.sbml.jsbml.ext.render.RenderGraphicalObjectPlugin;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.ext.render.RenderLayoutPlugin;
import org.sbml.jsbml.ext.render.RenderListOfLayoutsPlugin;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.ext.render.Style;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;

public class RenderParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(RenderParser.class);

    public String getShortLabel() {
        return "render";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/render/version1";
    }

    public boolean processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (contextObject instanceof GraphicalObject) {
            contextObject = ((SBase)contextObject).createPlugin("render");
        }
        return super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processStartElement - " + prefix + ":" + elementName + " in context of: '" + (contextObject instanceof SBase ? ((SBase)contextObject).getElementName() : contextObject.getClass().getSimpleName()) + "'"));
        }
        if (contextObject instanceof LayoutModelPlugin) {
            LayoutModelPlugin layoutModel = (LayoutModelPlugin)contextObject;
            ListOf listOfLayouts = layoutModel.getListOfLayouts();
            ListOfGlobalRenderInformation newElement = null;
            if (elementName.equals("listOfGlobalRenderInformation")) {
                RenderListOfLayoutsPlugin renderPlugin = new RenderListOfLayoutsPlugin((ListOf<Layout>)listOfLayouts);
                listOfLayouts.addExtension("render", (SBasePlugin)renderPlugin);
                newElement = renderPlugin.getListOfGlobalRenderInformation();
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof Layout) {
            Layout layout = (Layout)contextObject;
            ListOfLocalRenderInformation newElement = null;
            if (elementName.equals("listOfRenderInformation") || elementName.equals("listOfLocalRenderInformation")) {
                RenderLayoutPlugin renderPlugin = new RenderLayoutPlugin(layout);
                layout.addExtension("render", (SBasePlugin)renderPlugin);
                newElement = renderPlugin.getListOfLocalRenderInformation();
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof RenderInformationBase) {
            RenderInformationBase renderInformation = (RenderInformationBase)((Object)contextObject);
            Object newElement = null;
            if (elementName.equals("listOfGradientDefinitions")) {
                newElement = renderInformation.getListOfGradientDefinitions();
            }
            if (elementName.equals("listOfColorDefinitions")) {
                newElement = renderInformation.getListOfColorDefinitions();
            }
            if (elementName.equals("listOfLineEndings")) {
                newElement = renderInformation.getListOfLineEndings();
            }
            if (renderInformation instanceof GlobalRenderInformation) {
                GlobalRenderInformation globalRenderInformation = (GlobalRenderInformation)renderInformation;
                if (elementName.equals("listOfStyles")) {
                    newElement = globalRenderInformation.getListOfStyles();
                }
            }
            if (renderInformation instanceof LocalRenderInformation) {
                LocalRenderInformation localRenderInformation = (LocalRenderInformation)renderInformation;
                if (elementName.equals("listOfStyles") || elementName.equals("listOfLocalStyles")) {
                    newElement = localRenderInformation.getListOfLocalStyles();
                }
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof Style) {
            Style style = (Style)((Object)contextObject);
            if (elementName.equals("g")) {
                RenderGroup g = new RenderGroup();
                style.setGroup(g);
                return g;
            }
        } else if (contextObject instanceof RenderGroup) {
            RenderGroup g = (RenderGroup)((Object)contextObject);
            if (elementName.equals("curve")) {
                return g.createCurve();
            }
            if (elementName.equals("g")) {
                return g.createRenderGroup();
            }
            if (elementName.equals("g")) {
                return g.createRenderGroup();
            }
            if (elementName.equals("text")) {
                return g.createText();
            }
            if (elementName.equals("ellipse")) {
                return g.createEllipse();
            }
            if (elementName.equals("polygon")) {
                return g.createPolygon();
            }
            if (elementName.equals("rectangle")) {
                return g.createRectangle();
            }
            if (elementName.equals("image")) {
                return g.createImage();
            }
        } else if (contextObject instanceof Polygon) {
            Polygon polygon = (Polygon)((Object)contextObject);
            ListOf<RenderPoint> newElement = null;
            if (elementName.equals("listOfElements") || elementName.equals("listOfRenderPoints") || elementName.equals("listOfRenderCubicBeziers")) {
                newElement = polygon.getListOfElements();
            } else if (elementName.equals("listOfCurveSegments")) {
                newElement = polygon.getListOfCurveSegments();
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof LineEnding) {
            LineEnding lineEnding = (LineEnding)((Object)contextObject);
            if (elementName.equals("boundingBox")) {
                BoundingBox bbox = new BoundingBox();
                lineEnding.setBoundingBox(bbox);
                return bbox;
            }
            if (elementName.equals("g")) {
                RenderGroup g = new RenderGroup();
                lineEnding.setGroup(g);
                return g;
            }
        } else if (contextObject instanceof RenderCurve) {
            RenderCurve curve = (RenderCurve)((Object)contextObject);
            ListOf<RenderPoint> newElement = null;
            if (elementName.equals("listOfElements") || elementName.equals("listOfRenderPoints") || elementName.equals("listOfRenderCubicBeziers")) {
                newElement = curve.getListOfElements();
            } else if (elementName.equals("listOfCurveSegments")) {
                newElement = curve.getListOfCurveSegments();
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof GradientBase) {
            GradientBase gradientBase = (GradientBase)((Object)contextObject);
            Object newElement = null;
            if (elementName.equals("listOfGradientStops")) {
                newElement = gradientBase.getListOfGradientStops();
            } else if (elementName.equals("stop")) {
                newElement = new GradientStop();
                gradientBase.addGradientStop((GradientStop)((Object)newElement));
            }
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            Object newElement = null;
            if (elementName.equals("element")) {
                newElement = new RenderCubicBezier();
            } else if (elementName.equals("renderPoint")) {
                newElement = new RenderPoint();
            } else if (elementName.equals("renderCubicBezier")) {
                newElement = new RenderCubicBezier();
            } else if (elementName.equals("style")) {
                newElement = listOf.getParent() instanceof LocalRenderInformation ? new LocalStyle() : new Style();
            } else if (elementName.equals("localStyle")) {
                newElement = new LocalStyle();
            } else if (elementName.equals("gradientStop") || elementName.equals("stop")) {
                newElement = new GradientStop();
            } else if (elementName.equals("colorDefinition")) {
                newElement = new ColorDefinition();
            } else if (elementName.equals("gradientBase")) {
                newElement = new GradientBase();
            } else if (elementName.equals("radialGradient")) {
                newElement = new RadialGradient();
            } else if (elementName.equals("linearGradient")) {
                newElement = new LinearGradient();
            } else if (elementName.equals("lineEnding")) {
                newElement = new LineEnding();
            } else if (elementName.equals("renderInformation")) {
                newElement = listOf.getElementName().equals("listOfRenderInformation") ? new LocalRenderInformation() : new GlobalRenderInformation();
            } else if (elementName.equals("localRenderInformation")) {
                newElement = new LocalRenderInformation();
            } else if (elementName.equals("globalRenderInformation")) {
                newElement = new GlobalRenderInformation();
            }
            if (newElement != null) {
                listOf.add((SBase)newElement);
            }
            return newElement;
        }
        return contextObject;
    }

    public void processEndDocument(SBMLDocument sbmlDocument) {
        if (sbmlDocument.isPackageEnabled("render")) {
            List curveElements = sbmlDocument.getModel().getExtension("layout").filter(new Filter(){

                public boolean accepts(Object o) {
                    return o instanceof Polygon || o instanceof RenderCurve;
                }
            });
            for (TreeNode curveNode : curveElements) {
                ListOf<RenderPoint> listOfElements = null;
                if (curveNode instanceof RenderCurve) {
                    RenderCurve curve = (RenderCurve)((Object)curveNode);
                    listOfElements = curve.getListOfElements();
                } else {
                    listOfElements = ((Polygon)((Object)curveNode)).getListOfElements();
                }
                int i = 0;
                for (RenderPoint renderPoint : listOfElements.clone()) {
                    if (!renderPoint.isSetType()) {
                        if (((RenderCubicBezier)renderPoint).isSetX1() || ((RenderCubicBezier)renderPoint).isSetX2()) {
                            renderPoint.readAttribute("type", "", RenderCurveSegment.Type.RENDER_CUBIC_BEZIER.toString());
                        } else {
                            renderPoint.readAttribute("type", "", RenderCurveSegment.Type.RENDER_POINT.toString());
                        }
                    }
                    if (renderPoint.getType().equals((Object)RenderCurveSegment.Type.RENDER_POINT)) {
                        RenderPoint realRenderPoint = new RenderPoint(renderPoint);
                        logger.debug((Object)("Transformed a RenderCubicBezier: '" + renderPoint + "' into a RenderPoint."));
                        listOfElements.remove(i);
                        listOfElements.add(i, (SBase)realRenderPoint);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RenderCurveSegment = " + listOfElements.get(i)));
                    }
                    ++i;
                }
            }
        }
    }

    public List<String> getNamespaces() {
        return RenderConstants.namespaces_L3;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Layout) {
                return new RenderLayoutPlugin((Layout)sbase);
            }
            if (sbase instanceof ListOf) {
                if (sbase.getElementName().equals("listOfLayouts")) {
                    return new RenderListOfLayoutsPlugin((ListOf<Layout>)((ListOf)sbase));
                }
            } else if (sbase instanceof GraphicalObject) {
                return new RenderGraphicalObjectPlugin((GraphicalObject)sbase);
            }
        }
        return null;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/render/version1";
        }
        return null;
    }

    public List<String> getPackageNamespaces() {
        return RenderConstants.namespaces_L3;
    }

    public String getPackageName() {
        return this.getShortLabel();
    }

    public boolean isRequired() {
        return false;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

