/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.ICurve;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.render.GraphicalPrimitive2D;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.ext.render.RenderPoint;

public class Polygon
extends GraphicalPrimitive2D
implements ICurve {
    private static final long serialVersionUID = 9207043017589271103L;
    private ListOf<RenderPoint> listOfElements;
    private ListOf<CurveSegment> listOfCurveSegments;

    public Polygon() {
        this.initDefaults();
    }

    public Polygon(Polygon obj) {
        super(obj);
        if (obj.isSetListOfElements()) {
            this.setListOfElements((ListOf<RenderPoint>)obj.getListOfElements().clone());
        }
        if (obj.isSetListOfCurveSegments()) {
            this.setListOfCurveSegments((ListOf<CurveSegment>)obj.getListOfCurveSegments().clone());
        }
    }

    public boolean addElement(RenderPoint element) {
        return this.getListOfElements().add((SBase)element);
    }

    @Override
    public Polygon clone() {
        return new Polygon(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfElements()) {
            if (pos == childIndex) {
                return this.getListOfElements();
            }
            ++pos;
        }
        if (this.isSetListOfCurveSegments()) {
            if (pos == childIndex) {
                return this.getListOfCurveSegments();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfElements()) {
            ++count;
        }
        if (this.isSetListOfCurveSegments()) {
            ++count;
        }
        return count;
    }

    public ListOf<RenderPoint> getListOfElements() {
        if (!this.isSetListOfElements()) {
            this.listOfElements = new ListOf(this.getLevel(), this.getVersion());
            this.listOfElements.setPackageVersion(-1);
            this.listOfElements.setPackageName(null);
            this.listOfElements.setPackageName("render");
            this.listOfElements.setSBaseListType(ListOf.Type.other);
            this.listOfElements.setOtherListName("listOfElements");
            this.registerChild((SBase)this.listOfElements);
        }
        return this.listOfElements;
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null;
    }

    public void setListOfElements(ListOf<RenderPoint> listOfElements) {
        this.unsetListOfElements();
        this.listOfElements = listOfElements;
        if (listOfElements != null) {
            listOfElements.setPackageVersion(-1);
            listOfElements.setPackageName(null);
            listOfElements.setPackageName("render");
            listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<RenderPoint> oldListOfElements = this.listOfElements;
            this.listOfElements = null;
            this.firePropertyChange("listOfElements", oldListOfElements, this.listOfElements);
            return true;
        }
        return false;
    }

    public boolean removeElement(RenderPoint element) {
        if (this.isSetListOfElements()) {
            return this.getListOfElements().remove((Object)element);
        }
        return false;
    }

    public void removeElement(int i) {
        if (!this.isSetListOfElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfElements().remove(i);
    }

    public RenderPoint createRenderCubicBezier() {
        RenderCubicBezier element = new RenderCubicBezier();
        this.addElement(element);
        return element;
    }

    public RenderPoint createRenderPoint() {
        RenderPoint element = new RenderPoint();
        this.addElement(element);
        return element;
    }

    public boolean isSetListOfCurveSegments() {
        return this.listOfCurveSegments != null;
    }

    public ListOf<CurveSegment> getListOfCurveSegments() {
        if (this.listOfCurveSegments == null) {
            this.listOfCurveSegments = new ListOf();
            this.listOfCurveSegments.setPackageVersion(-1);
            this.listOfCurveSegments.setPackageName(null);
            this.listOfCurveSegments.setPackageName("layout");
            this.listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            this.listOfCurveSegments.setOtherListName("listOfCurveSegments");
            this.registerChild((SBase)this.listOfCurveSegments);
        }
        return this.listOfCurveSegments;
    }

    public void setListOfCurveSegments(ListOf<CurveSegment> listOfCurveSegments) {
        this.unsetListOfCurveSegments();
        this.listOfCurveSegments = listOfCurveSegments;
        if (listOfCurveSegments != null) {
            listOfCurveSegments.setPackageVersion(-1);
            listOfCurveSegments.setPackageName(null);
            listOfCurveSegments.setPackageName("layout");
            listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            listOfCurveSegments.setOtherListName("listOfCurveSegments");
            this.registerChild((SBase)listOfCurveSegments);
        }
    }

    public boolean unsetListOfCurveSegments() {
        if (this.isSetListOfCurveSegments()) {
            ListOf<CurveSegment> oldCurveSegments = this.listOfCurveSegments;
            this.listOfCurveSegments = null;
            oldCurveSegments.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCurveSegment(CurveSegment curveSegment) {
        return this.getListOfCurveSegments().add((SBase)curveSegment);
    }

    public void addCurveSegment(int index, CurveSegment element) {
        this.getListOfCurveSegments().add(index, (SBase)element);
    }

    public boolean removeCurveSegment(CurveSegment curveSegment) {
        if (this.isSetListOfCurveSegments()) {
            return this.getListOfCurveSegments().remove((Object)curveSegment);
        }
        return false;
    }

    public CurveSegment removeCurveSegment(int i) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CurveSegment)this.getListOfCurveSegments().remove(i);
    }

    public LineSegment createLineSegment() {
        LineSegment curveSegment = new LineSegment(this.getLevel(), this.getVersion());
        this.addCurveSegment((CurveSegment)curveSegment);
        return curveSegment;
    }

    public CubicBezier createCubicBezier() {
        CubicBezier curveSegment = new CubicBezier(this.getLevel(), this.getVersion());
        this.addCurveSegment((CurveSegment)curveSegment);
        return curveSegment;
    }

    public CurveSegment getCurveSegment(int i) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CurveSegment)this.getListOfCurveSegments().get(i);
    }

    public int getCurveSegmentCount() {
        return this.isSetListOfCurveSegments() ? this.getListOfCurveSegments().size() : 0;
    }

    public int getNumCurveSegments() {
        return this.getCurveSegmentCount();
    }

    @Override
    public int hashCode() {
        int prime = 3167;
        int result = super.hashCode();
        result = 3167 * result + (this.listOfCurveSegments == null ? 0 : this.listOfCurveSegments.hashCode());
        result = 3167 * result + (this.listOfElements == null ? 0 : this.listOfElements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)((Object)obj);
        if (this.listOfCurveSegments == null ? other.listOfCurveSegments != null : !this.listOfCurveSegments.equals(other.listOfCurveSegments)) {
            return false;
        }
        return !(this.listOfElements == null ? other.listOfElements != null : !this.listOfElements.equals(other.listOfElements));
    }
}

