/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.HashMap;
import java.util.Map;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBase;

public class DefaultValues
extends AbstractSBase {
    Map<String, String> attributes;

    public DefaultValues() {
        this.initDefaults();
    }

    public DefaultValues(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public DefaultValues(DefaultValues obj) {
        super((SBase)obj);
        if (obj.attributes != null) {
            for (String name : obj.attributes.keySet()) {
                this.setDefaultValue(name, obj.attributes.get(name));
            }
        }
    }

    public DefaultValues clone() {
        return new DefaultValues(this);
    }

    public void initDefaults() {
        this.packageName = "render";
        this.setPackageVersion(-1);
    }

    public void setDefaultValue(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String getDefaultValue(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Map<String, String> getDefaultValues() {
        return this.attributes;
    }

    public Map<String, String> writeXMLAttributes() {
        Map allAttributes = super.writeXMLAttributes();
        if (this.attributes != null) {
            for (String attributeName : this.attributes.keySet()) {
                allAttributes.put("render:" + attributeName, this.attributes.get(attributeName));
            }
        }
        return allAttributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            this.setDefaultValue(attributeName, value);
        }
        return isAttributeRead;
    }
}

