/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.render.Ellipse;
import org.sbml.jsbml.ext.render.FontFamily;
import org.sbml.jsbml.ext.render.GraphicalPrimitive2D;
import org.sbml.jsbml.ext.render.HTextAnchor;
import org.sbml.jsbml.ext.render.Image;
import org.sbml.jsbml.ext.render.Polygon;
import org.sbml.jsbml.ext.render.Rectangle;
import org.sbml.jsbml.ext.render.RenderCurve;
import org.sbml.jsbml.ext.render.Text;
import org.sbml.jsbml.ext.render.Transformation2D;
import org.sbml.jsbml.ext.render.VTextAnchor;
import org.sbml.jsbml.ext.render.XMLTools;

public class RenderGroup
extends GraphicalPrimitive2D
implements UniqueNamedSBase {
    private static final long serialVersionUID = 2302368129571619877L;
    private FontFamily fontFamily;
    private Short fontSize;
    private Boolean fontWeightBold;
    private Boolean fontStyleItalic;
    private HTextAnchor textAnchor;
    private VTextAnchor vTextAnchor;
    private String startHead;
    private String endHead;
    private ListOf<Transformation2D> listOfElements;

    public RenderGroup() {
        this.initDefaults();
    }

    public RenderGroup(String id) {
        this.setId(id);
        this.initDefaults();
    }

    public RenderGroup(int level, int version) {
        this(null, null, level, version);
    }

    public RenderGroup(String id, int level, int version) {
        this(id, null, level, version);
    }

    public RenderGroup(String id, String name, int level, int version) {
        super(level, version);
        this.setId(id);
        this.setName(name);
        this.initDefaults();
    }

    public RenderGroup(RenderGroup obj) {
        super(obj);
        if (obj.isSetFontFamily()) {
            this.setFontFamily(obj.getFontFamily());
        }
        if (obj.isSetFontSize()) {
            this.setFontSize(obj.getFontSize());
        }
        if (obj.isSetFontStyleItalic()) {
            this.setFontStyleItalic(obj.getFontStyleItalic());
        }
        if (obj.isSetFontWeightBold()) {
            this.setFontWeightBold(obj.getFontWeightBold());
        }
        if (obj.isSetTextAnchor()) {
            this.setTextAnchor(obj.getTextAnchor());
        }
        if (obj.isSetVTextAnchor()) {
            this.setVTextAnchor(obj.getVTextAnchor());
        }
        if (obj.isSetStartHead()) {
            this.setStartHead(obj.getStartHead());
        }
        if (obj.isSetEndHead()) {
            this.setEndHead(obj.getEndHead());
        }
        if (obj.isSetListOfElements()) {
            this.setListOfElements((ListOf<Transformation2D>)obj.getListOfElements().clone());
        }
    }

    @Override
    public RenderGroup clone() {
        return new RenderGroup(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    @Override
    public int hashCode() {
        int prime = 3203;
        int result = super.hashCode();
        result = 3203 * result + (this.endHead == null ? 0 : this.endHead.hashCode());
        result = 3203 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result = 3203 * result + (this.fontSize == null ? 0 : this.fontSize.hashCode());
        result = 3203 * result + (this.fontStyleItalic == null ? 0 : this.fontStyleItalic.hashCode());
        result = 3203 * result + (this.fontWeightBold == null ? 0 : this.fontWeightBold.hashCode());
        result = 3203 * result + (this.startHead == null ? 0 : this.startHead.hashCode());
        result = 3203 * result + (this.textAnchor == null ? 0 : this.textAnchor.hashCode());
        result = 3203 * result + (this.vTextAnchor == null ? 0 : this.vTextAnchor.hashCode());
        result = 3203 * result + (this.listOfElements == null ? 0 : this.listOfElements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RenderGroup other = (RenderGroup)((Object)obj);
        if (this.endHead == null ? other.endHead != null : !this.endHead.equals(other.endHead)) {
            return false;
        }
        if (this.fontFamily != other.fontFamily) {
            return false;
        }
        if (this.fontSize == null ? other.fontSize != null : !this.fontSize.equals(other.fontSize)) {
            return false;
        }
        if (this.fontStyleItalic == null ? other.fontStyleItalic != null : !this.fontStyleItalic.equals(other.fontStyleItalic)) {
            return false;
        }
        if (this.fontWeightBold == null ? other.fontWeightBold != null : !this.fontWeightBold.equals(other.fontWeightBold)) {
            return false;
        }
        if (this.startHead == null ? other.startHead != null : !this.startHead.equals(other.startHead)) {
            return false;
        }
        if (this.textAnchor != other.textAnchor) {
            return false;
        }
        if (this.vTextAnchor != other.vTextAnchor) {
            return false;
        }
        return !(this.listOfElements == null ? other.listOfElements != null : !this.listOfElements.equals(other.listOfElements));
    }

    public String toString() {
        return "Group [fontFamily=" + (Object)((Object)this.fontFamily) + ", fontSize=" + this.fontSize + ", fontWeightBold=" + this.fontWeightBold + ", fontStyleItalic=" + this.fontStyleItalic + ", textAnchor=" + (Object)((Object)this.textAnchor) + ", vTextAnchor=" + (Object)((Object)this.vTextAnchor) + ", startHead=" + this.startHead + ", endHead=" + this.endHead + ", listOfElements=" + this.listOfElements + "]";
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfElements()) {
            count += this.getListOfElements().size();
        }
        return count;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfElements()) {
            for (Transformation2D drawable : this.getListOfElements()) {
                if (pos == index) {
                    return drawable;
                }
                ++pos;
            }
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public String getElementName() {
        return "g";
    }

    public FontFamily getFontFamily() {
        if (this.isSetFontFamily()) {
            return this.fontFamily;
        }
        throw new PropertyUndefinedError("font-family", (SBase)this);
    }

    public boolean isSetFontFamily() {
        return this.fontFamily != null;
    }

    public void setFontFamily(FontFamily fontFamily) {
        FontFamily oldFontFamily = this.fontFamily;
        this.fontFamily = fontFamily;
        this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
    }

    public boolean unsetFontFamily() {
        if (this.isSetFontFamily()) {
            FontFamily oldFontFamily = this.fontFamily;
            this.fontFamily = null;
            this.firePropertyChange("font-family", (Object)oldFontFamily, (Object)this.fontFamily);
            return true;
        }
        return false;
    }

    public Short getFontSize() {
        if (this.isSetFontSize()) {
            return this.fontSize;
        }
        throw new PropertyUndefinedError("font-size", (SBase)this);
    }

    public boolean isSetFontSize() {
        return this.fontSize != null;
    }

    public void setFontSize(Short fontSize) {
        Short oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange("font-size", oldFontSize, this.fontSize);
    }

    public boolean unsetFontSize() {
        if (this.isSetFontSize()) {
            short oldFontSize = this.fontSize;
            this.fontSize = null;
            this.firePropertyChange("font-size", oldFontSize, this.fontSize);
            return true;
        }
        return false;
    }

    public boolean getFontWeightBold() {
        return this.isFontWeightBold();
    }

    public boolean isFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            return this.fontWeightBold;
        }
        throw new PropertyUndefinedError("font-weight", (SBase)this);
    }

    public boolean isSetFontWeightBold() {
        return this.fontWeightBold != null;
    }

    public void setFontWeightBold(Boolean fontWeightBold) {
        Boolean oldFontWeightBold = this.fontWeightBold;
        this.fontWeightBold = fontWeightBold;
        this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
    }

    public boolean unsetFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            Boolean oldFontWeightBold = this.fontWeightBold;
            this.fontWeightBold = null;
            this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
            return true;
        }
        return false;
    }

    public boolean getFontStyleItalic() {
        return this.isFontStyleItalic();
    }

    public boolean isFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            return this.fontStyleItalic;
        }
        throw new PropertyUndefinedError("font-style", (SBase)this);
    }

    public boolean isSetFontStyleItalic() {
        return this.fontStyleItalic != null;
    }

    public void setFontStyleItalic(Boolean fontStyleItalic) {
        Boolean oldFontStyleItalic = this.fontStyleItalic;
        this.fontStyleItalic = fontStyleItalic;
        this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
    }

    public boolean unsetFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            Boolean oldFontStyleItalic = this.fontStyleItalic;
            this.fontStyleItalic = null;
            this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
            return true;
        }
        return false;
    }

    public String getStartHead() {
        if (this.isSetStartHead()) {
            return this.startHead;
        }
        throw new PropertyUndefinedError("startHead", (SBase)this);
    }

    public boolean isSetStartHead() {
        return this.startHead != null;
    }

    public void setStartHead(String startHead) {
        String oldStartHead = this.startHead;
        this.startHead = startHead;
        this.firePropertyChange("startHead", oldStartHead, this.startHead);
    }

    public boolean unsetStartHead() {
        if (this.isSetStartHead()) {
            String oldStartHead = this.startHead;
            this.startHead = null;
            this.firePropertyChange("startHead", oldStartHead, this.startHead);
            return true;
        }
        return false;
    }

    public String getEndHead() {
        if (this.isSetEndHead()) {
            return this.endHead;
        }
        throw new PropertyUndefinedError("endHead", (SBase)this);
    }

    public boolean isSetEndHead() {
        return this.endHead != null;
    }

    public void setEndHead(String endHead) {
        String oldEndHead = this.endHead;
        this.endHead = endHead;
        this.firePropertyChange("endHead", oldEndHead, this.endHead);
    }

    public boolean unsetEndHead() {
        if (this.isSetEndHead()) {
            String oldEndHead = this.endHead;
            this.endHead = null;
            this.firePropertyChange("endHead", oldEndHead, this.endHead);
            return true;
        }
        return false;
    }

    public HTextAnchor getTextAnchor() {
        if (this.isSetTextAnchor()) {
            return this.textAnchor;
        }
        throw new PropertyUndefinedError("text-anchor", (SBase)this);
    }

    public boolean isSetTextAnchor() {
        return this.textAnchor != null;
    }

    public void setTextAnchor(HTextAnchor textAnchor) {
        HTextAnchor oldTextAnchor = this.textAnchor;
        this.textAnchor = textAnchor;
        this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
    }

    public boolean unsetTextAnchor() {
        if (this.isSetTextAnchor()) {
            HTextAnchor oldTextAnchor = this.textAnchor;
            this.textAnchor = null;
            this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
            return true;
        }
        return false;
    }

    public VTextAnchor getVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            return this.vTextAnchor;
        }
        throw new PropertyUndefinedError("vtext-anchor", (SBase)this);
    }

    public boolean isSetVTextAnchor() {
        return this.vTextAnchor != null;
    }

    public void setVTextAnchor(VTextAnchor vTextAnchor) {
        VTextAnchor oldVTextAnchor = this.vTextAnchor;
        this.vTextAnchor = vTextAnchor;
        this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
    }

    public boolean unsetVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            VTextAnchor oldVTextAnchor = this.vTextAnchor;
            this.vTextAnchor = null;
            this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
            return true;
        }
        return false;
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null && !this.listOfElements.isEmpty();
    }

    public ListOf<Transformation2D> getListOfElements() {
        if (!this.isSetListOfElements()) {
            this.listOfElements = new ListOf();
            this.listOfElements.setPackageVersion(-1);
            this.listOfElements.setPackageName(null);
            this.listOfElements.setPackageName("render");
            this.listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
        return this.listOfElements;
    }

    public void setListOfElements(ListOf<Transformation2D> listOfElements) {
        this.unsetListOfElements();
        this.listOfElements = listOfElements;
        if (listOfElements != null) {
            listOfElements.setPackageVersion(-1);
            listOfElements.setPackageName(null);
            listOfElements.setPackageName("render");
            listOfElements.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfElements);
        }
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<Transformation2D> oldElements = this.listOfElements;
            this.listOfElements = null;
            oldElements.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addElement(Transformation2D field) {
        return this.getListOfElements().add((SBase)field);
    }

    public boolean removeElement(Transformation2D field) {
        if (this.isSetListOfElements()) {
            return this.getListOfElements().remove((SBase)field);
        }
        return false;
    }

    public Transformation2D removeElement(String fieldId) {
        if (this.isSetListOfElements()) {
            return (Transformation2D)this.getListOfElements().remove(fieldId);
        }
        return null;
    }

    public Transformation2D removeElement(int i) {
        if (!this.isSetListOfElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Transformation2D)this.getListOfElements().remove(i);
    }

    public RenderCurve createCurve() {
        RenderCurve curve = new RenderCurve();
        this.addElement(curve);
        return curve;
    }

    public Ellipse createEllipse() {
        Ellipse ellipse = new Ellipse();
        this.addElement(ellipse);
        return ellipse;
    }

    public Image createImage() {
        Image image = new Image();
        this.addElement(image);
        return image;
    }

    public Polygon createPolygon() {
        Polygon polygon = new Polygon();
        this.addElement(polygon);
        return polygon;
    }

    public Rectangle createRectangle() {
        Rectangle rectangle = new Rectangle();
        this.addElement(rectangle);
        return rectangle;
    }

    public RenderGroup createRenderGroup() {
        RenderGroup group = new RenderGroup();
        this.addElement(group);
        return group;
    }

    public Text createText() {
        Text rectangle = new Text();
        this.addElement(rectangle);
        return rectangle;
    }

    public Transformation2D getElement(int i) {
        if (!this.isSetListOfElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Transformation2D)this.getListOfElements().get(i);
    }

    public Transformation2D getElement(String fieldId) {
        if (this.isSetListOfElements()) {
            return (Transformation2D)this.getListOfElements().get(fieldId);
        }
        return null;
    }

    public int getElementCount() {
        return this.isSetListOfElements() ? this.getListOfElements().size() : 0;
    }

    public int getNumElements() {
        return this.getElementCount();
    }

    public void addChildElement(Transformation2D pChild) {
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetFontFamily()) {
            String fontFamily = this.getFontFamily().toString().toLowerCase();
            if (fontFamily.equals("sans_serif")) {
                fontFamily = "sans-serif";
            }
            attributes.put("render:font-family", fontFamily);
        }
        if (this.isSetTextAnchor()) {
            attributes.put("render:text-anchor", this.getTextAnchor().toString().toLowerCase());
        }
        if (this.isSetVTextAnchor()) {
            attributes.put("render:vtext-anchor", this.getVTextAnchor().toString().toLowerCase());
        }
        if (this.isSetFontSize()) {
            attributes.put("render:font-size", Short.toString(this.getFontSize()));
        }
        if (this.isSetStartHead()) {
            attributes.put("render:startHead", this.getStartHead());
        }
        if (this.isSetEndHead()) {
            attributes.put("render:endHead", this.getEndHead());
        }
        if (this.isSetFontStyleItalic()) {
            attributes.put("font-style", XMLTools.fontStyleItalicToString(this.isFontStyleItalic()));
        }
        if (this.isSetFontWeightBold()) {
            attributes.put("font-weight", XMLTools.fontWeightBoldToString(this.isFontWeightBold()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("font-family")) {
                if (value.equals("sans-serif")) {
                    value = "SANS_SERIF";
                }
                try {
                    this.setFontFamily(FontFamily.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "font-family" + " on the 'g' element.");
                }
            } else if (attributeName.equals("font-size")) {
                this.setFontSize(Short.valueOf(value));
            } else if (attributeName.equals("font-weight")) {
                this.setFontWeightBold(XMLTools.parseFontWeightBold(value));
            } else if (attributeName.equals("font-style")) {
                this.setFontStyleItalic(XMLTools.parseFontStyleItalic(value));
            } else if (attributeName.equals("text-anchor")) {
                try {
                    this.setTextAnchor(HTextAnchor.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "text-anchor" + " on the 'g' element.");
                }
            } else if (attributeName.equals("vtext-anchor")) {
                try {
                    this.setVTextAnchor(VTextAnchor.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "vtext-anchor" + " on the 'g' element.");
                }
            } else if (attributeName.equals("startHead") || attributeName.equals("start-head")) {
                this.setStartHead(value);
            } else if (attributeName.equals("endHead") || attributeName.equals("end-head")) {
                this.setEndHead(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

