/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.XMLTools;

public class Transformation
extends AbstractSBase {
    private static final long serialVersionUID = 1845276761656867150L;
    protected List<Double> transform;

    public Transformation() {
        this.initDefaults();
    }

    public Transformation(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Transformation(Transformation obj) {
        super((SBase)obj);
        if (obj.isSetTransform()) {
            this.setTransform(new ArrayList<Double>(obj.transform));
        }
    }

    public Transformation clone() {
        return new Transformation(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    public int hashCode() {
        int prime = 3191;
        int result = super.hashCode();
        if (this.isSetTransform()) {
            result = 3191 * result + this.transform.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Transformation other = (Transformation)((Object)obj);
        return this.isSetTransform() == other.isSetTransform() && (!this.isSetTransform() || this.transform.equals(other.transform));
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetTransform()) {
            attributes.put("render:transform", XMLTools.encodeArrayDoubleToString(this.transform.toArray(new Double[0])));
        }
        return attributes;
    }

    private boolean isSetTransform() {
        return this.transform != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("transform")) {
                this.setTransform(Arrays.asList(XMLTools.decodeStringToArrayDouble(value)));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    private boolean setTransform(List<Double> transform) {
        List<Double> oldTransform = this.transform;
        this.transform = transform;
        this.firePropertyChange("transform", oldTransform, this.transform);
        return transform != oldTransform;
    }
}

