/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceRole;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.ext.render.director.LayoutAlgorithm;
import org.sbml.jsbml.ext.render.director.LayoutDirector;

public abstract class SimpleLayoutAlgorithm
implements LayoutAlgorithm {
    private static final double REACTIONGLYPH_DEPTH = 0.0;
    private static final double REACTIONGLYPH_HEIGHT = 10.0;
    private static final double REACTIONGLYPH_WIDTH = 20.0;
    private static final double DEFAULT_Z_COORD = 0.0;
    protected int level;
    protected int version;
    private static final transient Logger logger = Logger.getLogger(SimpleLayoutAlgorithm.class.toString());
    protected Layout layout;
    protected Set<GraphicalObject> setOfLayoutedGlyphs = new HashSet<GraphicalObject>();
    protected Set<GraphicalObject> setOfUnlayoutedGlyphs = new HashSet<GraphicalObject>();

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public boolean isSetLayout() {
        return this.layout != null;
    }

    @Override
    public void setLayout(Layout layout) {
        this.layout = layout;
        this.level = layout.getLevel();
        this.version = layout.getVersion();
    }

    protected static RelativePosition getRelativePosition(Point startGlyph, Point endGlyph) {
        double startX = 0.0;
        double startY = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        Point posStart = startGlyph;
        Point posEnd = endGlyph;
        String error = "No coordinates given for the position of {0} bounding box.";
        if (posStart != null) {
            startX = posStart.getX();
            startY = posStart.getY();
        } else {
            logger.warning(MessageFormat.format(error, "start"));
        }
        if (posEnd != null) {
            endX = posEnd.getX();
            endY = posEnd.getY();
        } else {
            logger.warning(MessageFormat.format(error, "end"));
        }
        if (endX < startX) {
            if (endY > startY || endY == startY) {
                if (startX - endX >= endY - startY || endY == startY) {
                    return RelativePosition.LEFT;
                }
                return RelativePosition.BELOW;
            }
            if (startX - endX >= startY - endY) {
                return RelativePosition.LEFT;
            }
            return RelativePosition.ABOVE;
        }
        if (endX > startX) {
            if (endY > startY || endY == startY) {
                if (endX - startX >= endY - startY || endY == startY) {
                    return RelativePosition.RIGHT;
                }
                return RelativePosition.BELOW;
            }
            if (endX - startX >= startY - endY) {
                return RelativePosition.RIGHT;
            }
            return RelativePosition.ABOVE;
        }
        if (endY > startY) {
            return RelativePosition.BELOW;
        }
        if (endY < startY) {
            return RelativePosition.ABOVE;
        }
        logger.warning(MessageFormat.format("Could not compute relative position from {0} to {1}.", startGlyph, endGlyph));
        return RelativePosition.UNDEFINED;
    }

    protected Point calculateAverageCurvePosition(SpeciesReferenceRole specRefRole, List<SpeciesReferenceGlyph> specRefGlyphList) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double count = 0.0;
        for (SpeciesReferenceGlyph specRefGlyph : specRefGlyphList) {
            Curve curve;
            if (!specRefGlyph.isSetCurve() || !(curve = specRefGlyph.getCurve()).isSetListOfCurveSegments()) continue;
            for (CurveSegment curveSegment : curve.getListOfCurveSegments()) {
                LineSegment ls = (LineSegment)curveSegment;
                if (!specRefGlyph.isSetSpeciesReferenceRole() || !specRefGlyph.getSpeciesReferenceRole().equals((Object)specRefRole)) continue;
                if (specRefRole.equals((Object)SpeciesReferenceRole.PRODUCT) || specRefRole.equals((Object)SpeciesReferenceRole.SIDEPRODUCT)) {
                    if (!ls.isSetStart()) continue;
                    Point startPoint = ls.getStart();
                    x += startPoint.getX();
                    y += startPoint.getY();
                    z += startPoint.getZ();
                    count += 1.0;
                    continue;
                }
                if (!ls.isSetEnd()) continue;
                Point endPoint = ls.getEnd();
                x += endPoint.getX();
                y += endPoint.getY();
                z += endPoint.getZ();
                count += 1.0;
            }
        }
        if (count != 0.0) {
            x /= count;
            y /= count;
            z /= count;
        }
        return new Point(x, y, z, this.layout.getLevel(), this.layout.getVersion());
    }

    protected Point calculateAverageSpeciesPosition(SpeciesReferenceRole specRefRole, List<SpeciesReferenceGlyph> specRefGlyphList) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int count = 0;
        for (SpeciesReferenceGlyph specRefGlyph : specRefGlyphList) {
            SpeciesGlyph speciesGlyph;
            if (!specRefGlyph.isSetSpeciesGlyph() || !(speciesGlyph = specRefGlyph.getSpeciesGlyphInstance()).isSetBoundingBox() || !speciesGlyph.getBoundingBox().isSetPosition()) continue;
            Point position = speciesGlyph.getBoundingBox().getPosition();
            if (!specRefGlyph.isSetSpeciesReferenceRole() || !specRefGlyph.getSpeciesReferenceRole().equals((Object)specRefRole)) continue;
            x += position.getX();
            y += position.getY();
            z += position.getZ();
            ++count;
        }
        if (count != 0) {
            x /= (double)count;
            y /= (double)count;
            z /= (double)count;
        }
        return new Point(x, y, z, this.layout.getLevel(), this.layout.getVersion());
    }

    protected Point calculateCenter(GraphicalObject graphicalObject) {
        return SimpleLayoutAlgorithm.calculateCenter(graphicalObject, this.layout.getLevel(), this.layout.getVersion());
    }

    public static Point calculateCenter(GraphicalObject graphicalObject, int level, int version) {
        Point center = new Point(0.0, 0.0, 0.0, level, version);
        if (graphicalObject.isSetBoundingBox() && graphicalObject.getBoundingBox().isSetPosition()) {
            Point position = graphicalObject.getBoundingBox().getPosition();
            Dimensions dimensions = graphicalObject.getBoundingBox().getDimensions();
            center.setX(position.getX() + dimensions.getWidth() / 2.0);
            center.setY(position.getY() + dimensions.getHeight() / 2.0);
            center.setZ(position.getZ() + dimensions.getDepth() / 2.0);
        }
        return center;
    }

    protected Point calculateReactionGlyphDockingPoint(ReactionGlyph reacGlyph, double rotationAngle, SpeciesReferenceGlyph specRef) {
        Point dockingPointToSubstrate = new Point(this.layout.getLevel(), this.layout.getVersion());
        Point dockingPointToProduct = new Point(this.layout.getLevel(), this.layout.getVersion());
        Point dockingPointOtherLeft = new Point(this.layout.getLevel(), this.layout.getVersion());
        Point dockingPointOtherRight = new Point(this.layout.getLevel(), this.layout.getVersion());
        Point reactionCenterPosition = this.calculateCenter((GraphicalObject)reacGlyph);
        this.correctDimensions((GraphicalObject)reacGlyph);
        RelativePosition modifierPosition = SimpleLayoutAlgorithm.getRelativePosition(reacGlyph.getBoundingBox().getPosition(), specRef.getSpeciesGlyphInstance().getBoundingBox().getPosition());
        double rotationAngle_new = this.correctRotationAngle(rotationAngle);
        BoundingBox bbox = reacGlyph.getBoundingBox();
        double c = bbox.getDimensions().getWidth() / 2.0;
        double h = bbox.getDimensions().getHeight() / 2.0;
        double b = Math.abs(Math.cos(Math.toRadians(rotationAngle_new)) * c);
        double a = Math.abs(Math.sin(Math.toRadians(rotationAngle_new)) * c);
        double otherA = Math.abs(Math.sin(Math.toRadians(90.0 - rotationAngle_new))) * h;
        double otherB = Math.abs(Math.cos(Math.toRadians(90.0 - rotationAngle_new))) * h;
        if (rotationAngle >= 0.0 && rotationAngle < 90.0) {
            dockingPointToSubstrate.setX(reactionCenterPosition.getX() - b);
            dockingPointToSubstrate.setY(reactionCenterPosition.getY() - a);
            dockingPointToSubstrate.setZ(reactionCenterPosition.getZ());
            dockingPointToProduct.setX(reactionCenterPosition.getX() + b);
            dockingPointToProduct.setY(reactionCenterPosition.getY() + a);
            dockingPointToProduct.setZ(reactionCenterPosition.getZ());
            dockingPointOtherLeft.setX(reactionCenterPosition.getX() - otherA);
            dockingPointOtherLeft.setY(reactionCenterPosition.getY() + otherB);
            dockingPointOtherLeft.setZ(reactionCenterPosition.getZ());
            dockingPointOtherRight.setX(reactionCenterPosition.getX() + otherA);
            dockingPointOtherRight.setY(reactionCenterPosition.getY() - otherB);
            dockingPointOtherRight.setZ(reactionCenterPosition.getZ());
        } else if (rotationAngle >= 90.0 && rotationAngle < 180.0) {
            dockingPointToSubstrate.setX(reactionCenterPosition.getX() + a);
            dockingPointToSubstrate.setY(reactionCenterPosition.getY() - b);
            dockingPointToSubstrate.setZ(reactionCenterPosition.getZ());
            dockingPointToProduct.setX(reactionCenterPosition.getX() - a);
            dockingPointToProduct.setY(reactionCenterPosition.getY() + b);
            dockingPointToProduct.setZ(reactionCenterPosition.getZ());
            dockingPointOtherLeft.setX(reactionCenterPosition.getX() - otherA);
            dockingPointOtherLeft.setY(reactionCenterPosition.getY() + otherB);
            dockingPointOtherLeft.setZ(reactionCenterPosition.getZ());
            dockingPointOtherRight.setX(reactionCenterPosition.getX() + otherA);
            dockingPointOtherRight.setY(reactionCenterPosition.getY() - otherB);
            dockingPointOtherRight.setZ(reactionCenterPosition.getZ());
        } else if (rotationAngle >= 180.0 && rotationAngle < 270.0) {
            dockingPointToSubstrate.setX(reactionCenterPosition.getX() + b);
            dockingPointToSubstrate.setY(reactionCenterPosition.getY() + a);
            dockingPointToSubstrate.setZ(reactionCenterPosition.getZ());
            dockingPointToProduct.setX(reactionCenterPosition.getX() - b);
            dockingPointToProduct.setY(reactionCenterPosition.getY() - a);
            dockingPointToProduct.setZ(reactionCenterPosition.getZ());
            dockingPointOtherLeft.setX(reactionCenterPosition.getX() - otherB);
            dockingPointOtherLeft.setY(reactionCenterPosition.getY() - otherA);
            dockingPointOtherLeft.setZ(reactionCenterPosition.getZ());
            dockingPointOtherRight.setX(reactionCenterPosition.getX() + otherB);
            dockingPointOtherRight.setY(reactionCenterPosition.getY() + otherA);
            dockingPointOtherRight.setZ(reactionCenterPosition.getZ());
        } else {
            dockingPointToSubstrate.setX(reactionCenterPosition.getX() - a);
            dockingPointToSubstrate.setY(reactionCenterPosition.getY() + b);
            dockingPointToSubstrate.setZ(reactionCenterPosition.getZ());
            dockingPointToProduct.setX(reactionCenterPosition.getX() + a);
            dockingPointToProduct.setY(reactionCenterPosition.getY() - b);
            dockingPointToProduct.setZ(reactionCenterPosition.getZ());
            dockingPointOtherLeft.setX(reactionCenterPosition.getX() + otherA);
            dockingPointOtherLeft.setY(reactionCenterPosition.getY() - otherB);
            dockingPointOtherLeft.setZ(reactionCenterPosition.getZ());
            dockingPointOtherRight.setX(reactionCenterPosition.getX() - otherA);
            dockingPointOtherRight.setY(reactionCenterPosition.getY() + otherB);
            dockingPointOtherRight.setZ(reactionCenterPosition.getZ());
        }
        SpeciesReferenceRole specRefRole = specRef.getSpeciesReferenceRole();
        if (specRefRole != null) {
            if (specRefRole.equals((Object)SpeciesReferenceRole.SUBSTRATE) || specRefRole.equals((Object)SpeciesReferenceRole.SIDESUBSTRATE)) {
                return dockingPointToSubstrate;
            }
            if (specRefRole.equals((Object)SpeciesReferenceRole.PRODUCT) || specRefRole.equals((Object)SpeciesReferenceRole.SIDEPRODUCT)) {
                return dockingPointToProduct;
            }
        }
        if (modifierPosition.equals((Object)RelativePosition.LEFT)) {
            return dockingPointOtherLeft;
        }
        return dockingPointOtherRight;
    }

    protected double correctRotationAngle(double rotationAngle) {
        double correctedAngle = rotationAngle % 90.0;
        return correctedAngle < 0.0 ? correctedAngle + 90.0 : correctedAngle;
    }

    protected Point createSpeciesReferenceGlyphPosition(ReactionGlyph reactionGlyph, SpeciesReferenceGlyph specRefGlyph) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Curve curve = specRefGlyph.getCurve();
        if (curve == null) {
            curve = this.createCurve(reactionGlyph, specRefGlyph);
        }
        if (curve.isSetListOfCurveSegments()) {
            for (CurveSegment curveSegment : curve.getListOfCurveSegments()) {
                LineSegment ls = (LineSegment)curveSegment;
                Point startPoint = ls.getStart();
                Point endPoint = ls.getEnd();
                double startX = startPoint.getX();
                double startY = startPoint.getY();
                double startZ = startPoint.getZ();
                double endX = endPoint.getX();
                double endY = endPoint.getY();
                double endZ = endPoint.getZ();
                if (curveSegment instanceof CubicBezier) {
                    CubicBezier cb = (CubicBezier)curveSegment;
                    Point basePoint1 = cb.getBasePoint1();
                    Point basePoint2 = cb.getBasePoint2();
                    double minX = Math.min(startX, endX);
                    minX = Math.min(minX, basePoint1.getX());
                    x = minX = Math.min(minX, basePoint2.getX());
                    double minY = Math.min(startY, endY);
                    minY = Math.min(minY, basePoint1.getY());
                    y = minY = Math.min(minY, basePoint2.getY());
                    double minZ = Math.min(startZ, endZ);
                    minZ = Math.min(minZ, basePoint1.getZ());
                    z = minZ = Math.min(minZ, basePoint2.getZ());
                    continue;
                }
                if (startX == endX) {
                    double width = 5.0;
                    if (specRefGlyph.isSetBoundingBox() && specRefGlyph.getBoundingBox().isSetDimensions()) {
                        width = specRefGlyph.getBoundingBox().getDimensions().getWidth() / 2.0;
                    }
                    x = startX - width;
                } else {
                    x = Math.min(startX, endX);
                }
                if (startY == endY) {
                    double height = 5.0;
                    if (specRefGlyph.isSetBoundingBox() && specRefGlyph.getBoundingBox().isSetDimensions()) {
                        height = specRefGlyph.getBoundingBox().getDimensions().getHeight() / 2.0;
                    }
                    y = startY - height;
                } else {
                    y = Math.min(startY, endY);
                }
                if (startZ == endZ) {
                    double depth = 5.0;
                    if (specRefGlyph.isSetBoundingBox() && specRefGlyph.getBoundingBox().isSetDimensions()) {
                        depth = specRefGlyph.getBoundingBox().getDimensions().getDepth() / 2.0;
                    }
                    z = startZ - depth;
                    continue;
                }
                z = Math.min(startZ, endZ);
            }
        }
        return new Point(x, y, z, this.layout.getLevel(), this.layout.getVersion());
    }

    protected Point createReactionGlyphPositionNew(ReactionGlyph reactionGlyph) {
        ListOf speciesReferenceGlyphList = null;
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            speciesReferenceGlyphList = reactionGlyph.getListOfSpeciesReferenceGlyphs();
        }
        SpeciesGlyph product = null;
        SpeciesGlyph substrate = null;
        Point substrateEnd = null;
        Point productEnd = null;
        if (product == null || substrate == null) {
            if (speciesReferenceGlyphList != null) {
                for (SpeciesReferenceGlyph specRef : speciesReferenceGlyphList) {
                    if (LayoutDirector.isSubstrate(specRef)) {
                        substrate = specRef.getSpeciesGlyphInstance();
                        if (!specRef.isSetCurve() || specRef.getCurve().getCurveSegmentCount() <= 0 || !specRef.getCurve().getCurveSegment(specRef.getCurve().getCurveSegmentCount() - 1).isSetEnd()) continue;
                        substrateEnd = specRef.getCurve().getCurveSegment(specRef.getCurve().getCurveSegmentCount() - 1).getStart();
                        continue;
                    }
                    if (!LayoutDirector.isProduct(specRef)) continue;
                    product = specRef.getSpeciesGlyphInstance();
                    if (!specRef.isSetCurve() || specRef.getCurve().getCurveSegmentCount() <= 0 || !specRef.getCurve().getCurveSegment(0).isSetStart()) continue;
                    productEnd = specRef.getCurve().getCurveSegment(0).getStart();
                }
            }
            if (product == null || substrate == null) {
                logger.warning("Cannot find product or substrate in list of species reference glyphs for reaction glyph " + reactionGlyph.getId());
                return new Point(0.0, 0.0, 0.0, this.level, this.version);
            }
        }
        Point substrateCenter = substrateEnd != null ? substrateEnd : this.calculateCenter((GraphicalObject)substrate);
        Point productCenter = productEnd != null ? productEnd : this.calculateCenter((GraphicalObject)product);
        Dimensions rgDimensions = reactionGlyph.getBoundingBox().getDimensions();
        Point center = this.calculateCenterOfPoints(substrateCenter, productCenter);
        Point upperLeft = new Point(center.getX() - rgDimensions.getWidth() / 2.0, center.getY() - rgDimensions.getHeight() / 2.0, center.getZ() - rgDimensions.getDepth() / 2.0, this.level, this.version);
        logger.fine("substrate center is " + substrateCenter.toString());
        logger.fine("product center is " + productCenter.toString());
        logger.fine("center is " + center.toString());
        logger.fine("upper left is " + upperLeft.toString());
        return upperLeft;
    }

    private Point calculateCenterOfPoints(Point p1, Point p2) {
        Point p = new Point(this.level, this.version);
        p.setX((p1.getX() + p2.getX()) / 2.0);
        p.setY((p1.getY() + p2.getY()) / 2.0);
        p.setZ((p1.getZ() + p2.getZ()) / 2.0);
        return p;
    }

    protected Point createReactionGlyphPosition(ReactionGlyph reactionGlyph) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        ListOf speciesReferenceGlyphList = null;
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            speciesReferenceGlyphList = reactionGlyph.getListOfSpeciesReferenceGlyphs();
        }
        Dimensions reacGlyphDimension = reactionGlyph.isSetBoundingBox() && reactionGlyph.getBoundingBox().isSetDimensions() ? reactionGlyph.getBoundingBox().getDimensions() : this.createReactionGlyphDimension(reactionGlyph);
        SpeciesGlyph product = this.findSpeciesGlyphByRole((List<SpeciesReferenceGlyph>)speciesReferenceGlyphList, SpeciesReferenceRole.PRODUCT);
        SpeciesGlyph substrate = this.findSpeciesGlyphByRole((List<SpeciesReferenceGlyph>)speciesReferenceGlyphList, SpeciesReferenceRole.SUBSTRATE);
        if (product == null || substrate == null) {
            if (speciesReferenceGlyphList != null) {
                for (SpeciesReferenceGlyph specRef : speciesReferenceGlyphList) {
                    if (LayoutDirector.isSubstrate(specRef)) {
                        substrate = specRef.getSpeciesGlyphInstance();
                        continue;
                    }
                    if (!LayoutDirector.isProduct(specRef)) continue;
                    product = specRef.getSpeciesGlyphInstance();
                }
            }
            if (product == null || substrate == null) {
                logger.warning("Cannot find product or substrate in list of species reference glyphs for reaction glyph " + reactionGlyph.getId());
                return new Point(x, y, z, this.level, this.version);
            }
        }
        Point substratePointOfMiddle = this.calculateCenter((GraphicalObject)substrate);
        Point productPointOfMiddle = this.calculateCenter((GraphicalObject)product);
        x = (Math.max(productPointOfMiddle.getX(), substratePointOfMiddle.getX()) - Math.min(productPointOfMiddle.getX(), substratePointOfMiddle.getX())) / 2.0 + Math.min(productPointOfMiddle.getX(), substratePointOfMiddle.getX()) - reacGlyphDimension.getWidth() / 2.0;
        y = (Math.max(productPointOfMiddle.getY(), substratePointOfMiddle.getY()) - Math.min(productPointOfMiddle.getY(), substratePointOfMiddle.getY())) / 2.0 + Math.min(productPointOfMiddle.getY(), substratePointOfMiddle.getY()) - reacGlyphDimension.getHeight() / 2.0;
        z = (Math.max(productPointOfMiddle.getZ(), substratePointOfMiddle.getZ()) - Math.min(productPointOfMiddle.getZ(), substratePointOfMiddle.getZ())) / 2.0 + Math.min(productPointOfMiddle.getZ(), substratePointOfMiddle.getZ()) - reacGlyphDimension.getDepth() / 2.0;
        return new Point(x, y, z, this.level, this.version);
    }

    @Override
    public Dimensions createReactionGlyphDimension(ReactionGlyph reactionGlyph) {
        double width = 20.0;
        double height = 10.0;
        double depth = 0.0;
        if (this.layout.isSetListOfReactionGlyphs()) {
            for (ReactionGlyph reacGlyph : this.layout.getListOfReactionGlyphs()) {
                if (!reacGlyph.isSetBoundingBox() || !reacGlyph.getBoundingBox().isSetDimensions()) continue;
                double rWidth = reacGlyph.getBoundingBox().getDimensions().getWidth();
                double rHeight = reacGlyph.getBoundingBox().getDimensions().getHeight();
                width = Math.max(rHeight, rWidth);
                height = Math.min(rHeight, rWidth);
            }
        }
        LinkedList<SpeciesReferenceGlyph> curveList = new LinkedList<SpeciesReferenceGlyph>();
        LinkedList<SpeciesReferenceGlyph> speciesGlyphList = new LinkedList<SpeciesReferenceGlyph>();
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            for (SpeciesReferenceGlyph specRefGlyph : reactionGlyph.getListOfSpeciesReferenceGlyphs()) {
                if (specRefGlyph.isSetCurve()) {
                    curveList.add(specRefGlyph);
                    continue;
                }
                if (!specRefGlyph.isSetSpeciesGlyph()) continue;
                speciesGlyphList.add(specRefGlyph);
            }
        }
        if (curveList.size() >= speciesGlyphList.size()) {
            Point productPosition;
            Point substratePosition = this.calculateAverageCurvePosition(SpeciesReferenceRole.SUBSTRATE, curveList);
            RelativePosition relativePosition = SimpleLayoutAlgorithm.getRelativePosition(substratePosition, productPosition = this.calculateAverageCurvePosition(SpeciesReferenceRole.PRODUCT, curveList));
            if (relativePosition.equals((Object)RelativePosition.ABOVE)) {
                height = substratePosition.getY() - productPosition.getY();
            }
            if (relativePosition.equals((Object)RelativePosition.BELOW)) {
                height = productPosition.getY() - substratePosition.getY();
            }
            if (relativePosition.equals((Object)RelativePosition.LEFT)) {
                width = substratePosition.getX() - productPosition.getX();
            }
            if (relativePosition.equals((Object)RelativePosition.RIGHT)) {
                width = productPosition.getX() - substratePosition.getX();
            }
        }
        return new Dimensions(width, height, depth, this.level, this.version);
    }

    @Override
    public double calculateReactionGlyphRotationAngle(ReactionGlyph reactionGlyph) {
        double rotationAngle = 0.0;
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            ListOf speciesRefGlyphList = reactionGlyph.getListOfSpeciesReferenceGlyphs();
            SpeciesGlyph substrate = this.findSpeciesGlyphByRole((List<SpeciesReferenceGlyph>)speciesRefGlyphList, SpeciesReferenceRole.SUBSTRATE);
            SpeciesGlyph product = this.findSpeciesGlyphByRole((List<SpeciesReferenceGlyph>)speciesRefGlyphList, SpeciesReferenceRole.PRODUCT);
            if (substrate == null || product == null) {
                for (SpeciesReferenceGlyph specRef : speciesRefGlyphList) {
                    if (LayoutDirector.isSubstrate(specRef)) {
                        substrate = specRef.getSpeciesGlyphInstance();
                        continue;
                    }
                    if (!LayoutDirector.isProduct(specRef)) continue;
                    product = specRef.getSpeciesGlyphInstance();
                }
                if (substrate == null || product == null) {
                    logger.warning(MessageFormat.format("Cannot find product or substrate in list of species reference glyphs for reaction glyph {0}", reactionGlyph.getId()));
                    return rotationAngle;
                }
            }
            Point firstCentralPoint = this.calculateCenter((GraphicalObject)substrate);
            Point secondCentralPoint = this.calculateCenter((GraphicalObject)product);
            if (reactionGlyph.isSetUserObjects() && reactionGlyph.getUserObject((Object)"SPECIAL_ROTATION_NEEDED") != null) {
                for (SpeciesReferenceGlyph specRefGlyph : speciesRefGlyphList) {
                    LineSegment ls;
                    Curve curve = null;
                    if (specRefGlyph.isSetCurve()) {
                        curve = specRefGlyph.getCurve();
                    } else {
                        if (!reactionGlyph.isSetCurve()) break;
                        curve = reactionGlyph.getCurve();
                    }
                    if (specRefGlyph.isSetSpeciesReferenceRole() && specRefGlyph.getSpeciesReferenceRole().equals((Object)SpeciesReferenceRole.SUBSTRATE) && curve.isSetListOfCurveSegments()) {
                        ls = (LineSegment)curve.getListOfCurveSegments().getLast();
                        firstCentralPoint = ls.getEnd();
                    }
                    if (!specRefGlyph.isSetSpeciesReferenceRole() || !specRefGlyph.getSpeciesReferenceRole().equals((Object)SpeciesReferenceRole.PRODUCT) || !curve.isSetListOfCurveSegments()) continue;
                    ls = (LineSegment)curve.getListOfCurveSegments().getFirst();
                    secondCentralPoint = ls.getStart();
                }
            }
            if (firstCentralPoint.getX() == secondCentralPoint.getX() && firstCentralPoint.getY() == secondCentralPoint.getY()) {
                secondCentralPoint = this.calculateCenter((GraphicalObject)reactionGlyph);
                logger.fine(MessageFormat.format("The two points for computing rotation angle are identical for {0} with id ''{1}'': ({2,number}; {3,number})", reactionGlyph.getElementName(), reactionGlyph.getId(), firstCentralPoint.getX(), firstCentralPoint.getY()));
            } else {
                rotationAngle = SimpleLayoutAlgorithm.calculateRotationAngle(firstCentralPoint, secondCentralPoint);
            }
        }
        return rotationAngle;
    }

    public static double calculateRotationAngle(Point startPoint, Point endPoint) {
        double rotationAngle = 0.0;
        double x = endPoint.getX() - startPoint.getX();
        double y = endPoint.getY() - startPoint.getY();
        rotationAngle = Math.toDegrees(Math.atan(y / x));
        if (endPoint.getX() < startPoint.getX()) {
            rotationAngle += 180.0;
        } else if (endPoint.getY() < startPoint.getY()) {
            rotationAngle += 360.0;
        }
        logger.fine(MessageFormat.format("start: {0} end: {1} deltaX: {2} deltaY: {3} rotation: {4}", startPoint, endPoint, x, y, rotationAngle));
        return rotationAngle;
    }

    @Deprecated
    protected Point calculateOldSpeciesGlyphDockingPosition(Point middleOfSpecies, RelativePosition relativeSpeciesGlyphPosition, SpeciesGlyph specGlyph) {
        Point dockingPosition = null;
        double x = middleOfSpecies.getX();
        double y = middleOfSpecies.getY();
        double z = middleOfSpecies.getZ();
        double width = specGlyph.getBoundingBox().getDimensions().getWidth();
        double height = specGlyph.getBoundingBox().getDimensions().getHeight();
        Point dockingLeft = new Point(x - width / 2.0, y, z, this.level, this.version);
        Point dockingRight = new Point(x + width / 2.0, y, z, this.level, this.version);
        Point dockingAbove = new Point(x, y - height / 2.0, z, this.level, this.version);
        Point dockingBelow = new Point(x, y + height / 2.0, z, this.level, this.version);
        if (relativeSpeciesGlyphPosition.equals((Object)RelativePosition.ABOVE)) {
            dockingPosition = new Point(dockingBelow);
        } else if (relativeSpeciesGlyphPosition.equals((Object)RelativePosition.BELOW)) {
            dockingPosition = new Point(dockingAbove);
        } else if (relativeSpeciesGlyphPosition.equals((Object)RelativePosition.LEFT)) {
            dockingPosition = new Point(dockingRight);
        } else if (relativeSpeciesGlyphPosition.equals((Object)RelativePosition.RIGHT)) {
            dockingPosition = new Point(dockingLeft);
        }
        return dockingPosition;
    }

    protected Point calculateSpeciesGlyphDockingPosition(Point centerOfSpecies, ReactionGlyph reactionGlyph, SpeciesReferenceRole speciesReferenceRole, SpeciesGlyph speciesGlyph) {
        Point dockingPoint = null;
        double x = centerOfSpecies.getX();
        double y = centerOfSpecies.getY();
        double z = centerOfSpecies.getZ();
        Dimensions dimensions = speciesGlyph.getBoundingBox().getDimensions();
        double width = dimensions.getWidth();
        double height = dimensions.getHeight();
        int sboTerm = -1;
        if (speciesGlyph.isSetSBOTerm()) {
            sboTerm = speciesGlyph.getSBOTerm();
        } else if (speciesGlyph.isSetSpecies()) {
            sboTerm = speciesGlyph.getSpeciesInstance().getSBOTerm();
        }
        double t = 0.0;
        t = speciesReferenceRole.equals((Object)SpeciesReferenceRole.PRODUCT) || speciesReferenceRole.equals((Object)SpeciesReferenceRole.SIDEPRODUCT) ? SimpleLayoutAlgorithm.calculateRotationAngle(this.calculateCenter((GraphicalObject)reactionGlyph), centerOfSpecies) : SimpleLayoutAlgorithm.calculateRotationAngle(centerOfSpecies, this.calculateCenter((GraphicalObject)reactionGlyph));
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getUnknownMolecule()) || sboTerm == -1) {
            dockingPoint = this.calculateDockingForEllipseSpecies(x, y, z, width, height, SimpleLayoutAlgorithm.calculateRotationAngle(centerOfSpecies, this.calculateCenter((GraphicalObject)reactionGlyph)));
        } else if (SBO.isChildOf((int)sboTerm, (int)SBO.getSimpleMolecule()) || SBO.isChildOf((int)sboTerm, (int)SBO.getEmptySet())) {
            double c = height / 2.0;
            dockingPoint = this.calculateDockingForRoundSpecies(x, y, z, c, t, speciesReferenceRole);
        } else {
            dockingPoint = this.calculateDockingForQuadraticSpecies(centerOfSpecies, speciesGlyph, this.calculateCenter((GraphicalObject)reactionGlyph));
        }
        return dockingPoint;
    }

    private Point calculateDockingForEllipseSpecies(double x, double y, double z, double width, double height, double angle) {
        double xCoordinate = 0.0;
        double yCoordinate = 0.0;
        double t = this.correctRotationAngle(angle);
        double tant = Math.tan(Math.toDegrees(t)) * (width / 2.0) / (height / 2.0);
        double new_width = width / 2.0 * Math.cos(tant);
        double new_height = height / 2.0 * Math.sin(tant);
        if (angle >= 0.0 && angle < 90.0) {
            xCoordinate = x + new_width;
            yCoordinate = y - new_height;
        } else if (angle >= 90.0 && angle < 180.0) {
            xCoordinate = x - new_width;
            yCoordinate = y - new_height;
        } else if (angle >= 180.0 && angle < 270.0) {
            xCoordinate = x - new_width;
            yCoordinate = y + new_height;
        } else {
            xCoordinate = x + new_width;
            yCoordinate = y + new_height;
        }
        return new Point(xCoordinate, yCoordinate, z, this.level, this.version);
    }

    private Point calculateDockingForRoundSpecies(double x, double y, double z, double c, double rotationAngle, SpeciesReferenceRole speciesReferenceRole) {
        double xCoordinate = 0.0;
        double yCoordinate = 0.0;
        double rotationAngleCorrected = this.correctRotationAngle(rotationAngle);
        if (speciesReferenceRole.equals((Object)SpeciesReferenceRole.PRODUCT) || speciesReferenceRole.equals((Object)SpeciesReferenceRole.SIDEPRODUCT)) {
            c = -c;
        }
        double a = c * Math.abs(Math.sin(Math.toRadians(rotationAngleCorrected)));
        double b = c * Math.abs(Math.cos(Math.toRadians(rotationAngleCorrected)));
        if (rotationAngle >= 0.0 && rotationAngle < 90.0) {
            xCoordinate = x + b;
            yCoordinate = y + a;
        } else if (rotationAngle >= 90.0 && rotationAngle < 180.0) {
            xCoordinate = x - a;
            yCoordinate = y + b;
        } else if (rotationAngle >= 180.0 && rotationAngle < 270.0) {
            xCoordinate = x - b;
            yCoordinate = y - a;
        } else {
            xCoordinate = x + a;
            yCoordinate = y - b;
        }
        return new Point(xCoordinate, yCoordinate, z, this.level, this.version);
    }

    private Point calculateDockingForQuadraticSpecies(Point centerOfSpecies, SpeciesGlyph speciesGlyph, Point centerOfReaction) {
        Point dockingPoint = new Point(this.level, this.version);
        dockingPoint.setZ(0.0);
        double reacX = centerOfReaction.getX();
        double reacY = centerOfReaction.getY();
        double specX = centerOfSpecies.getX();
        double specY = centerOfSpecies.getY();
        Dimensions dimensions = speciesGlyph.getBoundingBox().getDimensions();
        double width = dimensions.getWidth();
        double height = dimensions.getHeight();
        if (Math.abs(specY - reacY) <= height / 2.0 && specX != reacX) {
            double b = width / 2.0;
            double a = Math.abs(specY - reacY) * b / Math.abs(specX - reacX);
            if (specX < reacX) {
                dockingPoint.setX(specX + b);
            } else {
                dockingPoint.setX(specX - b);
            }
            if (specY == reacY || specY < reacY) {
                dockingPoint.setY(specY + a);
            } else {
                dockingPoint.setY(specY - a);
            }
        } else {
            double a = height / 2.0;
            double b = Math.abs(specX - reacX) * a / Math.abs(specX - reacX);
            if (specX == reacX) {
                b = 0.0;
            }
            if (specY < reacY) {
                dockingPoint.setY(specY + a);
            } else {
                dockingPoint.setY(specY - a);
            }
            if (specX < reacX) {
                dockingPoint.setX(specX + b);
            } else {
                dockingPoint.setX(specX - b);
            }
        }
        return dockingPoint;
    }

    protected BoundingBox createBoundingBoxWithLevelAndVersion() {
        return new BoundingBox(this.layout.getLevel(), this.layout.getVersion());
    }

    public Layout findLayout(GraphicalObject graphicalObject) {
        SBase parent = null;
        while ((parent = graphicalObject.getParent()) != null && !(parent instanceof Layout)) {
        }
        return (Layout)parent;
    }

    protected SpeciesGlyph findSpeciesGlyphByRole(List<SpeciesReferenceGlyph> speciesReferenceGlyphList, SpeciesReferenceRole speciesReferenceRole) {
        SpeciesGlyph specGlyph = null;
        if (speciesReferenceGlyphList != null) {
            for (SpeciesReferenceGlyph specRefGlyph : speciesReferenceGlyphList) {
                SpeciesGlyph speciesGlyph;
                if (!specRefGlyph.isSetSpeciesGlyph() || !(speciesGlyph = specRefGlyph.getSpeciesGlyphInstance()).isSetBoundingBox() || !speciesGlyph.getBoundingBox().isSetPosition() || !specRefGlyph.isSetSpeciesReferenceRole() || !specRefGlyph.getSpeciesReferenceRole().equals((Object)speciesReferenceRole)) continue;
                specGlyph = speciesGlyph;
            }
        }
        return specGlyph;
    }

    public void correctDimensions(GraphicalObject glyph) {
        BoundingBox bb = glyph.getBoundingBox();
        Dimensions dimension = bb.getDimensions();
        double width = dimension.getWidth();
        double height = dimension.getHeight();
        if (glyph instanceof AbstractReferenceGlyph && !(glyph instanceof ReactionGlyph) && !(glyph instanceof CompartmentGlyph) && !(glyph instanceof TextGlyph)) {
            AbstractReferenceGlyph nsbGlyph = (AbstractReferenceGlyph)glyph;
            int sboTerm = -1;
            if (nsbGlyph.isSetReference()) {
                sboTerm = nsbGlyph.getNamedSBaseInstance().getSBOTerm();
            }
            if (SBO.isChildOf((int)sboTerm, (int)SBO.getSimpleMolecule()) || SBO.isChildOf((int)sboTerm, (int)SBO.getIon()) || SBO.isChildOf((int)sboTerm, (int)SBO.getEmptySet())) {
                if (width != height) {
                    bb.createDimensions(height, height, 0.0);
                }
            } else if (width < height) {
                dimension.setWidth(height);
                dimension.setHeight(width);
            }
        }
    }

    public static enum RelativePosition {
        ABOVE,
        BELOW,
        LEFT,
        RIGHT,
        UNDEFINED;

    }
}

