/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.Transformation2D;
import org.sbml.jsbml.ext.render.XMLTools;
import org.sbml.jsbml.util.StringTools;

public class GraphicalPrimitive1D
extends Transformation2D {
    private static final long serialVersionUID = 3705246334810811216L;
    protected String stroke;
    protected List<Short> strokeDashArray;
    protected Double strokeWidth;

    public List<Short> getStrokeDashArray() {
        if (!this.isSetStrokeDashArray()) {
            this.strokeDashArray = new ArrayList<Short>();
        }
        return this.strokeDashArray;
    }

    public boolean isSetStrokeDashArray() {
        return this.strokeDashArray != null;
    }

    public void setStrokeDashArray(Short[] strokeDashArray) {
        this.setStrokeDashArray(Arrays.asList(strokeDashArray));
    }

    public boolean setStrokeDashArray(List<Short> strokeDashArray) {
        List<Short> oldStrokeDashArray = this.strokeDashArray;
        this.strokeDashArray = strokeDashArray;
        this.firePropertyChange("stroke-dasharray", oldStrokeDashArray, this.strokeDashArray);
        return strokeDashArray != oldStrokeDashArray;
    }

    public boolean unsetStrokeDashArray() {
        return this.setStrokeDashArray((List<Short>)null);
    }

    public GraphicalPrimitive1D() {
        this.initDefaults();
    }

    public GraphicalPrimitive1D(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public GraphicalPrimitive1D(GraphicalPrimitive1D obj) {
        super(obj);
        this.stroke = obj.stroke;
        this.strokeWidth = obj.strokeWidth;
        if (obj.isSetStrokeDashArray()) {
            for (int i = 0; i < obj.getStrokeDashArray().size(); ++i) {
                this.addStrokeDash((short)obj.getStrokeDash(i));
            }
        }
    }

    public boolean addStrokeDash(Short s) {
        return this.getStrokeDashArray().add(s);
    }

    public Short getStrokeDash(int i) {
        return this.isSetStrokeDashArray() ? this.strokeDashArray.get(i) : null;
    }

    @Override
    public GraphicalPrimitive1D clone() {
        return new GraphicalPrimitive1D(this);
    }

    @Override
    public int hashCode() {
        int prime = 3181;
        int result = super.hashCode();
        result = 3181 * result + (this.stroke == null ? 0 : this.stroke.hashCode());
        if (this.isSetStrokeDashArray()) {
            result = 3181 * result + this.strokeDashArray.hashCode();
        }
        result = 3181 * result + (this.strokeWidth == null ? 0 : this.strokeWidth.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GraphicalPrimitive1D other = (GraphicalPrimitive1D)((Object)obj);
        if (this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke)) {
            return false;
        }
        if (this.isSetStrokeDashArray() != other.isSetStrokeDashArray() || this.isSetStrokeDashArray() && !this.getStrokeDashArray().equals(other.getStrokeDashArray())) {
            return false;
        }
        return !(this.strokeWidth == null ? other.strokeWidth != null : !this.strokeWidth.equals(other.strokeWidth));
    }

    public String getStroke() {
        if (this.isSetStroke()) {
            return this.stroke;
        }
        throw new PropertyUndefinedError("stroke", (SBase)this);
    }

    public Double getStrokeWidth() {
        if (this.isSetStrokeWidth()) {
            return this.strokeWidth;
        }
        throw new PropertyUndefinedError("stroke-width", (SBase)this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    public boolean isSetStroke() {
        return this.stroke != null;
    }

    public boolean isSetStrokeWidth() {
        return this.strokeWidth != null;
    }

    public void setStroke(String stroke) {
        String oldStroke = this.stroke;
        this.stroke = stroke;
        this.firePropertyChange("stroke", oldStroke, this.stroke);
    }

    public void setStrokeWidth(double strokeWidth) {
        Double oldStrokeWidth = this.strokeWidth;
        this.strokeWidth = strokeWidth;
        this.firePropertyChange("stroke-width", oldStrokeWidth, this.strokeWidth);
    }

    public boolean unsetStroke() {
        if (this.isSetStroke()) {
            String oldStroke = this.stroke;
            this.stroke = null;
            this.firePropertyChange("stroke", oldStroke, this.stroke);
            return true;
        }
        return false;
    }

    public boolean unsetStrokeWidth() {
        if (this.isSetStrokeWidth()) {
            Double oldStrokeWidth = this.strokeWidth;
            this.strokeWidth = null;
            this.firePropertyChange("stroke-width", oldStrokeWidth, this.strokeWidth);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetStroke()) {
            attributes.put("render:stroke", this.getStroke());
        }
        if (this.isSetStrokeDashArray()) {
            attributes.put("render:stroke-dasharray", XMLTools.encodeArrayShortToString(this.getStrokeDashArray().toArray(new Short[0])));
        }
        if (this.isSetStrokeWidth()) {
            attributes.put("render:stroke-width", this.getStrokeWidth().toString().toLowerCase());
        }
        if (this.isSetId()) {
            attributes.put("render:id", this.getId());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("stroke")) {
                this.setStroke(value);
            } else if (attributeName.equals("stroke-dasharray")) {
                this.setStrokeDashArray(XMLTools.decodeStringToArrayShort(value));
            } else if (attributeName.equals("stroke-width")) {
                this.setStrokeWidth(StringTools.parseSBMLDoubleStrict((String)value));
            } else if (attributeName.equals("id")) {
                this.setId(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

