/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.RelAbsVector;
import org.sbml.jsbml.ext.render.Transformation2D;

public class Image
extends Transformation2D {
    private static final long serialVersionUID = 6031110715160806863L;
    private RelAbsVector x;
    private RelAbsVector y;
    private RelAbsVector z;
    private RelAbsVector width;
    private RelAbsVector height;
    private String href;

    public Image() {
        this.initDefaults();
    }

    public Image(String id) {
        this.setId(id);
        this.initDefaults();
    }

    public Image(Image obj) {
        super(obj);
        this.height = obj.height;
        this.href = obj.href;
        this.width = obj.width;
        this.x = obj.x;
        this.y = obj.y;
        this.z = obj.z;
    }

    @Override
    public Image clone() {
        return new Image(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.z = new RelAbsVector(0.0);
    }

    @Override
    public int hashCode() {
        int prime = 3137;
        int result = super.hashCode();
        result = 3137 * result + (this.height == null ? 0 : this.height.hashCode());
        result = 3137 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 3137 * result + (this.width == null ? 0 : this.width.hashCode());
        result = 3137 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 3137 * result + (this.y == null ? 0 : this.y.hashCode());
        result = 3137 * result + (this.z == null ? 0 : this.z.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)((Object)obj);
        if (this.height == null ? other.height != null : !this.height.equals((Object)other.height)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.width == null ? other.width != null : !this.width.equals((Object)other.width)) {
            return false;
        }
        if (this.x == null ? other.x != null : !this.x.equals((Object)other.x)) {
            return false;
        }
        if (this.y == null ? other.y != null : !this.y.equals((Object)other.y)) {
            return false;
        }
        return !(this.z == null ? other.z != null : !this.z.equals((Object)other.z));
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getChildCount() {
        int count = 0;
        return count;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public RelAbsVector getHeight() {
        if (this.isSetHeight()) {
            return this.height;
        }
        throw new PropertyUndefinedError("height", (SBase)this);
    }

    public boolean isSetHeight() {
        return this.height != null;
    }

    public void setHeight(RelAbsVector height) {
        RelAbsVector oldHeight = this.height;
        this.height = height;
        this.firePropertyChange("height", (Object)oldHeight, (Object)this.height);
    }

    public boolean unsetHeight() {
        if (this.isSetHeight()) {
            RelAbsVector oldHeight = this.height;
            this.height = null;
            this.firePropertyChange("height", (Object)oldHeight, (Object)this.height);
            return true;
        }
        return false;
    }

    public String getHref() {
        if (this.isSetHref()) {
            return this.href;
        }
        throw new PropertyUndefinedError("href", (SBase)this);
    }

    public boolean isSetHref() {
        return this.href != null;
    }

    public void setHref(String href) {
        String oldHref = this.href;
        this.href = href;
        this.firePropertyChange("href", oldHref, this.href);
    }

    public boolean unsetHref() {
        if (this.isSetHref()) {
            String oldHref = this.href;
            this.href = null;
            this.firePropertyChange("href", oldHref, this.href);
            return true;
        }
        return false;
    }

    public RelAbsVector getWidth() {
        if (this.isSetWidth()) {
            return this.width;
        }
        throw new PropertyUndefinedError("width", (SBase)this);
    }

    public boolean isSetWidth() {
        return this.width != null;
    }

    public void setWidth(RelAbsVector width) {
        RelAbsVector oldWidth = this.width;
        this.width = width;
        this.firePropertyChange("width", (Object)oldWidth, (Object)this.width);
    }

    public boolean unsetWidth() {
        if (this.isSetWidth()) {
            RelAbsVector oldWidth = this.width;
            this.width = null;
            this.firePropertyChange("width", (Object)oldWidth, (Object)this.width);
            return true;
        }
        return false;
    }

    public RelAbsVector getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    public boolean isSetX() {
        return this.x != null;
    }

    public void setX(RelAbsVector x) {
        RelAbsVector oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", (Object)oldX, (Object)this.x);
    }

    public boolean unsetX() {
        if (this.isSetX()) {
            RelAbsVector oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", (Object)oldX, (Object)this.x);
            return true;
        }
        return false;
    }

    public RelAbsVector getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    public boolean isSetY() {
        return this.y != null;
    }

    public void setY(RelAbsVector y) {
        RelAbsVector oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", (Object)oldY, (Object)this.y);
    }

    public boolean unsetY() {
        if (this.isSetY()) {
            RelAbsVector oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", (Object)oldY, (Object)this.y);
            return true;
        }
        return false;
    }

    public RelAbsVector getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    public boolean isSetZ() {
        return this.z != null;
    }

    public void setZ(RelAbsVector z) {
        RelAbsVector oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", (Object)oldZ, (Object)this.z);
    }

    public boolean unsetZ() {
        if (this.isSetZ()) {
            RelAbsVector oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", (Object)oldZ, (Object)this.z);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetHref()) {
            attributes.remove("href");
            attributes.put("render:href", this.getHref());
        }
        if (this.isSetX()) {
            attributes.remove("x");
            attributes.put("render:x", this.x.getCoordinate());
        }
        if (this.isSetY()) {
            attributes.remove("y");
            attributes.put("render:y", this.y.getCoordinate());
        }
        if (this.isSetZ()) {
            attributes.remove("z");
            attributes.put("render:z", this.z.getCoordinate());
        }
        if (this.isSetWidth()) {
            attributes.remove("width");
            attributes.put("render:width", this.width.getCoordinate());
        }
        if (this.isSetHeight()) {
            attributes.remove("height");
            attributes.put("render:height", this.width.getCoordinate());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("href")) {
                this.setHref(value);
            } else if (attributeName.equals("x")) {
                this.setX(new RelAbsVector(value));
            } else if (attributeName.equals("y")) {
                this.setY(new RelAbsVector(value));
            } else if (attributeName.equals("z")) {
                this.setZ(new RelAbsVector(value));
            } else if (attributeName.equals("width")) {
                this.setWidth(new RelAbsVector(value));
            } else if (attributeName.equals("height")) {
                this.setHeight(new RelAbsVector(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

