/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractTreeNode;

public class RelAbsVector
extends AbstractTreeNode {
    private static final long serialVersionUID = 7621009594700491178L;
    private Double absolute;
    private Double relative;
    private static final String ABSOLUTE_PATTERN = "-?((\\.\\d+)|(\\d+(\\.\\d*)?))";
    private static final String RELATIVE_PATTERN = "-?((\\.\\d+)|(\\d+(\\.\\d*)?))\\%";

    public RelAbsVector() {
    }

    public RelAbsVector(RelAbsVector original) {
        super((TreeNode)((Object)original));
        this.absolute = original.absolute;
        this.relative = original.relative;
    }

    public RelAbsVector(double absolute) {
        this.absolute = absolute;
    }

    public RelAbsVector(double absolute, double relative) {
        this.absolute = absolute;
        this.relative = relative;
    }

    public RelAbsVector(String coordinate) {
        this.setCoordinate(coordinate);
    }

    public RelAbsVector clone() {
        return new RelAbsVector(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RelAbsVector other = (RelAbsVector)((Object)obj);
        if (this.absolute == null ? other.absolute != null : !this.absolute.equals(other.absolute)) {
            return false;
        }
        return !(this.relative == null ? other.relative != null : !this.relative.equals(other.relative));
    }

    public double getAbsoluteValue() {
        return this.absolute;
    }

    public double getRelativeValue() {
        return this.relative;
    }

    public void setAbsoluteValue(double absolute) {
        Double old = this.absolute;
        this.absolute = absolute;
        this.firePropertyChange("absoluteValue", old, absolute);
    }

    public void setRelativeValue(double relative) {
        Double old = this.relative;
        this.relative = relative;
        this.firePropertyChange("relativeValue", old, relative);
    }

    public boolean isSetAbsoluteValue() {
        return this.absolute != null && !this.absolute.isNaN();
    }

    public boolean isSetRelativeValue() {
        return this.relative != null && !this.relative.isNaN();
    }

    public boolean unsetAbsoluteValue() {
        if (this.isSetAbsoluteValue()) {
            Double old = this.absolute;
            this.absolute = null;
            this.firePropertyChange("absoluteValue", old, this.absolute);
            return true;
        }
        return false;
    }

    public boolean unsetRelativeValue() {
        if (this.isSetRelativeValue()) {
            Double old = this.relative;
            this.relative = null;
            this.firePropertyChange("relativeValue", old, this.relative);
            return true;
        }
        return false;
    }

    public boolean setCoordinate(String coordinates) {
        if (coordinates != null && (coordinates = coordinates.replaceAll("\\s+", "")).length() > 0) {
            String[] entries = coordinates.split("(\\+|(?=-))");
            if (entries.length == 1) {
                String entry = entries[0];
                if (entry.matches(RELATIVE_PATTERN)) {
                    this.setRelativeValue(Double.parseDouble(entry.substring(0, entry.length() - 1)));
                    return true;
                }
                if (entry.matches(ABSOLUTE_PATTERN)) {
                    this.setAbsoluteValue(Double.parseDouble(entry));
                    return true;
                }
            } else if (entries.length == 2 && entries[0].matches(ABSOLUTE_PATTERN) && entries[1].matches(RELATIVE_PATTERN)) {
                this.setAbsoluteValue(Double.parseDouble(entries[0]));
                this.setRelativeValue(Double.parseDouble(entries[1].substring(0, entries[1].length() - 1)));
                return true;
            }
        }
        this.setAbsoluteValue(Double.NaN);
        this.setRelativeValue(Double.NaN);
        return false;
    }

    public String getCoordinate() {
        if (!this.isSetAbsoluteValue() && !this.isSetRelativeValue()) {
            return "0";
        }
        StringBuffer result = new StringBuffer();
        if (this.isSetAbsoluteValue() && this.getAbsoluteValue() != 0.0) {
            result.append(this.getAbsoluteValue());
        }
        if (this.isSetRelativeValue() && this.getRelativeValue() != 0.0) {
            if (this.getRelativeValue() > 0.0 && this.isSetAbsoluteValue() && this.getAbsoluteValue() != 0.0) {
                result.append("+");
            }
            result.append(this.getRelativeValue());
            result.append("%");
        }
        if (result.length() == 0) {
            result.append("0");
        }
        return result.toString();
    }

    public String toString() {
        return String.format("RelAbsVector [absolute=%s, relative=%s]", this.absolute, this.relative);
    }

    public int hashCode() {
        int prime = 3061;
        int result = super.hashCode();
        result = 3061 * result + (this.absolute == null ? 0 : this.absolute.hashCode());
        result = 3061 * result + (this.relative == null ? 0 : this.relative.hashCode());
        return result;
    }

    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean getAllowsChildren() {
        return false;
    }
}

