/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.FontFamily;
import org.sbml.jsbml.ext.render.FontRenderStyle;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.ext.render.HTextAnchor;
import org.sbml.jsbml.ext.render.Point3D;
import org.sbml.jsbml.ext.render.RelAbsVector;
import org.sbml.jsbml.ext.render.VTextAnchor;
import org.sbml.jsbml.ext.render.XMLTools;

public class Text
extends GraphicalPrimitive1D
implements FontRenderStyle,
Point3D {
    private static final long serialVersionUID = -7468181076596795203L;
    private String fontFamily;
    private RelAbsVector fontSize;
    private Boolean fontWeightBold;
    private Boolean fontStyleItalic;
    private HTextAnchor textAnchor;
    private VTextAnchor vTextAnchor;
    private RelAbsVector x;
    private RelAbsVector y;
    private RelAbsVector z;
    private String text;

    public Text() {
        this.initDefaults();
    }

    public Text(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Text(Text obj) {
        super(obj);
        this.fontFamily = obj.fontFamily;
        this.fontSize = obj.fontSize;
        this.fontStyleItalic = obj.fontStyleItalic;
        this.fontWeightBold = obj.fontWeightBold;
        this.textAnchor = obj.textAnchor;
        this.vTextAnchor = obj.vTextAnchor;
        this.x = obj.x;
        this.y = obj.y;
        this.z = obj.z;
        this.text = obj.text;
    }

    @Override
    public Text clone() {
        return new Text(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    @Override
    public String getFontFamily() {
        if (this.isSetFontFamily()) {
            return this.fontFamily;
        }
        throw new PropertyUndefinedError("font-family", (SBase)this);
    }

    @Override
    public RelAbsVector getFontSize() {
        if (this.isSetFontSize()) {
            return this.fontSize;
        }
        throw new PropertyUndefinedError("font-size", (SBase)this);
    }

    public String getText() {
        if (this.isSetText()) {
            return this.text;
        }
        throw new PropertyUndefinedError("text", (SBase)this);
    }

    @Override
    public HTextAnchor getTextAnchor() {
        if (this.isSetTextAnchor()) {
            return this.textAnchor;
        }
        throw new PropertyUndefinedError("text-anchor", (SBase)this);
    }

    @Override
    public VTextAnchor getVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            return this.vTextAnchor;
        }
        throw new PropertyUndefinedError("vtext-anchor", (SBase)this);
    }

    @Override
    public RelAbsVector getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    @Override
    public RelAbsVector getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    @Override
    public RelAbsVector getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    @Override
    public boolean isFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            return this.fontStyleItalic;
        }
        throw new PropertyUndefinedError("font-style", (SBase)this);
    }

    @Override
    public boolean isFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            return this.fontWeightBold;
        }
        throw new PropertyUndefinedError("font-weight", (SBase)this);
    }

    @Override
    public boolean isSetFontFamily() {
        return this.fontFamily != null;
    }

    @Override
    public boolean isSetFontSize() {
        return this.fontSize != null;
    }

    @Override
    public boolean isSetFontStyleItalic() {
        return this.fontStyleItalic != null;
    }

    @Override
    public boolean isSetFontWeightBold() {
        return this.fontWeightBold != null;
    }

    public boolean isSetText() {
        return this.text != null;
    }

    @Override
    public boolean isSetTextAnchor() {
        return this.textAnchor != null;
    }

    @Override
    public boolean isSetVTextAnchor() {
        return this.vTextAnchor != null;
    }

    @Override
    public boolean isSetX() {
        return this.x != null;
    }

    @Override
    public boolean isSetY() {
        return this.y != null;
    }

    @Override
    public boolean isSetZ() {
        return this.z != null;
    }

    @Override
    public void setFontFamily(String fontFamily) {
        String oldFontFamily = this.fontFamily;
        this.fontFamily = fontFamily;
        this.firePropertyChange("font-family", oldFontFamily, this.fontFamily);
    }

    @Override
    public void setFontFamily(FontFamily fontFamily) {
        String fontFam = fontFamily.toString();
        this.setFontFamily(fontFam);
    }

    @Override
    public void setFontSize(RelAbsVector fontSize) {
        RelAbsVector oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange("font-size", (Object)oldFontSize, (Object)this.fontSize);
    }

    @Override
    public void setFontStyleItalic(boolean fontStyleItalic) {
        Boolean oldFontStyleItalic = this.fontStyleItalic;
        this.fontStyleItalic = fontStyleItalic;
        this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
    }

    @Override
    public void setFontWeightBold(boolean fontWeightBold) {
        Boolean oldFontWeightBold = this.fontWeightBold;
        this.fontWeightBold = fontWeightBold;
        this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        this.firePropertyChange("text", oldText, this.text);
    }

    @Override
    public void setTextAnchor(HTextAnchor textAnchor) {
        HTextAnchor oldTextAnchor = this.textAnchor;
        this.textAnchor = textAnchor;
        this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
    }

    @Override
    public void setVTextAnchor(VTextAnchor vTextAnchor) {
        VTextAnchor oldVTextAnchor = this.vTextAnchor;
        this.vTextAnchor = vTextAnchor;
        this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
    }

    @Override
    public void setX(RelAbsVector x) {
        RelAbsVector oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", (Object)oldX, (Object)this.x);
    }

    @Override
    public void setY(RelAbsVector y) {
        RelAbsVector oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", (Object)oldY, (Object)this.y);
    }

    @Override
    public void setZ(RelAbsVector z) {
        RelAbsVector oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", (Object)oldZ, (Object)this.z);
    }

    @Override
    public boolean unsetFontFamily() {
        if (this.isSetFontFamily()) {
            String oldFontFamily = this.fontFamily;
            this.fontFamily = null;
            this.firePropertyChange("font-family", oldFontFamily, this.fontFamily);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontSize() {
        if (this.isSetFontSize()) {
            RelAbsVector oldFontSize = this.fontSize;
            this.fontSize = null;
            this.firePropertyChange("font-size", (Object)oldFontSize, (Object)this.fontSize);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontStyleItalic() {
        if (this.isSetFontStyleItalic()) {
            Boolean oldFontStyleItalic = this.fontStyleItalic;
            this.fontStyleItalic = null;
            this.firePropertyChange("font-style", oldFontStyleItalic, this.fontStyleItalic);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetFontWeightBold() {
        if (this.isSetFontWeightBold()) {
            Boolean oldFontWeightBold = this.fontWeightBold;
            this.fontWeightBold = null;
            this.firePropertyChange("font-weight", oldFontWeightBold, this.fontWeightBold);
            return true;
        }
        return false;
    }

    public boolean unsetText() {
        if (this.isSetText()) {
            String oldText = this.text;
            this.text = null;
            this.firePropertyChange("text", oldText, this.text);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetTextAnchor() {
        if (this.isSetTextAnchor()) {
            HTextAnchor oldTextAnchor = this.textAnchor;
            this.textAnchor = null;
            this.firePropertyChange("text-anchor", (Object)oldTextAnchor, (Object)this.textAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetVTextAnchor() {
        if (this.isSetVTextAnchor()) {
            VTextAnchor oldVTextAnchor = this.vTextAnchor;
            this.vTextAnchor = null;
            this.firePropertyChange("vtext-anchor", (Object)oldVTextAnchor, (Object)this.vTextAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetX() {
        if (this.isSetX()) {
            RelAbsVector oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", (Object)oldX, (Object)this.x);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetY() {
        if (this.isSetY()) {
            RelAbsVector oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", (Object)oldY, (Object)this.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsetZ() {
        if (this.isSetZ()) {
            RelAbsVector oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", (Object)oldZ, (Object)this.z);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetFontFamily()) {
            String fontFamily = this.getFontFamily();
            attributes.put("render:font-family", fontFamily);
        }
        if (this.isSetTextAnchor()) {
            attributes.put("render:text-anchor", this.getTextAnchor().toString().toLowerCase());
        }
        if (this.isSetVTextAnchor()) {
            attributes.put("render:vtext-anchor", this.getVTextAnchor().toString().toLowerCase());
        }
        if (this.isSetFontSize()) {
            attributes.put("render:font-size", this.getFontSize().getCoordinate());
        }
        if (this.isSetX()) {
            attributes.put("render:x", this.getX().getCoordinate());
        }
        if (this.isSetY()) {
            attributes.put("render:y", this.getY().getCoordinate());
        }
        if (this.isSetZ()) {
            attributes.put("render:z", this.getZ().getCoordinate());
        }
        if (this.isSetFontStyleItalic()) {
            attributes.put("font-style", XMLTools.fontStyleItalicToString(this.isFontStyleItalic()));
        }
        if (this.isSetFontWeightBold()) {
            attributes.put("font-weight", XMLTools.fontWeightBoldToString(this.isFontWeightBold()));
        }
        return attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (isAttributeRead) return isAttributeRead;
        isAttributeRead = true;
        if (attributeName.equals("font-family")) {
            this.setFontFamily(value);
            return isAttributeRead;
        } else if (attributeName.equals("text-anchor")) {
            try {
                this.setTextAnchor(HTextAnchor.valueOf(value.toUpperCase()));
                return isAttributeRead;
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognize the value '" + value + "' for the attribute " + "text-anchor" + " on the 'text' element.");
            }
        } else if (attributeName.equals("vtext-anchor")) {
            try {
                this.setVTextAnchor(VTextAnchor.valueOf(value.toUpperCase()));
                return isAttributeRead;
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognize the value '" + value + "' for the attribute " + "vtext-anchor" + " on the 'text' element.");
            }
        } else if (attributeName.equals("font-size")) {
            this.setFontSize(new RelAbsVector(value));
            return isAttributeRead;
        } else if (attributeName.equals("x")) {
            this.setX(new RelAbsVector(value));
            return isAttributeRead;
        } else if (attributeName.equals("y")) {
            this.setY(new RelAbsVector(value));
            return isAttributeRead;
        } else if (attributeName.equals("z")) {
            this.setZ(new RelAbsVector(value));
            return isAttributeRead;
        } else if (attributeName.equals("font-style")) {
            if (!value.toLowerCase().equals("normal")) {
                if (!value.toLowerCase().equals("italic")) throw new SBMLException("Could not recognize the value '" + value + "' for the attribute " + "font-style" + " on the 'text' element.");
            }
            this.setFontStyleItalic(XMLTools.parseFontStyleItalic(value));
            return isAttributeRead;
        } else {
            if (!attributeName.equals("font-weight")) return false;
            if (!value.toLowerCase().equals("normal")) {
                if (!value.toLowerCase().equals("bold")) throw new SBMLException("Could not recognize the value '" + value + "' for the attribute " + "font-weight" + " on the 'text' element.");
            }
            this.setFontWeightBold(XMLTools.parseFontWeightBold(value));
        }
        return isAttributeRead;
    }

    @Override
    public int hashCode() {
        int prime = 3163;
        int result = super.hashCode();
        result = 3163 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result = 3163 * result + (this.fontSize == null ? 0 : this.fontSize.hashCode());
        result = 3163 * result + (this.fontStyleItalic == null ? 0 : this.fontStyleItalic.hashCode());
        result = 3163 * result + (this.fontWeightBold == null ? 0 : this.fontWeightBold.hashCode());
        result = 3163 * result + (this.textAnchor == null ? 0 : this.textAnchor.hashCode());
        result = 3163 * result + (this.vTextAnchor == null ? 0 : this.vTextAnchor.hashCode());
        result = 3163 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 3163 * result + (this.y == null ? 0 : this.y.hashCode());
        result = 3163 * result + (this.z == null ? 0 : this.z.hashCode());
        result = 3163 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Text other = (Text)obj;
        if (!this.fontFamily.equals(other.fontFamily)) {
            return false;
        }
        if (this.fontSize == null ? other.fontSize != null : !this.fontSize.equals((Object)other.fontSize)) {
            return false;
        }
        if (this.fontStyleItalic == null ? other.fontStyleItalic != null : !this.fontStyleItalic.equals(other.fontStyleItalic)) {
            return false;
        }
        if (this.fontWeightBold == null ? other.fontWeightBold != null : !this.fontWeightBold.equals(other.fontWeightBold)) {
            return false;
        }
        if (this.textAnchor != other.textAnchor) {
            return false;
        }
        if (this.vTextAnchor != other.vTextAnchor) {
            return false;
        }
        if (this.x == null ? other.x != null : !this.x.equals((Object)other.x)) {
            return false;
        }
        if (this.y == null ? other.y != null : !this.y.equals((Object)other.y)) {
            return false;
        }
        if (this.z == null ? other.z != null : !this.z.equals((Object)other.z)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        String result = super.toString();
        if (this.isSetText()) {
            result = result.substring(0, result.length() - 1);
            result = result + " text=" + this.getText() + "]";
        }
        return result;
    }
}

