/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.awt.Color;
import java.util.Locale;
import org.sbml.jsbml.util.StringTools;

public class XMLTools {
    public static String positioningToString(double x, boolean absoluteX) {
        if (absoluteX) {
            return StringTools.toString((Locale)Locale.ENGLISH, (double)x);
        }
        return StringTools.toString((Locale)Locale.ENGLISH, (double)x) + "%";
    }

    public static String fontStyleItalicToString(boolean fontStyleItalic) {
        return fontStyleItalic ? "italic" : "normal";
    }

    public static String fontWeightBoldToString(boolean fontWeightBold) {
        return fontWeightBold ? "bold" : "normal";
    }

    public static Boolean isAbsolutePosition(String value) {
        return !value.endsWith("%");
    }

    public static Double parsePosition(String value) {
        if (XMLTools.isAbsolutePosition(value).booleanValue()) {
            return StringTools.parseSBMLDoubleStrict((String)value);
        }
        return StringTools.parseSBMLDoubleStrict((String)value.substring(0, value.length() - 1));
    }

    public static boolean parseFontStyleItalic(String value) {
        return value.equals("italic");
    }

    public static boolean parseFontWeightBold(String value) {
        return value.equals("bold");
    }

    public static String encodeColorToString(Color value) {
        int r = value.getRed();
        int g = value.getGreen();
        int b = value.getBlue();
        int a = value.getAlpha();
        return ("#" + XMLTools.toHexString(r) + XMLTools.toHexString(g) + XMLTools.toHexString(b) + XMLTools.toHexString(a)).toUpperCase();
    }

    private static String toHexString(int a) {
        String h = Integer.toHexString(a);
        return h.length() == 1 ? "0" + h : h;
    }

    public static Color decodeStringToColor(String value) {
        int r = Integer.parseInt(value.substring(1, 3), 16);
        int g = Integer.parseInt(value.substring(3, 5), 16);
        int b = Integer.parseInt(value.substring(5, 7), 16);
        int a = 255;
        if (value.length() == 9) {
            a = Integer.parseInt(value.substring(7, 9), 16);
        }
        return new Color(r, g, b, a);
    }

    public static String arrayToWhitespaceSeparatedString(String[] list) {
        String output = "";
        for (int i = 0; i < list.length; ++i) {
            output = output + list[i];
            if (i == list.length - 1) continue;
            output = output + " ";
        }
        return output;
    }

    public static String encodeArrayDoubleToString(Double[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            if (!s.isEmpty()) {
                s = s + ", ";
            }
            s = s + StringTools.toString((Locale)Locale.ENGLISH, (double)array[i]);
        }
        return s;
    }

    public static Double[] decodeStringToArrayDouble(String value) {
        String[] array = value.split(", ");
        Double[] temp = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            temp[i] = StringTools.parseSBMLDouble((String)array[i]);
        }
        return temp;
    }

    public static boolean canDecodeStringToArrayDouble(String value) {
        String[] array;
        for (String s : array = value.split(", ")) {
            try {
                Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static String encodeArrayShortToString(Short[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            if (!s.isEmpty()) {
                s = s + ", ";
            }
            s = s + Short.toString(array[i]);
        }
        return s;
    }

    public static Short[] decodeStringToArrayShort(String value) {
        String[] array = value.split(", ");
        Short[] temp = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            temp[i] = StringTools.parseSBMLShort((String)array[i]);
        }
        return temp;
    }

    public static boolean canDecodeStringToArrayUnsignedInt(String value) {
        String[] array;
        for (String s : array = value.split(", ")) {
            try {
                Integer.parseUnsignedInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

