/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.text.MessageFormat;
import java.util.logging.Logger;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceRole;
import org.sbml.jsbml.ext.render.director.LayoutBuilder;
import org.sbml.jsbml.ext.render.director.LayoutFactory;
import org.sbml.jsbml.ext.render.director.SBGNArc;
import org.sbml.jsbml.ext.render.director.SBGNNode;
import org.sbml.jsbml.ext.render.director.SBGNProcessNode;

public abstract class AbstractLayoutBuilder<P, NodeT, ArcT>
implements LayoutBuilder<P>,
LayoutFactory<NodeT, ArcT> {
    private static final transient Logger logger = Logger.getLogger(AbstractLayoutBuilder.class.getName());
    protected boolean terminated = false;

    public SBGNArc<ArcT> createArc(SpeciesReferenceGlyph srg, ReactionGlyph reactionGlyph) {
        logger.fine(MessageFormat.format("building arc from srgId=''{0}'' to rgId=''{1}''", srg.getId(), reactionGlyph.getId()));
        int sboTerm = -1;
        SpeciesReferenceRole speciesReferenceRole = null;
        SBGNArc<ArcT> arc = null;
        if (srg.isSetSpeciesReferenceRole()) {
            speciesReferenceRole = srg.getSpeciesReferenceRole();
            sboTerm = speciesReferenceRole.toSBOterm();
            if (srg.isSetSpeciesReference()) {
                NamedSBase specRef = srg.getSpeciesReferenceInstance();
                if (specRef == null) {
                    logger.fine(MessageFormat.format("Encountered undefined identifier ''{0}'' in speciesReferenceGlyph ''{1}''.", srg.getReference(), srg.getId()));
                } else if (specRef.isSetSBOTerm() && SBO.isChildOf((int)specRef.getSBOTerm(), (int)sboTerm)) {
                    sboTerm = specRef.getSBOTerm();
                }
            }
            logger.fine("SRG role " + speciesReferenceRole);
        } else {
            sboTerm = srg.getSBOTerm();
            logger.fine("SRG sbo term " + sboTerm);
        }
        Reaction reaction = (Reaction)reactionGlyph.getReactionInstance();
        boolean reactionIsReversible = reaction != null && reaction.isSetReversible() && reaction.isReversible();
        arc = reactionIsReversible && (sboTerm != -1 && SBO.isChildOf((int)sboTerm, (int)SBO.getConsumption()) || speciesReferenceRole != null && (speciesReferenceRole == SpeciesReferenceRole.SUBSTRATE || speciesReferenceRole == SpeciesReferenceRole.SIDESUBSTRATE)) ? this.createReversibleConsumption() : this.getSBGNArc(sboTerm);
        return arc;
    }

    public SBGNNode<NodeT> getSBGNNode(int sboTerm) {
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getSimpleMolecule())) {
            return this.createSimpleChemical();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getIon())) {
            return this.createSimpleChemical();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getMacromolecule())) {
            return this.createMacromolecule();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getGene())) {
            return this.createNucleicAcidFeature();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getMessengerRNA())) {
            return this.createNucleicAcidFeature();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getEmptySet())) {
            return this.createSourceSink();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getUnknownMolecule())) {
            return this.createUnspecifiedNode();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getCompartment())) {
            return this.createCompartment();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getPertubingAgent())) {
            return this.createPerturbingAgent();
        }
        return this.createUnspecifiedNode();
    }

    public SBGNArc<ArcT> getSBGNArc(int sboTerm) {
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getConsumption()) || SBO.isChildOf((int)sboTerm, (int)SBO.getReactant())) {
            return this.createConsumption();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getProduction()) || SBO.isChildOf((int)sboTerm, (int)SBO.getProduct())) {
            return this.createProduction();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getCatalysis()) || SBO.isChildOf((int)sboTerm, (int)SBO.getCatalyst())) {
            return this.createCatalysis();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getInhibition()) || SBO.isChildOf((int)sboTerm, (int)SBO.getInhibitor())) {
            return this.createInhibition();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getNecessaryStimulation()) || SBO.isChildOf((int)sboTerm, (int)SBO.getTrigger())) {
            return this.createNecessaryStimulation();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getStimulation()) || SBO.isChildOf((int)sboTerm, (int)SBO.getStimulator()) || SBO.isChildOf((int)sboTerm, (int)SpeciesReferenceRole.ACTIVATOR.toSBOterm())) {
            return this.createStimulation();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getModulation()) || SBO.isChildOf((int)sboTerm, (int)SBO.getModifier())) {
            return this.createModulation();
        }
        return this.createConsumption();
    }

    public SBGNArc<ArcT> getSBGNArc(SpeciesReferenceRole speciesReferenceRole) {
        return this.getSBGNArc(speciesReferenceRole.toSBOterm());
    }

    public SBGNProcessNode<NodeT> getSBGNReactionNode(int sboTerm) {
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getTransitionOmitted())) {
            return this.createOmittedProcessNode();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getUnknownTransition())) {
            return this.createUncertainProcessNode();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getDissociation())) {
            return this.createDissociationNode();
        }
        if (SBO.isChildOf((int)sboTerm, (int)SBO.getAssociation())) {
            return this.createAssociationNode();
        }
        return this.createProcessNode();
    }

    @Override
    public boolean isProductReady() {
        return this.terminated;
    }
}

