/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;

public class Geometry {
    public static GeneralPath toGeneralPath(Curve curve) {
        GeneralPath path = new GeneralPath();
        int i = 0;
        for (CurveSegment segment : curve.getListOfCurveSegments()) {
            Point start = segment.getStart();
            Point end = segment.getEnd();
            if (i == 0) {
                path.moveTo(start.getX(), start.getY());
            } else {
                path.lineTo(start.getX(), start.getY());
            }
            if (segment instanceof LineSegment) {
                path.lineTo(end.getX(), end.getY());
            } else {
                CubicBezier cb = (CubicBezier)segment;
                Point bp1 = cb.getBasePoint1();
                Point bp2 = cb.getBasePoint2();
                path.curveTo(bp1.getX(), bp1.getY(), bp2.getX(), bp2.getY(), end.getX(), end.getY());
            }
            ++i;
        }
        return path;
    }

    public static GeneralPath normalize(GeneralPath path) {
        double[] buffer = new double[6];
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        PathIterator it = path.getPathIterator(null);
        while (!it.isDone()) {
            int i;
            int coordCount = 0;
            switch (it.currentSegment(buffer)) {
                case 0: {
                    coordCount = 2;
                    break;
                }
                case 1: {
                    coordCount = 2;
                    break;
                }
                case 2: {
                    coordCount = 4;
                    break;
                }
                case 3: {
                    coordCount = 6;
                    break;
                }
                case 4: {
                    coordCount = 0;
                }
            }
            for (i = 0; i < coordCount; i += 2) {
                if (minX > buffer[i]) {
                    minX = buffer[i];
                }
                if (!(maxX < buffer[i])) continue;
                maxX = buffer[i];
            }
            for (i = 1; i < coordCount; i += 2) {
                if (minY > buffer[i]) {
                    minY = buffer[i];
                }
                if (!(maxY < buffer[i])) continue;
                maxY = buffer[i];
            }
            it.next();
        }
        double w = maxX - minX;
        double h = maxY - minY;
        GeneralPath copy = new GeneralPath();
        PathIterator it2 = path.getPathIterator(null);
        while (!it2.isDone()) {
            switch (it2.currentSegment(buffer)) {
                case 0: {
                    copy.moveTo((buffer[0] - minX) / w, (buffer[1] - minY) / h);
                    break;
                }
                case 1: {
                    copy.lineTo((buffer[0] - minX) / w, (buffer[1] - minY) / h);
                    break;
                }
                case 2: {
                    copy.quadTo((buffer[0] - minX) / w, (buffer[1] - minY) / h, (buffer[2] - minX) / w, (buffer[3] - minY) / h);
                    break;
                }
                case 3: {
                    copy.curveTo((buffer[0] - minX) / w, (buffer[1] - minY) / h, (buffer[2] - minX) / w, (buffer[3] - minY) / h, (buffer[4] - minX) / w, (buffer[5] - minY) / h);
                    break;
                }
                case 4: {
                    copy.closePath();
                }
            }
            it2.next();
        }
        return copy;
    }

    public static Point center(BoundingBox bbox) {
        Point pos = bbox.getPosition();
        Dimensions d = bbox.getDimensions();
        Point p = new Point(pos.x(), pos.y(), pos.z(), pos.getLevel(), pos.getVersion());
        p.setX(d.getWidth() + p.x());
        p.setY(d.getHeight() + p.y());
        p.setZ(d.getDepth() + p.z());
        return p;
    }

    public static double euclideanDistance(Point a, Point b) {
        double d = 0.0;
        double r = 2.0;
        d += Math.pow(a.getX() - b.getX(), r);
        d += Math.pow(a.getY() - b.getY(), r);
        return Math.pow(d += Math.pow(a.getZ() - b.getZ(), r), 1.0 / r);
    }

    public static Point weightedSum(double weightA, Point a, double weightB, Point b) {
        return new Point(weightA * a.getX() + weightB * b.getX(), weightA * a.getY() + weightB * b.getY(), weightA * a.getZ() + weightB * b.getZ());
    }

    public static double dotProduct(Point a, Point b) {
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
    }
}

