/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutConstants;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceRole;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.util.SBMLtools;

public class GlyphCreator {
    public static final String LAYOUT_LINK = "GLYPH";
    private static final Logger logger = Logger.getLogger(GlyphCreator.class.getName());
    private Model model;

    public GlyphCreator(Model model) {
        this.model = model;
    }

    public void create() {
        logger.info("Initializing layout");
        SBMLDocument doc = this.model.getSBMLDocument();
        String namespace = LayoutConstants.getNamespaceURI((int)this.model.getLevel(), (int)this.model.getVersion());
        LayoutModelPlugin extLayout = new LayoutModelPlugin(this.model);
        this.model.addExtension(namespace, (SBasePlugin)extLayout);
        Layout layout = extLayout.createLayout(SBMLtools.nextId((Model)this.model));
        layout.setName("auto_layout");
        doc.addNamespace("layout", "xmlns", namespace);
        doc.getSBMLDocumentAttributes().put("layout:required", "false");
        int degreeThreshold = 3;
        if (this.model.isSetListOfCompartments()) {
            for (Compartment c : this.model.getListOfCompartments()) {
                logger.info("Processing compartment " + c.getId());
                CompartmentGlyph compartmentGlyph = layout.createCompartmentGlyph(SBMLtools.nextId((Model)this.model), c.getId());
                TextGlyph textGlyph = layout.createTextGlyph(SBMLtools.nextId((Model)this.model));
                textGlyph.setOriginOfText(c.getId());
                textGlyph.setGraphicalObject(compartmentGlyph.getId());
            }
        }
        HashMap<String, Set<String>> speciesToReactions = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> reactionToReactants = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> reactionToProducts = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> reactionToModifiers = new HashMap<String, Set<String>>();
        if (this.model.isSetListOfReactions()) {
            for (Reaction r : this.model.getListOfReactions()) {
                logger.info("Linking species to reaction " + r.getId());
                if (r.isSetListOfModifiers()) {
                    for (ModifierSpeciesReference ref : r.getListOfModifiers()) {
                        this.linkReferenceToReaction((SimpleSpeciesReference)ref, r, speciesToReactions);
                        this.linkSpeciesToReaction((SimpleSpeciesReference)ref, r, reactionToModifiers);
                    }
                }
                if (r.isSetListOfReactants()) {
                    for (ModifierSpeciesReference ref : r.getListOfReactants()) {
                        this.linkReferenceToReaction((SimpleSpeciesReference)ref, r, speciesToReactions);
                        this.linkSpeciesToReaction((SimpleSpeciesReference)ref, r, reactionToReactants);
                    }
                }
                if (!r.isSetListOfProducts()) continue;
                for (ModifierSpeciesReference ref : r.getListOfProducts()) {
                    this.linkReferenceToReaction((SimpleSpeciesReference)ref, r, speciesToReactions);
                    this.linkSpeciesToReaction((SimpleSpeciesReference)ref, r, reactionToProducts);
                }
            }
        }
        HashMap<String, List<String>> species2glyph = new HashMap<String, List<String>>();
        HashMap<String, Integer> sGlyphDegree = new HashMap<String, Integer>();
        if (this.model.isSetListOfSpecies()) {
            for (Species s : this.model.getListOfSpecies()) {
                logger.info("Processing species " + s.getId());
                SpeciesGlyph sGlyph = this.createSpeciesGlyph(layout, s, doc);
                LinkedList<String> list = new LinkedList<String>();
                list.add(sGlyph.getId());
                species2glyph.put(s.getId(), list);
                sGlyphDegree.put(sGlyph.getId(), 0);
            }
        }
        if (this.model.isSetListOfReactions()) {
            for (Reaction r : this.model.getListOfReactions()) {
                logger.info("Processing reaction " + r.getId());
                ReactionGlyph rGlyph = layout.createReactionGlyph(SBMLtools.nextId((Model)this.model), r.getId());
                if (r.isSetListOfModifiers()) {
                    for (ModifierSpeciesReference ref : r.getListOfModifiers()) {
                        this.createSpeciesReferenceGlyph(doc, rGlyph, (SimpleSpeciesReference)ref, this.createOrGetGlyph((SimpleSpeciesReference)ref, species2glyph, sGlyphDegree, degreeThreshold, doc, layout), this.determineRole(ref.getSBOTerm()));
                    }
                }
                if (r.isSetListOfProducts()) {
                    for (ModifierSpeciesReference ref : r.getListOfProducts()) {
                        this.createSpeciesReferenceGlyph(doc, rGlyph, (SimpleSpeciesReference)ref, this.createOrGetGlyph((SimpleSpeciesReference)ref, species2glyph, sGlyphDegree, degreeThreshold, doc, layout), SpeciesReferenceRole.PRODUCT);
                    }
                } else {
                    this.createEmptySetReactionParticipant(layout, rGlyph, SpeciesReferenceRole.PRODUCT, doc);
                }
                if (r.isSetListOfReactants()) {
                    for (ModifierSpeciesReference ref : r.getListOfReactants()) {
                        this.createSpeciesReferenceGlyph(doc, rGlyph, (SimpleSpeciesReference)ref, this.createOrGetGlyph((SimpleSpeciesReference)ref, species2glyph, sGlyphDegree, degreeThreshold, doc, layout), SpeciesReferenceRole.SUBSTRATE);
                    }
                    continue;
                }
                this.createEmptySetReactionParticipant(layout, rGlyph, SpeciesReferenceRole.SUBSTRATE, doc);
            }
        }
    }

    private String createOrGetGlyph(SimpleSpeciesReference ref, Map<String, List<String>> species2glyph, Map<String, Integer> sGlyphDegree, int degreeThreshold, SBMLDocument doc, Layout layout) {
        List<String> listOfSpeciesGlyphs = species2glyph.get(ref.getSpecies());
        String glyphId = listOfSpeciesGlyphs.get(listOfSpeciesGlyphs.size() - 1);
        if (sGlyphDegree.get(glyphId) >= degreeThreshold) {
            SpeciesGlyph sGlyph = this.createSpeciesGlyph(layout, ref.getSpeciesInstance(), doc);
            glyphId = sGlyph.getId();
            listOfSpeciesGlyphs.add(glyphId);
            sGlyphDegree.put(glyphId, 1);
        } else {
            SpeciesGlyph sGlyph = (SpeciesGlyph)this.model.findNamedSBase(glyphId);
            sGlyphDegree.put(glyphId, sGlyphDegree.get(glyphId) + 1);
        }
        return glyphId;
    }

    private SpeciesReferenceRole determineRole(int sboTerm) {
        SpeciesReferenceRole modifier = SpeciesReferenceRole.MODIFIER;
        if (sboTerm > -1) {
            if (SBO.isInhibitor((int)sboTerm)) {
                modifier = SpeciesReferenceRole.INHIBITOR;
            } else if (SBO.isStimulator((int)sboTerm)) {
                modifier = SpeciesReferenceRole.ACTIVATOR;
            }
        }
        return modifier;
    }

    private void linkSpeciesToReaction(SimpleSpeciesReference ref, Reaction r, Map<String, Set<String>> reactionToSpecies) {
        if (!reactionToSpecies.containsKey(r.getId())) {
            reactionToSpecies.put(r.getId(), new HashSet());
        }
        reactionToSpecies.get(r.getId()).add(ref.getId());
    }

    private void linkReferenceToReaction(SimpleSpeciesReference ref, Reaction r, Map<String, Set<String>> speciesToReactions) {
        if (!speciesToReactions.containsKey(ref.getSpecies())) {
            speciesToReactions.put(ref.getSpecies(), new HashSet());
        }
        speciesToReactions.get(ref.getSpecies()).add(r.getId());
    }

    private void createEmptySetReactionParticipant(Layout layout, ReactionGlyph rGlyph, SpeciesReferenceRole role, SBMLDocument doc) {
        SpeciesGlyph glyph = this.createSpeciesGlyph(layout, null, doc);
        SpeciesReferenceGlyph sRG = rGlyph.createSpeciesReferenceGlyph(this.genId(doc, null), glyph.getId());
        sRG.setRole(role);
    }

    private SpeciesGlyph createSpeciesGlyph(Layout layout, Species s, SBMLDocument doc) {
        SpeciesGlyph speciesGlyph = layout.createSpeciesGlyph(this.genId(doc, (NamedSBase)s), s != null ? s.getId() : null);
        if (s != null) {
            if (s.getUserObject((Object)LAYOUT_LINK) == null) {
                s.putUserObject((Object)LAYOUT_LINK, new LinkedList());
            }
            if (!SBO.isChildOf((int)s.getSBOTerm(), (int)SBO.getEmptySet())) {
                TextGlyph textGlyph = layout.createTextGlyph(SBMLtools.nextId((Model)this.model));
                textGlyph.setOriginOfText(s.getId());
                textGlyph.setGraphicalObject(speciesGlyph.getId());
            }
        } else {
            SBMLtools.setSBOTerm((SBase)speciesGlyph, (int)SBO.getEmptySet());
        }
        return speciesGlyph;
    }

    private void createSpeciesReferenceGlyph(SBMLDocument doc, ReactionGlyph rGlyph, SimpleSpeciesReference ref, String speciesGlyphId, SpeciesReferenceRole role) {
        SpeciesReferenceGlyph sRG = rGlyph.createSpeciesReferenceGlyph(this.genId(doc, (NamedSBase)ref.getSpeciesInstance()), speciesGlyphId);
        sRG.setRole(role);
    }

    private String genId(SBMLDocument doc, NamedSBase ref) {
        return SBMLtools.nameToSId((String)((ref != null ? ref.getId() : "empty") + "_glyph_"), (SBMLDocument)doc);
    }
}

