/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutConstants;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceRole;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.ext.render.director.LayoutAlgorithm;
import org.sbml.jsbml.ext.render.director.LayoutBuilder;
import org.sbml.jsbml.ext.render.director.RenderProcessor;
import org.sbml.jsbml.util.SBMLtools;
import org.sbml.jsbml.util.StringTools;

public class LayoutDirector<P>
implements Runnable {
    public static final String SPECIAL_ROTATION_NEEDED = "SPECIAL_ROTATION_NEEDED";
    public static final String NO_WHISKERS = "NO_WHISKERS";
    private static final double DEFAULT_CURVE_WIDTH = 2.0;
    private static final transient Logger logger = Logger.getLogger(LayoutDirector.class.getName());
    public static final String KEY_FOR_FLUX_VALUES = "fluxValue";
    public static final String LAYOUT_LINK = "LAYOUT_LINK";
    public static final String COMPARTMENT_LINK = "COMPARTMENT_LINK";
    public static final String PN_RELATIVE_DOCKING_POINT = "PN_RELATIVE_DOCKING_POINT";
    public static final String SPECIES_RELATIVE_DOCKING_POINT = "SPECIES_RELATIVE_DOCKING_POINT";
    private LayoutAlgorithm algorithm;
    private LayoutBuilder<P> builder;
    private Model model;
    private int layoutIndex;
    private Map<String, Double> mapOfFluxes;
    private Boolean addWhiskers = true;

    public LayoutDirector(File inputFile, LayoutBuilder<P> builder, LayoutAlgorithm algorithm) throws XMLStreamException, IOException {
        this(SBMLReader.read((File)inputFile), builder, algorithm);
    }

    public LayoutDirector(SBMLDocument doc, LayoutBuilder<P> builder, LayoutAlgorithm algorithm) {
        this(doc, builder, algorithm, 0);
    }

    public LayoutDirector(SBMLDocument doc, LayoutBuilder<P> builder, LayoutAlgorithm algorithm, int index) {
        this(((LayoutModelPlugin)doc.getModel().getExtension(LayoutConstants.getNamespaceURI((int)doc.getLevel(), (int)doc.getVersion()))).getLayout(index), builder, algorithm);
    }

    public LayoutDirector(Layout layout, LayoutBuilder<P> builder, LayoutAlgorithm algorithm) {
        this.model = layout.getModel();
        this.builder = builder;
        this.algorithm = algorithm;
        LayoutModelPlugin ext = (LayoutModelPlugin)this.model.getExtension(LayoutConstants.getNamespaceURI((int)layout.getLevel(), (int)layout.getVersion()));
        this.layoutIndex = ext != null && ext.isSetListOfLayouts() ? ext.getListOfLayouts().indexOf((Object)layout) : -1;
    }

    public Boolean getAddWhiskers() {
        if (this.isSetAddWhiskers().booleanValue()) {
            return this.addWhiskers;
        }
        return null;
    }

    public Boolean isSetAddWhiskers() {
        return this.addWhiskers != null;
    }

    public void setAddWhiskers(Boolean addWhiskers) {
        this.addWhiskers = addWhiskers;
    }

    public boolean unsetAddWhiskers() {
        if (this.isSetAddWhiskers().booleanValue()) {
            this.addWhiskers = null;
            return true;
        }
        return false;
    }

    public int getLayoutIndex() {
        return this.layoutIndex;
    }

    public void setLayoutIndex(int layoutIndex) {
        if (layoutIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format("{0,number,integer} < 0", layoutIndex));
        }
        SBasePlugin extension = this.model.getExtension(LayoutConstants.getNamespaceURI((int)this.model.getLevel(), (int)this.model.getVersion()));
        if (extension != null && layoutIndex >= ((LayoutModelPlugin)extension).getLayoutCount()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("{0,number,integer} > {1,number,integer}", layoutIndex, ((LayoutModelPlugin)extension).getLayoutCount()));
        }
        this.layoutIndex = layoutIndex;
    }

    private void buildLayout(Layout layout) {
        ListOf textGlyphList;
        this.algorithm.setLayout(layout);
        this.builder.builderStart(layout);
        RenderProcessor.preprocess(layout);
        ListOf compartmentGlyphList = null;
        List<CompartmentGlyph> sortedCompartmentGlyphList = null;
        if (layout.isSetListOfCompartmentGlyphs()) {
            compartmentGlyphList = layout.getListOfCompartmentGlyphs();
            this.createLayoutLinks((ListOf<AbstractReferenceGlyph>)compartmentGlyphList);
            sortedCompartmentGlyphList = this.getSortedCompartmentGlyphList();
        }
        ListOf speciesGlyphList = null;
        if (layout.isSetListOfSpeciesGlyphs()) {
            speciesGlyphList = layout.getListOfSpeciesGlyphs();
            this.createLayoutLinks((ListOf<AbstractReferenceGlyph>)speciesGlyphList);
        }
        ListOf reactionGlyphList = null;
        if (layout.isSetListOfReactionGlyphs()) {
            reactionGlyphList = layout.getListOfReactionGlyphs();
            this.createLayoutLinks((ListOf<AbstractReferenceGlyph>)reactionGlyphList);
        }
        ListOf listOf = textGlyphList = layout.isSetListOfTextGlyphs() ? (textGlyphList = layout.getListOfTextGlyphs()) : null;
        if (compartmentGlyphList != null) {
            for (CompartmentGlyph compartmentGlyph : compartmentGlyphList) {
                if (LayoutDirector.glyphIsLayouted((GraphicalObject)compartmentGlyph)) {
                    this.algorithm.addLayoutedGlyph((GraphicalObject)compartmentGlyph);
                    continue;
                }
                this.algorithm.addUnlayoutedGlyph((GraphicalObject)compartmentGlyph);
            }
        }
        if (speciesGlyphList != null) {
            for (SpeciesGlyph speciesGlyph : speciesGlyphList) {
                if (LayoutDirector.glyphIsLayouted((GraphicalObject)speciesGlyph)) {
                    this.algorithm.addLayoutedGlyph((GraphicalObject)speciesGlyph);
                    continue;
                }
                this.algorithm.addUnlayoutedGlyph((GraphicalObject)speciesGlyph);
            }
        }
        if (textGlyphList != null) {
            for (TextGlyph textGlyph : textGlyphList) {
                if (LayoutDirector.glyphIsLayouted((GraphicalObject)textGlyph)) {
                    this.algorithm.addLayoutedGlyph((GraphicalObject)textGlyph);
                    continue;
                }
                this.algorithm.addUnlayoutedGlyph((GraphicalObject)textGlyph);
            }
        }
        if (reactionGlyphList != null) {
            for (ReactionGlyph reactionGlyph : reactionGlyphList) {
                if (!this.addWhiskers.booleanValue()) {
                    reactionGlyph.putUserObject((Object)NO_WHISKERS, (Object)true);
                }
                if (LayoutDirector.glyphIsLayouted((GraphicalObject)reactionGlyph)) {
                    this.algorithm.addLayoutedGlyph((GraphicalObject)reactionGlyph);
                    if (this.reactionGlyphHasCurves(reactionGlyph)) {
                        reactionGlyph.putUserObject((Object)SPECIAL_ROTATION_NEEDED, (Object)reactionGlyph);
                    }
                } else {
                    this.algorithm.addUnlayoutedGlyph((GraphicalObject)reactionGlyph);
                }
                if (!reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) continue;
                ListOf speciesReferenceGlyphs = reactionGlyph.getListOfSpeciesReferenceGlyphs();
                for (SpeciesReferenceGlyph srg : speciesReferenceGlyphs) {
                    if (LayoutDirector.edgeIsLayouted(reactionGlyph, srg)) {
                        this.algorithm.addLayoutedEdge(srg, reactionGlyph);
                        continue;
                    }
                    this.algorithm.addUnlayoutedEdge(srg, reactionGlyph);
                }
            }
        }
        this.algorithm.completeGlyphs();
        if (sortedCompartmentGlyphList != null) {
            this.handleCompartmentGlyphs(sortedCompartmentGlyphList);
        }
        if (speciesGlyphList != null) {
            this.handleSpeciesGlyphs((ListOf<SpeciesGlyph>)speciesGlyphList);
        }
        if (reactionGlyphList != null) {
            this.handleReactionGlyphs((ListOf<ReactionGlyph>)reactionGlyphList);
        }
        if (textGlyphList != null) {
            this.handleTextGlyphs((ListOf<TextGlyph>)textGlyphList);
        }
        layout.setDimensions(this.algorithm.createLayoutDimension());
        this.builder.builderEnd();
    }

    private boolean reactionGlyphHasCurves(ReactionGlyph reactionGlyph) {
        boolean hasCurves = false;
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            for (SpeciesReferenceGlyph speciesReferenceGlyph : reactionGlyph.getListOfSpeciesReferenceGlyphs()) {
                if (!speciesReferenceGlyph.isSetCurve()) continue;
                hasCurves = true;
                break;
            }
        }
        return hasCurves;
    }

    public static boolean edgeIsLayouted(ReactionGlyph reactionGlyph, SpeciesReferenceGlyph speciesReferenceGlyph) {
        return speciesReferenceGlyph.isSetCurve();
    }

    public static boolean glyphIsLayouted(GraphicalObject glyph) {
        return glyph.isSetBoundingBox() && glyph.getBoundingBox().isSetDimensions() && glyph.getBoundingBox().isSetPosition() && glyph.getBoundingBox().getPosition().isSetX() && glyph.getBoundingBox().getPosition().isSetY() && glyph.getBoundingBox().getDimensions().isSetHeight() && glyph.getBoundingBox().getDimensions().isSetWidth();
    }

    public static boolean glyphHasDimensions(GraphicalObject glyph) {
        return glyph.isSetBoundingBox() && glyph.getBoundingBox().isSetDimensions() && glyph.getBoundingBox().getDimensions().getWidth() != 0.0 && glyph.getBoundingBox().getDimensions().getHeight() != 0.0;
    }

    public static boolean glyphHasPosition(GraphicalObject glyph) {
        return glyph.isSetBoundingBox() && glyph.getBoundingBox().isSetPosition() && !Double.isNaN(glyph.getBoundingBox().getPosition().x()) && !Double.isNaN(glyph.getBoundingBox().getPosition().y());
    }

    public static boolean isSubstrate(SpeciesReferenceGlyph srg) {
        SpeciesReferenceRole role = LayoutDirector.determineRole(srg);
        return role == SpeciesReferenceRole.SUBSTRATE || role == SpeciesReferenceRole.SIDESUBSTRATE;
    }

    public static boolean isModifier(SpeciesReferenceGlyph srg) {
        SpeciesReferenceRole role = LayoutDirector.determineRole(srg);
        return role == SpeciesReferenceRole.ACTIVATOR || role == SpeciesReferenceRole.INHIBITOR || role == SpeciesReferenceRole.MODIFIER;
    }

    public static SpeciesReferenceRole determineRole(SpeciesReferenceGlyph srg) {
        NamedSBase nsb;
        SpeciesReferenceRole role = SpeciesReferenceRole.UNDEFINED;
        if (srg.isSetSpeciesReferenceRole() && srg.getRole() != SpeciesReferenceRole.UNDEFINED) {
            role = srg.getRole();
        } else if (srg.isSetSBOTerm()) {
            role = SpeciesReferenceRole.valueOf((int)srg.getSBOTerm());
        }
        if (role != SpeciesReferenceRole.UNDEFINED) {
            return role;
        }
        if (srg.isSetReference() && (nsb = srg.getReferenceInstance()) != null) {
            if (nsb instanceof SimpleSpeciesReference) {
                SimpleSpeciesReference ssr = (SimpleSpeciesReference)nsb;
                if (ssr.isSetSBOTerm()) {
                    role = SpeciesReferenceRole.valueOf((int)ssr.getSBOTerm());
                }
                if (role != SpeciesReferenceRole.UNDEFINED) {
                    return role;
                }
                if (ssr instanceof ModifierSpeciesReference) {
                    return SpeciesReferenceRole.MODIFIER;
                }
                Reaction r = (Reaction)ssr.getParent();
                if (r != null) {
                    if (r.isSetListOfReactants() && r.getListOfReactants().contains((Object)ssr)) {
                        return SpeciesReferenceRole.SUBSTRATE;
                    }
                    if (r.isSetListOfProducts() && r.getListOfProducts().contains((Object)ssr)) {
                        return SpeciesReferenceRole.PRODUCT;
                    }
                }
            } else {
                logger.warning(MessageFormat.format("Expecting simpleSpeciesReference, but found {0} with id ''{1}'' in {2} with id ''{3}''.", nsb.getElementName(), nsb.getId(), srg.getElementName(), srg.getId()));
            }
        }
        return role;
    }

    public static boolean isProduct(SpeciesReferenceGlyph srg) {
        SpeciesReferenceRole role = LayoutDirector.determineRole(srg);
        return role == SpeciesReferenceRole.PRODUCT || role == SpeciesReferenceRole.SIDEPRODUCT;
    }

    private void handleCompartmentGlyphs(List<CompartmentGlyph> compartmentGlyphList) {
        CompartmentGlyph previousCompartmentGlyph = null;
        for (CompartmentGlyph compartmentGlyph : compartmentGlyphList) {
            List containedCompartments;
            Compartment previousCompartment;
            if (previousCompartmentGlyph != null && previousCompartmentGlyph.isSetReference() && compartmentGlyph.isSetReference() && (previousCompartment = (Compartment)previousCompartmentGlyph.getReferenceInstance()) != null && previousCompartment.getUserObject((Object)COMPARTMENT_LINK) instanceof List && !(containedCompartments = (List)previousCompartment.getUserObject((Object)COMPARTMENT_LINK)).contains(compartmentGlyph.getReferenceInstance())) {
                previousCompartment = null;
            }
            previousCompartmentGlyph = compartmentGlyph;
            this.builder.buildCompartment(compartmentGlyph);
        }
    }

    private void handleSpeciesGlyphs(ListOf<SpeciesGlyph> speciesGlyphList) {
        for (SpeciesGlyph sg : speciesGlyphList) {
            this.handleSpeciesGlyph(sg);
        }
    }

    private void handleSpeciesGlyph(SpeciesGlyph speciesGlyph) {
        boolean cloneMarker = false;
        if (speciesGlyph.isSetReference()) {
            NamedSBase species = speciesGlyph.getReferenceInstance();
            if (!speciesGlyph.isSetSBOTerm()) {
                if (!species.isSetSBOTerm()) {
                    SBMLtools.setSBOTerm((SBase)speciesGlyph, (int)SBO.getUnknownMolecule());
                } else {
                    SBMLtools.setSBOTerm((SBase)speciesGlyph, (int)species.getSBOTerm());
                }
            }
            List glyphList = null;
            if (species.getUserObject((Object)LAYOUT_LINK) instanceof List) {
                glyphList = (List)species.getUserObject((Object)LAYOUT_LINK);
            }
            cloneMarker = glyphList != null && glyphList.size() > 1;
        }
        this.builder.buildEntityPoolNode(speciesGlyph, cloneMarker);
    }

    private void handleReactionGlyphs(ListOf<ReactionGlyph> reactionGlyphList) {
        for (ReactionGlyph rg : reactionGlyphList) {
            this.handleReactionGlyph(rg);
        }
    }

    private void handleReactionGlyph(ReactionGlyph reactionGlyph) {
        double curveWidth = 2.0;
        Object userObject = reactionGlyph.getUserObject((Object)KEY_FOR_FLUX_VALUES);
        if (userObject != null) {
            curveWidth = (Double)userObject;
        }
        double rgRotationAngle = this.algorithm.calculateReactionGlyphRotationAngle(reactionGlyph);
        this.builder.buildProcessNode(reactionGlyph, rgRotationAngle, curveWidth);
        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
            for (SpeciesReferenceGlyph srg : reactionGlyph.getListOfSpeciesReferenceGlyphs()) {
                try {
                    if (!srg.isSetSpeciesReferenceRole() || srg.getSpeciesReferenceRole() == SpeciesReferenceRole.UNDEFINED) {
                        srg.setSpeciesReferenceRole(LayoutDirector.determineRole(srg));
                        logger.warning(MessageFormat.format("Undefined role for species reference  glyph ''{0}'', determined ''{1}''.", srg.getId(), srg.getRole()));
                        if (!srg.isSetSBOTerm()) {
                            logger.warning(MessageFormat.format("No SBO term defined for species reference glyph ''{0}'', synchronizing with its role ''{1}''.", srg.getId(), srg.getSpeciesReferenceRole()));
                            srg.setSBOTerm(srg.getRole().toSBOterm());
                        } else if (!SBO.isChildOf((int)srg.getSBOTerm(), (int)srg.getRole().toSBOterm())) {
                            srg.setSBOTerm(srg.getRole().toSBOterm());
                            logger.warning(MessageFormat.format("Missmatch between SBO term and role of species reference glyph ''{0}''. Applying corresponding value ''{1}'' from role ''{2}''", srg.getId(), srg.getSBOTerm(), srg.getRole()));
                        }
                    }
                    if (srg.getSpeciesReferenceRole() == SpeciesReferenceRole.UNDEFINED) {
                        logger.warning(MessageFormat.format("Undefined participant role for species reference glyph ''{0}'' in reaction glyph ''{1}'', assuming consumption.", srg.getId(), reactionGlyph.getId()));
                        srg.setSBOTerm(SBO.getConsumption());
                    }
                    this.builder.buildConnectingArc(srg, reactionGlyph, curveWidth);
                }
                catch (ClassCastException exc) {
                    logger.fine("tried to access object with id = " + srg.getReference());
                    throw exc;
                }
            }
        }
    }

    private void handleTextGlyphs(ListOf<TextGlyph> textGlyphList) {
        for (TextGlyph textGlyph : textGlyphList) {
            this.handleTextGlyph(textGlyph);
        }
    }

    private void handleTextGlyph(TextGlyph textGlyph) {
        this.builder.buildTextGlyph(textGlyph);
    }

    public static boolean textGlyphIsIndependent(TextGlyph textGlyph) {
        return textGlyph.isSetText() && !textGlyph.isSetGraphicalObject() && !textGlyph.isSetOriginOfText();
    }

    private void createLayoutLinks(ListOf<? extends AbstractReferenceGlyph> listOfAbstractReferenceGlyphs) {
        for (AbstractReferenceGlyph glyph : listOfAbstractReferenceGlyphs) {
            if (!glyph.isSetReference()) continue;
            NamedSBase correspondingSBase = glyph.getReferenceInstance();
            if (correspondingSBase == null) {
                logger.warning(MessageFormat.format("Removing incorrect link from glyph {0} to an non existing element {1}", glyph, glyph.getReference()));
                glyph.unsetReference();
                continue;
            }
            List<AbstractReferenceGlyph> listOfGlyphs = null;
            if (correspondingSBase.getUserObject((Object)LAYOUT_LINK) instanceof List) {
                listOfGlyphs = (List)correspondingSBase.getUserObject((Object)LAYOUT_LINK);
            } else {
                listOfGlyphs = new ArrayList();
                correspondingSBase.putUserObject((Object)LAYOUT_LINK, listOfGlyphs);
            }
            listOfGlyphs.add(glyph);
        }
    }

    @Override
    public void run() {
        SBasePlugin extension = this.model.getExtension(LayoutConstants.getNamespaceURI((int)this.model.getLevel(), (int)this.model.getVersion()));
        if (extension != null) {
            LayoutModelPlugin layoutModel = (LayoutModelPlugin)extension;
            if (layoutModel.getLayoutCount() > this.layoutIndex) {
                if (this.mapOfFluxes != null) {
                    for (String reactionId : this.mapOfFluxes.keySet()) {
                        ReactionGlyph reactionGlyph = layoutModel.getLayout(this.layoutIndex).getReactionGlyph(reactionId);
                        if (reactionGlyph != null) {
                            reactionGlyph.putUserObject((Object)KEY_FOR_FLUX_VALUES, (Object)this.mapOfFluxes.get(reactionId));
                            continue;
                        }
                        throw new IllegalArgumentException(MessageFormat.format("{0} is no legal ReactionGlyph ID for this model.", reactionId));
                    }
                }
                this.buildLayout(layoutModel.getLayout(this.layoutIndex));
            }
        } else {
            logger.info("Method LayoutDirector.run failed: No model extension available for this model.");
        }
    }

    public void setBuilder(LayoutBuilder<P> builder) {
        this.builder = builder;
    }

    public LayoutBuilder<P> getBuilder() {
        return this.builder;
    }

    public void setAlgorithm(LayoutAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public LayoutAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public P getProduct() {
        if (this.builder.isProductReady()) {
            return this.builder.getProduct();
        }
        return null;
    }

    private List<CompartmentGlyph> getSortedCompartmentGlyphList() {
        this.createCompartmentLinks();
        ArrayList<CompartmentGlyph> sortedGlyphList = new ArrayList<CompartmentGlyph>();
        if (this.model.isSetListOfCompartments()) {
            for (Compartment compartment : this.model.getListOfCompartments()) {
                List compartmentGlyphList = compartment.getUserObject((Object)LAYOUT_LINK) instanceof List ? (List)compartment.getUserObject((Object)LAYOUT_LINK) : new ArrayList();
                if (compartment.isSetOutside()) continue;
                sortedGlyphList.addAll(compartmentGlyphList);
                List<CompartmentGlyph> containedList = this.getContainedCompartmentGlyphs(compartment);
                containedList.removeAll(compartmentGlyphList);
                sortedGlyphList.addAll(containedList);
            }
        } else {
            sortedGlyphList.addAll((Collection<CompartmentGlyph>)((LayoutModelPlugin)this.model.getPlugin("layout")).getLayout(this.layoutIndex).getListOfCompartmentGlyphs());
        }
        return sortedGlyphList;
    }

    private List<CompartmentGlyph> getContainedCompartmentGlyphs(Compartment compartment) {
        LinkedList<CompartmentGlyph> containedList = new LinkedList<CompartmentGlyph>();
        Object userObject = compartment.getUserObject((Object)LAYOUT_LINK);
        if (userObject instanceof List) {
            List directlyContainedCompartmentGlyphs = (List)userObject;
            containedList.addAll(directlyContainedCompartmentGlyphs);
            for (CompartmentGlyph containedCompartmentGlyph : directlyContainedCompartmentGlyphs) {
                Compartment comp = (Compartment)containedCompartmentGlyph.getReferenceInstance();
                if (comp == compartment) continue;
                containedList.addAll(this.getContainedCompartmentGlyphs(comp));
            }
        }
        return containedList;
    }

    private void createCompartmentLinks() {
        if (this.model.isSetListOfCompartments()) {
            ListOf compartmentList = this.model.getListOfCompartments();
            for (Compartment compartment : compartmentList) {
                if (!compartment.isSetOutsideInstance()) continue;
                Compartment outside = compartment.getOutsideInstance();
                LinkedList userObject = new LinkedList();
                if (outside.getUserObject((Object)COMPARTMENT_LINK) instanceof LinkedList) {
                    userObject = (LinkedList)outside.getUserObject((Object)COMPARTMENT_LINK);
                }
                userObject.add(compartment);
                outside.putUserObject((Object)COMPARTMENT_LINK, (Object)userObject);
            }
        }
    }

    public String toString() {
        return StringTools.concat((Object[])new Object[]{this.getClass().getSimpleName(), " [algorithm=", this.algorithm, ", builder=", this.builder, ", model=", this.model, ", layoutIndex=", this.layoutIndex, ", mapOfFluxes=", this.mapOfFluxes, ", addWhiskers=", this.addWhiskers, "]"}).toString();
    }
}

