/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render.director;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.ext.render.ListOfLocalRenderInformation;
import org.sbml.jsbml.ext.render.LocalRenderInformation;
import org.sbml.jsbml.ext.render.LocalStyle;
import org.sbml.jsbml.ext.render.RenderGraphicalObjectPlugin;
import org.sbml.jsbml.ext.render.RenderGroup;
import org.sbml.jsbml.ext.render.RenderLayoutPlugin;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class RenderProcessor {
    public static final String RENDER_LINK = "RENDER_LINK";
    private static final Logger logger = Logger.getLogger(RenderProcessor.class.getName());

    public static void preprocess(Layout layout) {
        Model model = layout.getModel();
        RenderLayoutPlugin rlp = (RenderLayoutPlugin)layout.getExtension("render");
        if (rlp != null && rlp.isSetListOfLocalRenderInformation()) {
            ListOfLocalRenderInformation listOfLocalRenderInformation = rlp.getListOfLocalRenderInformation();
            Iterator iterator = listOfLocalRenderInformation.iterator();
            while (iterator.hasNext()) {
                LocalRenderInformation lri = (LocalRenderInformation)((Object)iterator.next());
                if (!lri.isSetListOfLocalStyles() || !lri.isSetListOfColorDefinitions()) continue;
                HashMap<String, LocalStyle> roles = new HashMap<String, LocalStyle>();
                for (LocalStyle ls : lri.getListOfLocalStyles()) {
                    for (String id : ls.getIDList()) {
                        SBase sbase = model.getSBaseById(id);
                        if (sbase == null) continue;
                        if (sbase.getUserObject((Object)RENDER_LINK) == null) {
                            sbase.putUserObject((Object)RENDER_LINK, new LinkedList());
                        }
                        ((List)sbase.getUserObject((Object)RENDER_LINK)).add(ls);
                    }
                    for (String role : ls.getRoleList()) {
                        if (roles.containsKey(role) && roles.get(role) != ls) {
                            logger.warning(MessageFormat.format("Role clash between style ''{0}'' and style ''{1}''.", ((LocalStyle)((Object)roles.get(role))).getId(), ls.getId()));
                            continue;
                        }
                        roles.put(role, ls);
                    }
                }
                if (roles.isEmpty()) continue;
                for (GraphicalObject go : layout.getListOfAdditionalGraphicalObjects()) {
                    RenderProcessor.linkObjectRoleToStyle(roles, go);
                }
                for (CompartmentGlyph cg : layout.getListOfCompartmentGlyphs()) {
                    RenderProcessor.linkObjectRoleToStyle(roles, (GraphicalObject)cg);
                }
                for (ReactionGlyph rg : layout.getListOfReactionGlyphs()) {
                    RenderProcessor.linkObjectRoleToStyle(roles, (GraphicalObject)rg);
                }
                for (SpeciesGlyph sg : layout.getListOfSpeciesGlyphs()) {
                    RenderProcessor.linkObjectRoleToStyle(roles, (GraphicalObject)sg);
                }
                for (TextGlyph tg : layout.getListOfTextGlyphs()) {
                    RenderProcessor.linkObjectRoleToStyle(roles, (GraphicalObject)tg);
                }
            }
        }
    }

    public static void linkObjectRoleToStyle(Map<String, LocalStyle> roles, GraphicalObject go) {
        LocalStyle ls;
        RenderGraphicalObjectPlugin rgop = (RenderGraphicalObjectPlugin)go.getExtension("render");
        if (rgop != null && rgop.isSetObjectRole() && (ls = roles.get(rgop.getObjectRole())) != null) {
            if (go.getUserObject((Object)RENDER_LINK) == null) {
                go.putUserObject((Object)RENDER_LINK, new LinkedList());
            }
            ((List)go.getUserObject((Object)RENDER_LINK)).add(ls);
        }
    }

    public static Color getRenderFillColor(SpeciesGlyph sg) {
        List styles = (List)sg.getUserObject((Object)RENDER_LINK);
        if (styles != null) {
            for (int i = styles.size() - 1; i >= 0; --i) {
                ColorDefinition cd;
                LocalStyle ls = (LocalStyle)((Object)styles.get(i));
                RenderGroup rg = ls.getGroup();
                if (rg == null || !rg.isSetFill()) continue;
                if (!ls.isSetParent()) {
                    styles.remove(i);
                    continue;
                }
                LocalRenderInformation lri = (LocalRenderInformation)((Object)ls.getParent().getParent());
                if (!lri.isSetListOfColorDefinitions() || (cd = (ColorDefinition)lri.getListOfColorDefinitions().firstHit((Filter)new NameFilter(rg.getFill()))) == null) continue;
                return cd.getValue();
            }
        }
        return null;
    }
}

