/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ColorDefinitionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320501, 1320505);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1320502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1320503: {
                func = new ValidationFunction<ColorDefinition>(){

                    public boolean check(ValidationContext ctx, ColorDefinition t) {
                        return t.isSetId() && t.isSetValue() && new UnknownPackageAttributeValidationFunction("render").check(ctx, (TreeNodeWithChangeSupport)t);
                    }
                };
                break;
            }
            case 1320504: 
            case 1320505: {
                func = new ValidationFunction<ColorDefinition>(){

                    public boolean check(ValidationContext ctx, ColorDefinition t) {
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

