/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.DefaultValues;
import org.sbml.jsbml.ext.render.GradientBase;
import org.sbml.jsbml.ext.render.GraphicalPrimitive2D;
import org.sbml.jsbml.ext.render.HTextAnchor;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.RelAbsVector;
import org.sbml.jsbml.ext.render.VTextAnchor;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class DefaultValuesConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1323001, 1323032);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1323001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1323002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1323003: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1323004: 
            case 1323006: 
            case 1323008: 
            case 1323010: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        return true;
                    }
                };
                break;
            }
            case 1323005: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("spreadMethod");
                        if (value != null) {
                            try {
                                GradientBase.Spread.valueOf(value.toUpperCase());
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323007: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("fill-rule");
                        if (value != null) {
                            try {
                                GraphicalPrimitive2D.FillRule.valueOf(value.toUpperCase());
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323009: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("stroke-width");
                        if (value != null) {
                            try {
                                Double.parseDouble(value.trim());
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323011: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("font-weight");
                        if (value != null) {
                            return (value = value.toLowerCase()).equals("normal") || value.equals("bold");
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323012: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("font-style");
                        if (value != null) {
                            return (value = value.toLowerCase()).equals("normal") || value.equals("italic");
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323013: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("text-anchor");
                        if (value != null) {
                            try {
                                HTextAnchor.valueOf(value.toUpperCase());
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323014: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("vtext-anchor");
                        if (value != null) {
                            try {
                                VTextAnchor.valueOf(value.toUpperCase());
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323015: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("startHead");
                        if (value != null) {
                            SBase referenced = t.getModel().getSBaseById(value);
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323016: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("endHead");
                        if (value != null) {
                            SBase referenced = t.getModel().getSBaseById(value);
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323017: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("enableRotationalMapping");
                        if (value != null) {
                            try {
                                Boolean.parseBoolean(value);
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323018: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_x1");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323019: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_y1");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323020: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_z1");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323021: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_x2");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323022: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_y2");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323023: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("linearGradient_z2");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323024: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_cx");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323025: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_cy");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323026: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_cz");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323027: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_r");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323028: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_fx");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323029: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_fy");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323030: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("radialGradient_fz");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323031: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("default_z");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323032: {
                func = new ValidationFunction<DefaultValues>(){

                    public boolean check(ValidationContext ctx, DefaultValues t) {
                        String value = t.getDefaultValue("font-size");
                        if (value != null) {
                            RelAbsVector vec = new RelAbsVector(value);
                            return vec.isSetAbsoluteValue() || vec.isSetRelativeValue();
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

