/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.render.GlobalRenderInformation;
import org.sbml.jsbml.ext.render.LocalStyle;
import org.sbml.jsbml.ext.render.Style;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class GlobalRenderInformationConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320701, 1320706);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1320702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1320703: {
                func = new UnknownPackageElementValidationFunction<GlobalRenderInformation>("render"){

                    public boolean check(ValidationContext ctx, GlobalRenderInformation t) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)t) && new DuplicatedElementValidationFunction("listOfStyles").check(ctx, (TreeNodeWithChangeSupport)t);
                    }
                };
                break;
            }
            case 1320704: {
                func = new ValidationFunction<GlobalRenderInformation>(){

                    public boolean check(ValidationContext ctx, GlobalRenderInformation t) {
                        return !t.isListOfStylesEmpty();
                    }
                };
                break;
            }
            case 1320705: {
                func = new ValidationFunction<GlobalRenderInformation>(){

                    public boolean check(ValidationContext ctx, GlobalRenderInformation t) {
                        if (t.isSetListOfStyles()) {
                            ListOf<Style> styles = t.getListOfStyles();
                            boolean coreElementsOk = new UnknownCoreElementValidationFunction().check(ctx, styles);
                            boolean allStylesGlobal = true;
                            for (Style style : styles) {
                                allStylesGlobal &= !(style instanceof LocalStyle);
                            }
                            return coreElementsOk && allStylesGlobal;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320706: {
                func = new ValidationFunction<GlobalRenderInformation>(){

                    public boolean check(ValidationContext ctx, GlobalRenderInformation t) {
                        if (t.isSetListOfStyles()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfStyles());
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

