/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.GradientBase;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class GradientBaseConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320901, 1320906);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1320902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1320903: {
                func = new UnknownPackageAttributeValidationFunction<GradientBase>("render"){

                    public boolean check(ValidationContext ctx, GradientBase base) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)base) && base.isSetId();
                    }
                };
                break;
            }
            case 1320904: {
                func = new UnknownPackageElementValidationFunction<GradientBase>("render"){

                    public boolean check(ValidationContext ctx, GradientBase base) {
                        return base.isSetListOfGradientStops() && super.check(ctx, (TreeNodeWithChangeSupport)base);
                    }
                };
                break;
            }
            case 1320905: {
                func = new ValidationFunction<GradientBase>(){

                    public boolean check(ValidationContext ctx, GradientBase t) {
                        return true;
                    }
                };
                break;
            }
            case 1320906: {
                func = new InvalidAttributeValidationFunction("spreadMethod");
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

