/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.GradientStop;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class GradientStopConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321001, 1321005);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321003: {
                func = new UnknownPackageAttributeValidationFunction<GradientStop>("render"){

                    public boolean check(ValidationContext ctx, GradientStop stop) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)stop) && stop.isSetStopColor() && stop.isSetOffset();
                    }
                };
                break;
            }
            case 1321004: {
                func = new ValidationFunction<GradientStop>(){

                    public boolean check(ValidationContext ctx, GradientStop t) {
                        return true;
                    }
                };
                break;
            }
            case 1321005: {
                func = new ValidationFunction<GradientStop>(){

                    public boolean check(ValidationContext ctx, GradientStop stop) {
                        return stop.isSetOffset() && !stop.getOffset().isSetAbsoluteValue() && stop.getOffset().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

