/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class GraphicalPrimitive1DConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322601, 1322606);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322603: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1322604: {
                func = new ValidationFunction<GraphicalPrimitive1D>(){

                    public boolean check(ValidationContext ctx, GraphicalPrimitive1D t) {
                        return true;
                    }
                };
                break;
            }
            case 1322605: {
                func = new InvalidAttributeValidationFunction("stroke-width");
                break;
            }
            case 1322606: {
                func = new InvalidAttributeValidationFunction("stroke-dasharray");
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

