/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.io.File;
import java.util.Set;
import org.sbml.jsbml.ext.render.Image;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ImageConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321201, 1321210);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321201: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321202: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321203: {
                func = new UnknownPackageAttributeValidationFunction<Image>("render"){

                    public boolean check(ValidationContext ctx, Image image) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)image) && image.isSetHref() && image.isSetX() && image.isSetY() && image.isSetWidth() && image.isSetHeight();
                    }
                };
                break;
            }
            case 1321204: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return image.isSetHref();
                    }
                };
                break;
            }
            case 1321205: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return image.isSetX() && (image.getX().isSetAbsoluteValue() || image.getX().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321206: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return image.isSetY() && (image.getY().isSetAbsoluteValue() || image.getY().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321207: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return image.isSetWidth() && (image.getWidth().isSetAbsoluteValue() || image.getWidth().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321208: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return image.isSetHeight() && (image.getHeight().isSetAbsoluteValue() || image.getHeight().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1321209: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        if (image.isSetHref()) {
                            File file = new File(image.getHref());
                            return !file.isDirectory() && (image.getHref().toLowerCase().endsWith(".png") || image.getHref().toLowerCase().endsWith(".jpeg") || image.getHref().toLowerCase().endsWith(".jpg"));
                        }
                        return false;
                    }
                };
                break;
            }
            case 1321210: {
                func = new ValidationFunction<Image>(){

                    public boolean check(ValidationContext ctx, Image image) {
                        return !image.isSetZ() || image.getZ().isSetAbsoluteValue() || image.getZ().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

