/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.LocalRenderInformation;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class LocalRenderInformationConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321501, 1321506);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321503: {
                func = new UnknownPackageElementValidationFunction<LocalRenderInformation>("render"){

                    public boolean check(ValidationContext ctx, LocalRenderInformation lri) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)lri) && new DuplicatedElementValidationFunction("listOfStyles").check(ctx, (TreeNodeWithChangeSupport)lri);
                    }
                };
                break;
            }
            case 1321504: {
                func = new ValidationFunction<LocalRenderInformation>(){

                    public boolean check(ValidationContext ctx, LocalRenderInformation lri) {
                        return !lri.isListOfLocalStylesEmpty();
                    }
                };
                break;
            }
            case 1321505: {
                func = new ValidationFunction<LocalRenderInformation>(){

                    public boolean check(ValidationContext ctx, LocalRenderInformation lri) {
                        if (lri.isSetListOfLocalStyles()) {
                            return new UnknownCoreElementValidationFunction().check(ctx, lri.getListOfLocalStyles()) && new UnknownPackageElementValidationFunction("render").check(ctx, lri.getListOfLocalStyles());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1321506: {
                func = new ValidationFunction<LocalRenderInformation>(){

                    public boolean check(ValidationContext ctx, LocalRenderInformation lri) {
                        if (lri.isSetListOfLocalStyles()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, lri.getListOfLocalStyles());
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

