/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.render.Polygon;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class PolygonConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321701, 1321704);
                this.addRangeToSet(set, 1323040, 1323043);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321703: {
                func = new UnknownPackageElementValidationFunction<Polygon>("render"){

                    public boolean check(ValidationContext ctx, Polygon poly) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)poly) && new DuplicatedElementValidationFunction("listOfElements").check(ctx, (TreeNodeWithChangeSupport)poly);
                    }
                };
                break;
            }
            case 1321704: {
                func = new UnknownPackageElementValidationFunction<Polygon>("layout"){

                    public boolean check(ValidationContext ctx, Polygon poly) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)poly) && new DuplicatedElementValidationFunction("listOfCurveSegments").check(ctx, (TreeNodeWithChangeSupport)poly);
                    }
                };
                break;
            }
            case 1323040: {
                func = new ValidationFunction<Polygon>(){

                    public boolean check(ValidationContext ctx, Polygon t) {
                        return !t.isListOfElementsEmpty();
                    }
                };
                break;
            }
            case 1323041: {
                func = new ValidationFunction<Polygon>(){

                    public boolean check(ValidationContext ctx, Polygon t) {
                        if (t.isSetListOfElements()) {
                            return new UnknownCoreElementValidationFunction().check(ctx, t.getListOfElements()) && new UnknownPackageElementValidationFunction("render").check(ctx, t.getListOfElements());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323042: {
                func = new ValidationFunction<Polygon>(){

                    public boolean check(ValidationContext ctx, Polygon t) {
                        if (t.isSetListOfElements()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfElements());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323043: {
                func = new ValidationFunction<Polygon>(){

                    public boolean check(ValidationContext ctx, Polygon t) {
                        if (t.isSetListOfElements()) {
                            ListOf<RenderPoint> list = t.getListOfElements();
                            return !list.isEmpty() && list.get(0) instanceof RenderPoint && !(list.get(0) instanceof RenderCubicBezier);
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

