/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.RadialGradient;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class RadialGradientConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1321801, 1321810);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1321801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1321802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1321803: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1321804: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetCx() || gradient.getCx().isSetAbsoluteValue() || gradient.getCx().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321805: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetCy() || gradient.getCy().isSetAbsoluteValue() || gradient.getCy().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321806: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetCz() || gradient.getCz().isSetAbsoluteValue() || gradient.getCz().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321807: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetR() || gradient.getR().isSetAbsoluteValue() || gradient.getR().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321808: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetFx() || gradient.getFx().isSetAbsoluteValue() || gradient.getFx().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321809: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetFy() || gradient.getFy().isSetAbsoluteValue() || gradient.getFy().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1321810: {
                func = new ValidationFunction<RadialGradient>(){

                    public boolean check(ValidationContext ctx, RadialGradient gradient) {
                        return !gradient.isSetFz() || gradient.getFz().isSetAbsoluteValue() || gradient.getFz().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

