/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class RenderCubicBezierConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322001, 1322009);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322001: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322002: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322003: {
                func = new UnknownPackageAttributeValidationFunction<RenderCubicBezier>("render"){

                    public boolean check(ValidationContext ctx, RenderCubicBezier rcb) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)rcb) && rcb.isSetX1() && rcb.isSetY1() && rcb.isSetX2() && rcb.isSetY2();
                    }
                };
                break;
            }
            case 1322004: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetX1() && (r.getX1().isSetAbsoluteValue() || r.getX1().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322005: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetY1() && (r.getY1().isSetAbsoluteValue() || r.getY1().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322006: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetX2() && (r.getX2().isSetAbsoluteValue() || r.getX2().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322007: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetY2() && (r.getY2().isSetAbsoluteValue() || r.getY2().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322008: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetZ1() && (r.getZ1().isSetAbsoluteValue() || r.getZ1().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322009: {
                func = new ValidationFunction<RenderCubicBezier>(){

                    public boolean check(ValidationContext ctx, RenderCubicBezier r) {
                        return r.isSetZ2() && (r.getZ2().isSetAbsoluteValue() || r.getZ2().isSetRelativeValue());
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

