/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.LineEnding;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.ext.render.RenderCurve;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class RenderCurveConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322101, 1322106);
                this.addRangeToSet(set, 1323040, 1323043);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322101: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322102: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322103: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1322104: {
                func = new UnknownPackageElementValidationFunction<RenderCurve>("render"){

                    public boolean check(ValidationContext ctx, RenderCurve rc) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)rc) && new DuplicatedElementValidationFunction("listOfElements").check(ctx, (TreeNodeWithChangeSupport)rc);
                    }
                };
                break;
            }
            case 1322105: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve rc) {
                        if (rc.isSetStartHead()) {
                            SBase referenced = rc.getModel().getSBaseById(rc.getStartHead());
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322106: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve rc) {
                        if (rc.isSetEndHead()) {
                            SBase referenced = rc.getModel().getSBaseById(rc.getEndHead());
                            return referenced != null && referenced instanceof LineEnding;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323040: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve t) {
                        return !t.isListOfElementsEmpty();
                    }
                };
                break;
            }
            case 1323041: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve t) {
                        if (t.isSetListOfElements()) {
                            return new UnknownCoreElementValidationFunction().check(ctx, t.getListOfElements()) && new UnknownPackageElementValidationFunction("render").check(ctx, t.getListOfElements());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323042: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve t) {
                        if (t.isSetListOfElements()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfElements());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1323043: {
                func = new ValidationFunction<RenderCurve>(){

                    public boolean check(ValidationContext ctx, RenderCurve t) {
                        if (t.isSetListOfElements()) {
                            ListOf<RenderPoint> list = t.getListOfElements();
                            return !list.isEmpty() && list.get(0) instanceof RenderPoint && !(list.get(0) instanceof RenderCubicBezier);
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

