/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class RenderInformationBaseConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322901, 1322916);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322903: {
                func = new UnknownPackageAttributeValidationFunction<RenderInformationBase>("render"){

                    public boolean check(ValidationContext ctx, RenderInformationBase rib) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)rib) && rib.isSetId();
                    }
                };
                break;
            }
            case 1322904: {
                func = new UnknownPackageElementValidationFunction<RenderInformationBase>("render"){

                    public boolean check(ValidationContext ctx, RenderInformationBase rib) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)rib) && new DuplicatedElementValidationFunction("listOfColorDefinitions").check(ctx, (TreeNodeWithChangeSupport)rib) && new DuplicatedElementValidationFunction("listOfGradientDefinitions").check(ctx, (TreeNodeWithChangeSupport)rib) && new DuplicatedElementValidationFunction("listOfLineEndings").check(ctx, (TreeNodeWithChangeSupport)rib);
                    }
                };
                break;
            }
            case 1322905: 
            case 1322906: 
            case 1322907: 
            case 1322909: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        return true;
                    }
                };
                break;
            }
            case 1322908: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase rib) {
                        if (rib.isSetReferenceRenderInformation()) {
                            SBase referenced = rib.getModel().getSBaseById(rib.getReferenceRenderInformation());
                            return referenced != null && referenced instanceof RenderInformationBase;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322910: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        return !t.isListOfColorDefinitionsEmpty() && !t.isListOfGradientDefinitionsEmpty() && !t.isListOfLineEndingsEmpty();
                    }
                };
                break;
            }
            case 1322911: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfColorDefinitions()) {
                            return new UnknownPackageElementValidationFunction("render").check(ctx, t.getListOfColorDefinitions()) && new UnknownCoreElementValidationFunction().check(ctx, t.getListOfColorDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322912: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfGradientDefinitions()) {
                            return new UnknownPackageElementValidationFunction("render").check(ctx, t.getListOfGradientDefinitions()) && new UnknownCoreElementValidationFunction().check(ctx, t.getListOfGradientDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322913: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfLineEndings()) {
                            return new UnknownPackageElementValidationFunction("render").check(ctx, t.getListOfLineEndings()) && new UnknownCoreElementValidationFunction().check(ctx, t.getListOfLineEndings());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322914: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfColorDefinitions()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfColorDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322915: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfGradientDefinitions()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfGradientDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1322916: {
                func = new ValidationFunction<RenderInformationBase>(){

                    public boolean check(ValidationContext ctx, RenderInformationBase t) {
                        if (t.isSetListOfLineEndings()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, t.getListOfLineEndings());
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

