/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.ext.render.ListOfGlobalRenderInformation;
import org.sbml.jsbml.ext.render.RenderListOfLayoutsPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class RenderListOfLayoutsPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320101, 1320103);
                this.addRangeToSet(set, 1320401, 1320407);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320101: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String required = (String)doc.getSBMLDocumentAttributes().get("render:required");
                        return required != null;
                    }
                };
                break;
            }
            case 1320102: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String required = (String)doc.getSBMLDocumentAttributes().get("render:required");
                        try {
                            StringTools.parseSBMLBooleanStrict((String)required);
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320103: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String requiredStr = (String)doc.getSBMLDocumentAttributes().get("render:required");
                        try {
                            boolean required = StringTools.parseSBMLBooleanStrict((String)requiredStr);
                            return !required;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return true;
                        }
                    }
                };
                break;
            }
            case 1320401: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        ListOf extendedList = (ListOf)rlp.getExtendedSBase();
                        return new DuplicatedElementValidationFunction("render:listOfGlobalRenderInformation").check(ctx, (TreeNodeWithChangeSupport)extendedList) && new UnknownPackageElementValidationFunction("render").check(ctx, (TreeNodeWithChangeSupport)extendedList);
                    }
                };
                break;
            }
            case 1320402: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin t) {
                        return !t.isListOfGlobalRenderInformationEmpty();
                    }
                };
                break;
            }
            case 1320403: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        if (rlp.isSetListOfGlobalRenderInformation()) {
                            return new UnknownElementValidationFunction().check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfGlobalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320404: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        if (rlp.isSetListOfGlobalRenderInformation()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfGlobalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320405: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        if (rlp.isSetListOfGlobalRenderInformation()) {
                            return new UnknownPackageAttributeValidationFunction("render").check(ctx, (TreeNodeWithChangeSupport)rlp.getListOfGlobalRenderInformation());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320406: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        if (rlp.isSetListOfGlobalRenderInformation()) {
                            ListOfGlobalRenderInformation gris = rlp.getListOfGlobalRenderInformation();
                            if (gris.isSetVersionMajor()) {
                                return gris.getVersionMajor() >= 0;
                            }
                            return new InvalidAttributeValidationFunction("versionMajor").check(ctx, (TreeNodeWithChangeSupport)gris);
                        }
                        return true;
                    }
                };
                break;
            }
            case 1320407: {
                func = new ValidationFunction<RenderListOfLayoutsPlugin>(){

                    public boolean check(ValidationContext ctx, RenderListOfLayoutsPlugin rlp) {
                        if (rlp.isSetListOfGlobalRenderInformation()) {
                            ListOfGlobalRenderInformation gris = rlp.getListOfGlobalRenderInformation();
                            if (gris.isSetVersionMinor()) {
                                return gris.getVersionMinor() >= 0;
                            }
                            return new InvalidAttributeValidationFunction("versionMinor").check(ctx, (TreeNodeWithChangeSupport)gris);
                        }
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

