/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.RenderPoint;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class RenderPointConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322201, 1322206);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322201: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322202: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322203: {
                func = new UnknownPackageAttributeValidationFunction<RenderPoint>("render"){

                    public boolean check(ValidationContext ctx, RenderPoint p) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)p) && p.isSetX() && p.isSetY();
                    }
                };
                break;
            }
            case 1322204: {
                func = new ValidationFunction<RenderPoint>(){

                    public boolean check(ValidationContext ctx, RenderPoint r) {
                        return r.isSetX() && (r.getX().isSetAbsoluteValue() || r.getX().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322205: {
                func = new ValidationFunction<RenderPoint>(){

                    public boolean check(ValidationContext ctx, RenderPoint r) {
                        return r.isSetY() && (r.getY().isSetAbsoluteValue() || r.getY().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322206: {
                func = new ValidationFunction<RenderPoint>(){

                    public boolean check(ValidationContext ctx, RenderPoint r) {
                        return !r.isSetZ() || r.getZ().isSetAbsoluteValue() || r.getZ().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

