/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.Style;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class StyleConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1320801, 1320802);
                this.addRangeToSet(set, 1322801, 1322807);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1320801: 
            case 1322801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1320802: 
            case 1322802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322803: {
                func = new UnknownPackageAttributeValidationFunction("render");
                break;
            }
            case 1322804: {
                func = new UnknownPackageElementValidationFunction<Style>("render"){

                    public boolean check(ValidationContext ctx, Style style) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)style) && new DuplicatedElementValidationFunction("g").check(ctx, (TreeNodeWithChangeSupport)style);
                    }
                };
                break;
            }
            case 1322805: 
            case 1322806: 
            case 1322807: {
                func = new ValidationFunction<Style>(){

                    public boolean check(ValidationContext ctx, Style t) {
                        return true;
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

