/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.render.Text;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class TextConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1322301, 1322312);
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func;
        switch (errorCode) {
            case 1322301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1322302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1322303: {
                func = new UnknownPackageAttributeValidationFunction<Text>("render"){

                    public boolean check(ValidationContext ctx, Text t) {
                        return super.check(ctx, (TreeNodeWithChangeSupport)t) && t.isSetX() && t.isSetY();
                    }
                };
                break;
            }
            case 1322304: {
                func = new ValidationFunction<Text>(){

                    public boolean check(ValidationContext ctx, Text t) {
                        return t.isSetX() && (t.getX().isSetAbsoluteValue() || t.getX().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322305: {
                func = new ValidationFunction<Text>(){

                    public boolean check(ValidationContext ctx, Text t) {
                        return t.isSetY() && (t.getY().isSetAbsoluteValue() || t.getY().isSetRelativeValue());
                    }
                };
                break;
            }
            case 1322306: {
                func = new ValidationFunction<Text>(){

                    public boolean check(ValidationContext ctx, Text t) {
                        return true;
                    }
                };
                break;
            }
            case 1322307: {
                func = new InvalidAttributeValidationFunction("font-weight");
                break;
            }
            case 1322308: {
                func = new InvalidAttributeValidationFunction("font-style");
                break;
            }
            case 1322309: {
                func = new InvalidAttributeValidationFunction("text-anchor");
                break;
            }
            case 1322310: {
                func = new InvalidAttributeValidationFunction("vtext-anchor");
                break;
            }
            case 1322311: {
                func = new ValidationFunction<Text>(){

                    public boolean check(ValidationContext ctx, Text t) {
                        return !t.isSetZ() || t.getZ().isSetAbsoluteValue() || t.getZ().isSetRelativeValue();
                    }
                };
                break;
            }
            case 1322312: {
                func = new ValidationFunction<Text>(){

                    public boolean check(ValidationContext ctx, Text t) {
                        return !t.isSetFontSize() || t.getFontSize().isSetAbsoluteValue() || t.getZ().isSetRelativeValue();
                    }
                };
                break;
            }
            default: {
                func = null;
            }
        }
        return func;
    }
}

