/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.render.GradientStop;
import org.sbml.jsbml.ext.render.RelAbsVector;

public class GradientBase
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -3921074024567604440L;
    protected Spread spreadMethod;
    protected ListOf<GradientStop> listOfGradientStops;

    public GradientBase() {
        this.initDefaults();
    }

    public GradientBase(String id, GradientStop stop) {
        super(id);
        this.initDefaults();
        this.listOfGradientStops.add((SBase)stop);
    }

    public GradientBase(String id, GradientStop stop, int level, int version) {
        super(id, null, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
        this.listOfGradientStops.add((SBase)stop);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfGradientStops()) {
            count += this.getListOfGradientStops().size();
        }
        return count;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfGradientStops()) {
            return this.getListOfGradientStops().get(index);
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public GradientBase(GradientBase obj) {
        super((AbstractNamedSBase)obj);
        this.spreadMethod = obj.spreadMethod;
        if (obj.isSetListOfGradientStops()) {
            this.setListOfGradientStops((ListOf<GradientStop>)obj.listOfGradientStops.clone());
        }
    }

    public GradientBase clone() {
        return new GradientBase(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.spreadMethod = Spread.PAD;
        this.listOfGradientStops = new ListOf();
    }

    public int hashCode() {
        int prime = 3187;
        int result = super.hashCode();
        result = 3187 * result + (this.listOfGradientStops == null ? 0 : this.listOfGradientStops.hashCode());
        result = 3187 * result + (this.spreadMethod == null ? 0 : this.spreadMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GradientBase other = (GradientBase)((Object)obj);
        if (this.listOfGradientStops == null ? other.listOfGradientStops != null : !this.listOfGradientStops.equals(other.listOfGradientStops)) {
            return false;
        }
        return this.spreadMethod == other.spreadMethod;
    }

    public Spread getSpreadMethod() {
        if (this.isSetSpreadMethod()) {
            return this.spreadMethod;
        }
        return null;
    }

    public boolean isSetSpreadMethod() {
        return this.spreadMethod != null;
    }

    public void setSpreadMethod(Spread spreadMethod) {
        Spread oldSpreadMethod = this.spreadMethod;
        this.spreadMethod = spreadMethod;
        this.firePropertyChange("spreadMethod", (Object)oldSpreadMethod, (Object)this.spreadMethod);
    }

    public boolean unsetSpreadMethod() {
        if (this.isSetSpreadMethod()) {
            Spread oldSpreadMethod = this.spreadMethod;
            this.spreadMethod = null;
            this.firePropertyChange("spreadMethod", (Object)oldSpreadMethod, (Object)this.spreadMethod);
            return true;
        }
        return false;
    }

    public boolean isSetListOfGradientStops() {
        return this.listOfGradientStops != null && !this.listOfGradientStops.isEmpty();
    }

    public boolean isListOfGradientStopsEmpty() {
        return this.listOfGradientStops != null && this.listOfGradientStops.isEmpty();
    }

    public ListOf<GradientStop> getListOfGradientStops() {
        if (!this.isSetListOfGradientStops()) {
            this.listOfGradientStops = new ListOf(this.getLevel(), this.getVersion());
            this.listOfGradientStops.setPackageVersion(-1);
            this.listOfGradientStops.setPackageName(null);
            this.listOfGradientStops.setPackageName("render");
            this.listOfGradientStops.setSBaseListType(ListOf.Type.other);
            this.listOfGradientStops.setOtherListName("listOfGradientStops");
            this.registerChild((SBase)this.listOfGradientStops);
        }
        return this.listOfGradientStops;
    }

    public void setListOfGradientStops(ListOf<GradientStop> listOfGradientStops) {
        this.unsetListOfGradientStops();
        this.listOfGradientStops = listOfGradientStops;
        if (listOfGradientStops != null) {
            listOfGradientStops.setPackageVersion(-1);
            listOfGradientStops.setPackageName(null);
            listOfGradientStops.setPackageName("render");
            listOfGradientStops.setSBaseListType(ListOf.Type.other);
            listOfGradientStops.setOtherListName("listOfGradientStops");
            this.registerChild((SBase)this.listOfGradientStops);
        }
    }

    public boolean unsetListOfGradientStops() {
        if (this.isSetListOfGradientStops()) {
            ListOf<GradientStop> oldGradientStops = this.listOfGradientStops;
            this.listOfGradientStops = null;
            oldGradientStops.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addGradientStop(GradientStop field) {
        return this.getListOfGradientStops().add((SBase)field);
    }

    public boolean removeGradientStop(GradientStop field) {
        if (this.isSetListOfGradientStops()) {
            return this.getListOfGradientStops().remove((SBase)field);
        }
        return false;
    }

    public void removeGradientStop(int i) {
        if (!this.isSetListOfGradientStops()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfGradientStops().remove(i);
    }

    public GradientStop createGradientStop(RelAbsVector offset, String stopColor) {
        GradientStop field = new GradientStop(offset, stopColor, this.getLevel(), this.getVersion());
        this.addGradientStop(field);
        return field;
    }

    public boolean isIdMandatory() {
        return true;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("render:id", this.getId());
        }
        if (this.isSetSpreadMethod()) {
            attributes.put("render:spreadMethod", this.getSpreadMethod().toString().toLowerCase());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("spreadMethod")) {
                this.setSpreadMethod(Spread.valueOf(value.toUpperCase()));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public static enum Spread {
        PAD,
        REFLECT,
        REPEAT;

    }
}

