/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.ColorDefinition;
import org.sbml.jsbml.ext.render.LocalStyle;
import org.sbml.jsbml.ext.render.RenderInformationBase;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class LocalRenderInformation
extends RenderInformationBase {
    private static final long serialVersionUID = -8056565578647428405L;
    private ListOf<LocalStyle> listOfLocalStyles;

    public LocalRenderInformation() {
        this.initDefaults();
    }

    public LocalRenderInformation(String id) {
        super(id);
        this.initDefaults();
    }

    public LocalRenderInformation(int level, int version) {
        this(null, null, level, version);
    }

    public LocalRenderInformation(String id, int level, int version) {
        this(id, null, level, version);
    }

    public LocalRenderInformation(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public LocalRenderInformation(LocalRenderInformation obj) {
        super(obj);
        if (obj.isSetListOfLocalStyles()) {
            this.setListOfLocalStyles((ListOf<LocalStyle>)obj.listOfLocalStyles.clone());
        }
    }

    @Override
    public LocalRenderInformation clone() {
        return new LocalRenderInformation(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
        this.listOfLocalStyles = null;
    }

    @Override
    public int hashCode() {
        int prime = 3229;
        int result = super.hashCode();
        result = 3229 * result + (this.listOfLocalStyles == null ? 0 : this.listOfLocalStyles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalRenderInformation other = (LocalRenderInformation)((Object)obj);
        return !(this.listOfLocalStyles == null ? other.listOfLocalStyles != null : !this.listOfLocalStyles.equals(other.listOfLocalStyles));
    }

    public boolean isSetListOfLocalStyles() {
        return this.listOfLocalStyles != null && !this.listOfLocalStyles.isEmpty();
    }

    public boolean isListOfLocalStylesEmpty() {
        return this.listOfLocalStyles != null && this.listOfLocalStyles.isEmpty();
    }

    public String getElementName() {
        return "renderInformation";
    }

    public ListOf<LocalStyle> getListOfLocalStyles() {
        if (!this.isSetListOfLocalStyles()) {
            this.listOfLocalStyles = new ListOf(this.getLevel(), this.getVersion());
            this.listOfLocalStyles.setPackageVersion(-1);
            this.listOfLocalStyles.setPackageName(null);
            this.listOfLocalStyles.setPackageName("render");
            this.listOfLocalStyles.setSBaseListType(ListOf.Type.other);
            this.listOfLocalStyles.setOtherListName("listOfStyles");
            this.registerChild((SBase)this.listOfLocalStyles);
        }
        return this.listOfLocalStyles;
    }

    public void setListOfLocalStyles(ListOf<LocalStyle> listOfLocalStyles) {
        this.unsetListOfLocalStyles();
        this.listOfLocalStyles = listOfLocalStyles;
        if (listOfLocalStyles != null) {
            listOfLocalStyles.setPackageVersion(-1);
            listOfLocalStyles.setPackageName(null);
            listOfLocalStyles.setPackageName("render");
            listOfLocalStyles.setSBaseListType(ListOf.Type.other);
            listOfLocalStyles.setOtherListName("listOfStyles");
            this.registerChild((SBase)this.listOfLocalStyles);
        }
    }

    public boolean unsetListOfLocalStyles() {
        if (this.isSetListOfLocalStyles()) {
            ListOf<LocalStyle> oldLocalStyles = this.listOfLocalStyles;
            this.listOfLocalStyles = null;
            oldLocalStyles.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addLocalStyle(LocalStyle localStyle) {
        return this.getListOfLocalStyles().add((SBase)localStyle);
    }

    public boolean removeLocalStyle(LocalStyle localStyle) {
        if (this.isSetListOfLocalStyles()) {
            return this.getListOfLocalStyles().remove((SBase)localStyle);
        }
        return false;
    }

    public void removeLocalStyle(int i) {
        if (!this.isSetListOfLocalStyles()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfLocalStyles().remove(i);
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfLocalStyles()) {
            ++count;
        }
        return count;
    }

    @Override
    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfColorDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfColorDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfGradientDefinitions()) {
            if (pos == childIndex) {
                return this.getListOfGradientDefinitions();
            }
            ++pos;
        }
        if (this.isSetListOfLineEndings()) {
            if (pos == childIndex) {
                return this.getListOfLineEndings();
            }
            ++pos;
        }
        if (this.isSetListOfLocalStyles()) {
            if (pos == childIndex) {
                return this.getListOfLocalStyles();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        return isAttributeRead;
    }

    public ColorDefinition getColorDefinition(String id) {
        return this.isSetListOfColorDefinitions() ? (ColorDefinition)this.listOfColorDefinitions.firstHit((Filter)new NameFilter(id)) : null;
    }

    public int getColorDefinitionCount() {
        return this.isSetListOfColorDefinitions() ? this.listOfColorDefinitions.size() : 0;
    }

    public int getLocalStyleCount() {
        return this.isSetListOfLocalStyles() ? this.listOfLocalStyles.size() : 0;
    }
}

