/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.ICurve;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.render.GraphicalPrimitive1D;
import org.sbml.jsbml.ext.render.RenderCubicBezier;
import org.sbml.jsbml.ext.render.RenderPoint;

public class RenderCurve
extends GraphicalPrimitive1D
implements ICurve {
    private static final long serialVersionUID = -1941713884972334826L;
    protected String startHead;
    protected String endHead;
    protected ListOf<RenderPoint> listOfElements;
    protected ListOf<CurveSegment> listOfCurveSegments;

    public RenderCurve() {
        this.initDefaults();
    }

    public RenderCurve(RenderCurve obj) {
        if (obj.isSetStartHead()) {
            this.setStartHead(obj.startHead);
        }
        if (obj.isSetEndHead()) {
            this.setEndHead(obj.endHead);
        }
        if (obj.isSetListOfElements()) {
            this.setListOfElements((ListOf<RenderPoint>)obj.getListOfElements().clone());
        }
        if (obj.isSetListOfCurveSegments()) {
            this.setListOfCurveSegments((ListOf<CurveSegment>)obj.getListOfCurveSegments().clone());
        }
    }

    @Override
    public RenderCurve clone() {
        return new RenderCurve(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "render";
    }

    @Override
    public int hashCode() {
        int prime = 3119;
        int result = super.hashCode();
        result = 3119 * result + (this.endHead == null ? 0 : this.endHead.hashCode());
        result = 3119 * result + (this.listOfCurveSegments == null ? 0 : this.listOfCurveSegments.hashCode());
        result = 3119 * result + (this.listOfElements == null ? 0 : this.listOfElements.hashCode());
        result = 3119 * result + (this.startHead == null ? 0 : this.startHead.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RenderCurve other = (RenderCurve)((Object)obj);
        if (this.endHead == null ? other.endHead != null : !this.endHead.equals(other.endHead)) {
            return false;
        }
        if (this.listOfCurveSegments == null ? other.listOfCurveSegments != null : !this.listOfCurveSegments.equals(other.listOfCurveSegments)) {
            return false;
        }
        if (this.listOfElements == null ? other.listOfElements != null : !this.listOfElements.equals(other.listOfElements)) {
            return false;
        }
        return !(this.startHead == null ? other.startHead != null : !this.startHead.equals(other.startHead));
    }

    public String getElementName() {
        return "curve";
    }

    public String getStartHead() {
        if (this.isSetStartHead()) {
            return this.startHead;
        }
        throw new PropertyUndefinedError("startHead", (SBase)this);
    }

    public boolean isSetStartHead() {
        return this.startHead != null;
    }

    public void setStartHead(String startHead) {
        String oldStartHead = this.startHead;
        this.startHead = startHead;
        this.firePropertyChange("startHead", oldStartHead, this.startHead);
    }

    public boolean unsetStartHead() {
        if (this.isSetStartHead()) {
            String oldStartHead = this.startHead;
            this.startHead = null;
            this.firePropertyChange("startHead", oldStartHead, this.startHead);
            return true;
        }
        return false;
    }

    public String getEndHead() {
        if (this.isSetEndHead()) {
            return this.endHead;
        }
        throw new PropertyUndefinedError("endHead", (SBase)this);
    }

    public boolean isSetEndHead() {
        return this.endHead != null;
    }

    public void setEndHead(String endHead) {
        String oldEndHead = this.endHead;
        this.endHead = endHead;
        this.firePropertyChange("endHead", oldEndHead, this.endHead);
    }

    public boolean unsetEndHead() {
        if (this.isSetEndHead()) {
            String oldEndHead = this.endHead;
            this.endHead = null;
            this.firePropertyChange("endHead", oldEndHead, this.endHead);
            return true;
        }
        return false;
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null && !this.listOfElements.isEmpty();
    }

    public boolean isListOfElementsEmpty() {
        return this.listOfElements != null && this.listOfElements.isEmpty();
    }

    public ListOf<RenderPoint> getListOfElements() {
        if (!this.isSetListOfElements()) {
            this.listOfElements = new ListOf(this.getLevel(), this.getVersion());
            this.listOfElements.setPackageVersion(-1);
            this.listOfElements.setPackageName(null);
            this.listOfElements.setPackageName("render");
            this.listOfElements.setSBaseListType(ListOf.Type.other);
            this.listOfElements.setOtherListName("listOfElements");
            this.registerChild((SBase)this.listOfElements);
        }
        return this.listOfElements;
    }

    public void setListOfElements(ListOf<RenderPoint> listOfElements) {
        this.unsetListOfElements();
        this.listOfElements = listOfElements;
        if (listOfElements != null) {
            listOfElements.setPackageVersion(-1);
            listOfElements.setPackageName(null);
            listOfElements.setPackageName("render");
            listOfElements.setSBaseListType(ListOf.Type.other);
            listOfElements.setOtherListName("listOfElements");
            this.registerChild((SBase)this.listOfElements);
        }
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<RenderPoint> oldElements = this.listOfElements;
            this.listOfElements = null;
            oldElements.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addElement(RenderPoint element) {
        return this.getListOfElements().add((SBase)element);
    }

    public boolean removeElement(RenderPoint element) {
        if (this.isSetListOfElements()) {
            return this.getListOfElements().remove((SBase)element);
        }
        return false;
    }

    public void removeElement(int i) {
        if (!this.isSetListOfElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfElements().remove(i);
    }

    public RenderPoint createElement() {
        return this.createRenderPoint();
    }

    public RenderPoint createRenderCubicBezier() {
        RenderCubicBezier element = new RenderCubicBezier();
        this.addElement(element);
        return element;
    }

    public RenderPoint createRenderPoint() {
        RenderPoint element = new RenderPoint();
        this.addElement(element);
        return element;
    }

    public boolean isSetListOfCurveSegments() {
        return this.listOfCurveSegments != null;
    }

    public boolean isListOfCurveSegmentsEmpty() {
        return this.listOfCurveSegments != null && this.listOfCurveSegments.isEmpty();
    }

    public ListOf<CurveSegment> getListOfCurveSegments() {
        if (this.listOfCurveSegments == null) {
            this.listOfCurveSegments = new ListOf();
            this.listOfCurveSegments.setPackageVersion(-1);
            this.listOfCurveSegments.setPackageName(null);
            this.listOfCurveSegments.setPackageName("layout");
            this.listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            this.listOfCurveSegments.setOtherListName("listOfCurveSegments");
            this.registerChild((SBase)this.listOfCurveSegments);
        }
        return this.listOfCurveSegments;
    }

    public void setListOfCurveSegments(ListOf<CurveSegment> listOfCurveSegments) {
        this.unsetListOfCurveSegments();
        this.listOfCurveSegments = listOfCurveSegments;
        if (listOfCurveSegments != null) {
            listOfCurveSegments.setPackageVersion(-1);
            listOfCurveSegments.setPackageName(null);
            listOfCurveSegments.setPackageName("layout");
            listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            listOfCurveSegments.setOtherListName("listOfCurveSegments");
            this.registerChild((SBase)listOfCurveSegments);
        }
    }

    public boolean unsetListOfCurveSegments() {
        if (this.isSetListOfCurveSegments()) {
            ListOf<CurveSegment> oldCurveSegments = this.listOfCurveSegments;
            this.listOfCurveSegments = null;
            oldCurveSegments.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addCurveSegment(CurveSegment curveSegment) {
        return this.getListOfCurveSegments().add((SBase)curveSegment);
    }

    public void addCurveSegment(int index, CurveSegment element) {
        this.getListOfCurveSegments().add(index, (SBase)element);
    }

    public boolean removeCurveSegment(CurveSegment curveSegment) {
        if (this.isSetListOfCurveSegments()) {
            return this.getListOfCurveSegments().remove((SBase)curveSegment);
        }
        return false;
    }

    public CurveSegment removeCurveSegment(int i) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CurveSegment)this.getListOfCurveSegments().remove(i);
    }

    public LineSegment createLineSegment() {
        LineSegment curveSegment = new LineSegment(this.getLevel(), this.getVersion());
        this.addCurveSegment((CurveSegment)curveSegment);
        return curveSegment;
    }

    public CubicBezier createCubicBezier() {
        CubicBezier curveSegment = new CubicBezier(this.getLevel(), this.getVersion());
        this.addCurveSegment((CurveSegment)curveSegment);
        return curveSegment;
    }

    public CurveSegment getCurveSegment(int i) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CurveSegment)this.getListOfCurveSegments().get(i);
    }

    public int getCurveSegmentCount() {
        return this.isSetListOfCurveSegments() ? this.getListOfCurveSegments().size() : 0;
    }

    public int getNumCurveSegments() {
        return this.getCurveSegmentCount();
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetStartHead()) {
            attributes.remove("startHead");
            attributes.put("render:startHead", this.getStartHead());
        }
        if (this.isSetEndHead()) {
            attributes.remove("endHead");
            attributes.put("render:endHead", this.getEndHead());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("startHead")) {
                this.setStartHead(value);
            } else if (attributeName.equals("endHead")) {
                this.setEndHead(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfElements()) {
            if (pos == childIndex) {
                return this.getListOfElements();
            }
            ++pos;
        }
        if (this.isSetListOfCurveSegments()) {
            if (pos == childIndex) {
                return this.getListOfCurveSegments();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfElements()) {
            ++count;
        }
        if (this.isSetListOfCurveSegments()) {
            ++count;
        }
        return count;
    }
}

